/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kapua.service.user.internal;

import org.eclipse.kapua.KapuaEntityNotFoundException;
import org.eclipse.kapua.KapuaException;
import org.eclipse.kapua.commons.jpa.EntityManager;
import org.eclipse.kapua.commons.service.internal.ServiceDAO;
import org.eclipse.kapua.model.KapuaEntity;
import org.eclipse.kapua.model.KapuaUpdatableEntity;
import org.eclipse.kapua.model.id.KapuaId;
import org.eclipse.kapua.model.query.KapuaListResult;
import org.eclipse.kapua.model.query.KapuaQuery;
import org.eclipse.kapua.service.user.User;
import org.eclipse.kapua.service.user.UserCreator;
import org.eclipse.kapua.service.user.UserListResult;
import org.eclipse.kapua.service.user.internal.UserImpl;
import org.eclipse.kapua.service.user.internal.UserListResultImpl;

public class UserDAO
extends ServiceDAO {
    public static User create(EntityManager em, UserCreator userCreator) throws KapuaException {
        UserImpl userImpl = new UserImpl(userCreator.getScopeId(), userCreator.getName());
        userImpl.setDisplayName(userCreator.getDisplayName());
        userImpl.setEmail(userCreator.getEmail());
        userImpl.setPhoneNumber(userCreator.getPhoneNumber());
        userImpl.setUserType(userCreator.getUserType());
        userImpl.setExternalId(userCreator.getExternalId());
        userImpl.setStatus(userCreator.getUserStatus());
        userImpl.setExpirationDate(userCreator.getExpirationDate());
        return (User)ServiceDAO.create((EntityManager)em, (KapuaEntity)userImpl);
    }

    public static User update(EntityManager em, User user) throws KapuaException {
        UserImpl userImpl = (UserImpl)user;
        return (User)ServiceDAO.update((EntityManager)em, UserImpl.class, (KapuaUpdatableEntity)userImpl);
    }

    public static void delete(EntityManager em, KapuaId userId) throws KapuaEntityNotFoundException {
        ServiceDAO.delete((EntityManager)em, UserImpl.class, (KapuaId)userId);
    }

    public static User find(EntityManager em, KapuaId userId) {
        return (User)em.find(UserImpl.class, userId);
    }

    public static User findByName(EntityManager em, String name) {
        return (User)ServiceDAO.findByField((EntityManager)em, UserImpl.class, (String)"name", (String)name);
    }

    public static User findByExternalId(EntityManager em, String externalId) {
        return (User)ServiceDAO.findByField((EntityManager)em, UserImpl.class, (String)"externalId", (String)externalId);
    }

    public static UserListResult query(EntityManager em, KapuaQuery<User> userPermissionQuery) throws KapuaException {
        return (UserListResult)ServiceDAO.query((EntityManager)em, User.class, UserImpl.class, (KapuaListResult)new UserListResultImpl(), userPermissionQuery);
    }

    public static long count(EntityManager em, KapuaQuery<User> userPermissionQuery) throws KapuaException {
        return ServiceDAO.count((EntityManager)em, User.class, UserImpl.class, userPermissionQuery);
    }
}

