/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kapua.service.stream.internal;

import com.google.common.base.Strings;
import java.util.Date;
import java.util.HashMap;
import org.eclipse.kapua.KapuaEntityNotFoundException;
import org.eclipse.kapua.KapuaException;
import org.eclipse.kapua.KapuaIllegalArgumentException;
import org.eclipse.kapua.commons.util.ArgumentValidator;
import org.eclipse.kapua.locator.KapuaLocator;
import org.eclipse.kapua.locator.KapuaProvider;
import org.eclipse.kapua.message.Message;
import org.eclipse.kapua.message.device.data.KapuaDataMessage;
import org.eclipse.kapua.model.domain.Actions;
import org.eclipse.kapua.model.domain.Domain;
import org.eclipse.kapua.model.query.KapuaQuery;
import org.eclipse.kapua.model.query.predicate.QueryPredicate;
import org.eclipse.kapua.service.authorization.AuthorizationService;
import org.eclipse.kapua.service.authorization.permission.PermissionFactory;
import org.eclipse.kapua.service.device.call.kura.exception.KuraDeviceCallErrorCodes;
import org.eclipse.kapua.service.device.call.kura.exception.KuraDeviceCallException;
import org.eclipse.kapua.service.device.call.message.kura.data.KuraDataMessage;
import org.eclipse.kapua.service.device.management.message.response.KapuaResponseMessage;
import org.eclipse.kapua.service.device.registry.Device;
import org.eclipse.kapua.service.device.registry.DeviceRegistryService;
import org.eclipse.kapua.service.endpoint.EndpointInfo;
import org.eclipse.kapua.service.endpoint.EndpointInfoFactory;
import org.eclipse.kapua.service.endpoint.EndpointInfoQuery;
import org.eclipse.kapua.service.endpoint.EndpointInfoService;
import org.eclipse.kapua.service.stream.StreamDomains;
import org.eclipse.kapua.service.stream.StreamService;
import org.eclipse.kapua.translator.Translator;
import org.eclipse.kapua.translator.exception.TranslatorNotFoundException;
import org.eclipse.kapua.transport.TransportClientFactory;
import org.eclipse.kapua.transport.TransportFacade;
import org.eclipse.kapua.transport.exception.TransportClientGetException;
import org.eclipse.kapua.transport.message.TransportMessage;

@KapuaProvider
public class StreamServiceImpl
implements StreamService {
    private static final KapuaLocator LOCATOR = KapuaLocator.getInstance();
    private static final AuthorizationService AUTHORIZATION_SERVICE = (AuthorizationService)LOCATOR.getService(AuthorizationService.class);
    private static final PermissionFactory PERMISSION_FACTORY = (PermissionFactory)LOCATOR.getFactory(PermissionFactory.class);
    private static final DeviceRegistryService DEVICE_REGISTRY_SERVICE = (DeviceRegistryService)LOCATOR.getService(DeviceRegistryService.class);
    private static final EndpointInfoService ENDPOINT_INFO_SERVICE = (EndpointInfoService)LOCATOR.getService(EndpointInfoService.class);
    private static final EndpointInfoFactory ENDPOINT_INFO_FACTORY = (EndpointInfoFactory)LOCATOR.getFactory(EndpointInfoFactory.class);
    private static final TransportClientFactory TRANSPORT_CLIENT_FACTORY = (TransportClientFactory)LOCATOR.getFactory(TransportClientFactory.class);

    public KapuaResponseMessage<?, ?> publish(KapuaDataMessage kapuaDataMessage, Long timeout) throws KapuaException {
        ArgumentValidator.notNull((Object)kapuaDataMessage.getScopeId(), (String)"dataMessage.scopeId");
        ArgumentValidator.notNull((Object)kapuaDataMessage.getChannel(), (String)"dataMessage.channel");
        AUTHORIZATION_SERVICE.checkPermission(PERMISSION_FACTORY.newPermission((Domain)StreamDomains.STREAM_DOMAIN, Actions.write, kapuaDataMessage.getScopeId()));
        try (TransportFacade<?, ?, ?, ?> transportFacade = this.borrowClient(kapuaDataMessage);){
            Translator<KapuaDataMessage, KuraDataMessage> translatorKapuaKura = this.getTranslator(KapuaDataMessage.class, KuraDataMessage.class);
            Translator translatorKuraTransport = this.getTranslator(KuraDataMessage.class, transportFacade.getMessageClass());
            KuraDataMessage kuraDataMessage = (KuraDataMessage)translatorKapuaKura.translate((Message)kapuaDataMessage);
            kuraDataMessage.setTimestamp(new Date());
            transportFacade.sendAsync((TransportMessage)translatorKuraTransport.translate((Message)kuraDataMessage));
        }
        catch (KapuaException ke) {
            throw new KuraDeviceCallException(KuraDeviceCallErrorCodes.CALL_ERROR, (Throwable)ke, (Object[])null);
        }
        return null;
    }

    protected TransportFacade<?, ?, ?, ?> borrowClient(KapuaDataMessage kapuaDataMessage) throws KuraDeviceCallException {
        String serverURI = null;
        try {
            Device device = this.checkDeviceInfo(kapuaDataMessage);
            serverURI = device != null ? device.getConnection().getServerIp() : this.getEndpointInfoDNS(kapuaDataMessage);
            if (Strings.isNullOrEmpty((String)serverURI)) {
                throw new TransportClientGetException(serverURI);
            }
            HashMap<String, String> configParameters = new HashMap<String, String>(1);
            configParameters.put("serverAddress", serverURI);
            return TRANSPORT_CLIENT_FACTORY.getFacade(configParameters);
        }
        catch (Exception e) {
            throw new KuraDeviceCallException(KuraDeviceCallErrorCodes.CALL_ERROR, (Throwable)e, new Object[]{serverURI});
        }
    }

    private Device checkDeviceInfo(KapuaDataMessage dataMessage) throws KapuaException {
        Device device = null;
        if (dataMessage.getDeviceId() != null) {
            device = (Device)DEVICE_REGISTRY_SERVICE.find(dataMessage.getScopeId(), dataMessage.getDeviceId());
            if (device == null) {
                throw new KapuaEntityNotFoundException("device", dataMessage.getDeviceId());
            }
            if (dataMessage.getClientId() == null) {
                dataMessage.setClientId(device.getClientId());
            } else if (!device.getClientId().equals(dataMessage.getClientId())) {
                throw new KapuaIllegalArgumentException("dataMessage.clientId", dataMessage.getClientId());
            }
        }
        return device;
    }

    private String getEndpointInfoDNS(KapuaDataMessage dataMessage) throws KapuaException {
        EndpointInfoQuery query = (EndpointInfoQuery)ENDPOINT_INFO_FACTORY.newQuery(dataMessage.getScopeId());
        query.setPredicate((QueryPredicate)query.andPredicate(new QueryPredicate[]{query.attributePredicate("schema", (Object)"mqtt"), query.attributePredicate("secure", (Object)Boolean.FALSE)}));
        EndpointInfo endpointInfo = (EndpointInfo)ENDPOINT_INFO_SERVICE.query((KapuaQuery)query).getFirstItem();
        if (endpointInfo == null) {
            throw KapuaException.internalError((String)"No endpoint defined!");
        }
        String serverURI = endpointInfo.getDns();
        return serverURI;
    }

    protected <F extends Message<?, ?>, T extends Message<?, ?>> Translator<F, T> getTranslator(Class<F> from, Class<T> to) throws KuraDeviceCallException {
        Translator translator;
        try {
            translator = Translator.getTranslatorFor(from, to);
        }
        catch (TranslatorNotFoundException e) {
            throw new KuraDeviceCallException(KuraDeviceCallErrorCodes.CALL_ERROR, (Throwable)e, new Object[]{from, to});
        }
        return translator;
    }
}

