/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.maven.plugin.mojo.build;

import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.settings.Server;
import org.eclipse.jkube.kit.common.KitLogger;
import org.eclipse.jkube.kit.resource.helm.HelmConfig;
import org.eclipse.jkube.kit.resource.helm.HelmRepository;
import org.eclipse.jkube.kit.resource.helm.HelmService;
import org.eclipse.jkube.maven.plugin.mojo.build.HelmMojo;
import org.sonatype.plexus.components.sec.dispatcher.DefaultSecDispatcher;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcher;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcherException;

@Mojo(name="helm-push", defaultPhase=LifecyclePhase.INSTALL, requiresDependencyResolution=ResolutionScope.COMPILE)
public class HelmPushMojo
extends HelmMojo {
    protected static final String PROPERTY_UPLOAD_REPO_SNAPSHOT_NAME = "jkube.helm.snapshotRepository.name";
    protected static final String PROPERTY_UPLOAD_REPO_SNAPSHOT_URL = "jkube.helm.snapshotRepository.url";
    protected static final String PROPERTY_UPLOAD_REPO_SNAPSHOT_USERNAME = "jkube.helm.snapshotRepository.username";
    protected static final String PROPERTY_UPLOAD_REPO_SNAPSHOT_PASSWORD = "jkube.helm.snapshotRepository.password";
    protected static final String PROPERTY_UPLOAD_REPO_SNAPSHOT_TYPE = "jkube.helm.snapshotRepository.type";
    protected static final String PROPERTY_UPLOAD_REPO_STABLE_NAME = "jkube.helm.stableRepository.name";
    protected static final String PROPERTY_UPLOAD_REPO_STABLE_URL = "jkube.helm.stableRepository.url";
    protected static final String PROPERTY_UPLOAD_REPO_STABLE_USERNAME = "jkube.helm.stableRepository.username";
    protected static final String PROPERTY_UPLOAD_REPO_STABLE_PASSWORD = "jkube.helm.stableRepository.password";
    protected static final String PROPERTY_UPLOAD_REPO_STABLE_TYPE = "jkube.helm.stableRepository.type";
    protected static final String PROPERTY_SECURITY = "jkube.helm.security";
    protected static final String DEFAULT_SECURITY = "~/.m2/settings-security.xml";
    @Component(role=SecDispatcher.class, hint="default")
    protected SecDispatcher securityDispatcher;

    @Override
    protected boolean canExecute() {
        return super.canExecute() && !this.skip;
    }

    @Override
    public void executeInternal() throws MojoExecutionException {
        if (this.skip) {
            return;
        }
        try {
            super.executeInternal();
            HelmRepository helmRepository = this.getHelmRepository();
            if (!HelmPushMojo.isRepositoryValid(helmRepository)) {
                String error = "No repository or invalid repository configured for upload";
                this.getKitLogger().error(error, new Object[0]);
                throw new MojoExecutionException(error);
            }
            this.setAuthentication(helmRepository);
            HelmService.uploadHelmChart((KitLogger)this.getKitLogger(), (HelmConfig)this.helm, (HelmRepository)helmRepository);
        }
        catch (Exception exp) {
            this.getKitLogger().error("Error performing helm push", new Object[]{exp});
            throw new MojoExecutionException(exp.getMessage(), exp);
        }
    }

    private static boolean isRepositoryValid(HelmRepository repository) {
        return repository != null && repository.getType() != null && StringUtils.isNotBlank((CharSequence)repository.getName()) && StringUtils.isNotBlank((CharSequence)repository.getUrl());
    }

    @Override
    protected void initDefaults() throws IOException, MojoExecutionException {
        super.initDefaults();
        if (this.getHelm().getStableRepository() == null) {
            this.getHelm().setStableRepository(new HelmRepository());
        }
        HelmRepository stableRepository = this.getHelm().getStableRepository();
        this.initFromPropertyOrDefault(PROPERTY_UPLOAD_REPO_STABLE_TYPE, () -> ((HelmRepository)stableRepository).getTypeAsString(), arg_0 -> ((HelmRepository)stableRepository).setType(arg_0), null);
        this.initFromPropertyOrDefault(PROPERTY_UPLOAD_REPO_STABLE_NAME, () -> ((HelmRepository)stableRepository).getName(), arg_0 -> ((HelmRepository)stableRepository).setName(arg_0), null);
        this.initFromPropertyOrDefault(PROPERTY_UPLOAD_REPO_STABLE_URL, () -> ((HelmRepository)stableRepository).getUrl(), arg_0 -> ((HelmRepository)stableRepository).setUrl(arg_0), null);
        this.initFromPropertyOrDefault(PROPERTY_UPLOAD_REPO_STABLE_USERNAME, () -> ((HelmRepository)stableRepository).getUsername(), arg_0 -> ((HelmRepository)stableRepository).setUsername(arg_0), null);
        this.initFromPropertyOrDefault(PROPERTY_UPLOAD_REPO_STABLE_PASSWORD, () -> ((HelmRepository)stableRepository).getPassword(), arg_0 -> ((HelmRepository)stableRepository).setPassword(arg_0), null);
        if (this.getHelm().getSnapshotRepository() == null) {
            this.getHelm().setSnapshotRepository(new HelmRepository());
        }
        HelmRepository snapshotRepository = this.getHelm().getSnapshotRepository();
        this.initFromPropertyOrDefault(PROPERTY_UPLOAD_REPO_SNAPSHOT_TYPE, () -> ((HelmRepository)snapshotRepository).getTypeAsString(), arg_0 -> ((HelmRepository)snapshotRepository).setType(arg_0), null);
        this.initFromPropertyOrDefault(PROPERTY_UPLOAD_REPO_SNAPSHOT_NAME, () -> ((HelmRepository)snapshotRepository).getName(), arg_0 -> ((HelmRepository)snapshotRepository).setName(arg_0), null);
        this.initFromPropertyOrDefault(PROPERTY_UPLOAD_REPO_SNAPSHOT_URL, () -> ((HelmRepository)snapshotRepository).getUrl(), arg_0 -> ((HelmRepository)snapshotRepository).setUrl(arg_0), null);
        this.initFromPropertyOrDefault(PROPERTY_UPLOAD_REPO_SNAPSHOT_USERNAME, () -> ((HelmRepository)snapshotRepository).getUsername(), arg_0 -> ((HelmRepository)snapshotRepository).setUsername(arg_0), null);
        this.initFromPropertyOrDefault(PROPERTY_UPLOAD_REPO_SNAPSHOT_PASSWORD, () -> ((HelmRepository)snapshotRepository).getPassword(), arg_0 -> ((HelmRepository)snapshotRepository).setPassword(arg_0), null);
        this.initFromPropertyOrDefault(PROPERTY_SECURITY, () -> ((HelmConfig)this.helm).getSecurity(), arg_0 -> ((HelmConfig)this.helm).setSecurity(arg_0), DEFAULT_SECURITY);
    }

    private HelmRepository getHelmRepository() {
        if (this.getHelm().getVersion() != null && this.getHelm().getVersion().endsWith("-SNAPSHOT")) {
            return this.getHelm().getSnapshotRepository();
        }
        return this.getHelm().getStableRepository();
    }

    private void setAuthentication(HelmRepository repository) throws SecDispatcherException {
        String id = repository.getName();
        String REPO = "Repo ";
        if (repository.getUsername() != null) {
            if (repository.getPassword() == null) {
                throw new IllegalArgumentException("Repo " + id + " has a username but no password defined.");
            }
            this.getKitLogger().debug("Repo " + id + " has credentials defined, skip searching in server list.", new Object[0]);
        } else {
            Server server = this.getSettings().getServer(id);
            if (server == null) {
                throw new IllegalArgumentException("No credentials found for " + id + " in configuration or settings.xml server list.");
            }
            this.getKitLogger().debug("Use credentials from server list for " + id + ".", new Object[0]);
            if (server.getUsername() == null || server.getPassword() == null) {
                throw new IllegalArgumentException("Repo " + id + " was found in server list but has no username/password.");
            }
            repository.setUsername(server.getUsername());
            repository.setPassword(this.getSecDispatcher().decrypt(server.getPassword()));
        }
    }

    protected SecDispatcher getSecDispatcher() {
        if (this.securityDispatcher instanceof DefaultSecDispatcher) {
            ((DefaultSecDispatcher)this.securityDispatcher).setConfigurationFile(this.getHelm().getSecurity());
        }
        return this.securityDispatcher;
    }
}

