/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.api;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.LambdaMetafactory;
import java.nio.ByteBuffer;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.zip.InflaterInputStream;
import org.eclipse.jgit.api.ApplyResult;
import org.eclipse.jgit.api.GitCommand;
import org.eclipse.jgit.api.errors.FilterFailedException;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.PatchApplyException;
import org.eclipse.jgit.api.errors.PatchFormatException;
import org.eclipse.jgit.attributes.FilterCommand;
import org.eclipse.jgit.attributes.FilterCommandRegistry;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.diff.RawText;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheCheckout;
import org.eclipse.jgit.dircache.DirCacheIterator;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.CoreConfig;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.patch.BinaryHunk;
import org.eclipse.jgit.patch.FileHeader;
import org.eclipse.jgit.patch.HunkHeader;
import org.eclipse.jgit.patch.Patch;
import org.eclipse.jgit.treewalk.FileTreeIterator;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.AndTreeFilter;
import org.eclipse.jgit.treewalk.filter.NotIgnoredFilter;
import org.eclipse.jgit.treewalk.filter.PathFilterGroup;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.FileUtils;
import org.eclipse.jgit.util.IO;
import org.eclipse.jgit.util.RawParseUtils;
import org.eclipse.jgit.util.StringUtils;
import org.eclipse.jgit.util.TemporaryBuffer;
import org.eclipse.jgit.util.io.BinaryDeltaInputStream;
import org.eclipse.jgit.util.io.BinaryHunkInputStream;
import org.eclipse.jgit.util.io.EolStreamTypeUtil;
import org.eclipse.jgit.util.sha1.SHA1;

public class ApplyCommand
extends GitCommand<ApplyResult> {
    private InputStream in;
    private static volatile /* synthetic */ int[] $SWITCH_TABLE$org$eclipse$jgit$patch$BinaryHunk$Type;

    ApplyCommand(Repository repo) {
        super(repo);
    }

    public ApplyCommand setPatch(InputStream in) {
        this.checkCallable();
        this.in = in;
        return this;
    }

    @Override
    public ApplyResult call() throws GitAPIException, PatchFormatException, PatchApplyException {
        this.checkCallable();
        this.setCallable(false);
        ApplyResult r = new ApplyResult();
        try {
            Patch p = new Patch();
            try {
                p.parse(this.in);
            }
            finally {
                this.in.close();
            }
            if (!p.getErrors().isEmpty()) {
                throw new PatchFormatException(p.getErrors());
            }
            Repository repository = this.getRepository();
            DirCache cache = repository.readDirCache();
            for (FileHeader fileHeader : p.getFiles()) {
                DiffEntry.ChangeType type = fileHeader.getChangeType();
                File f = null;
                switch (type) {
                    case ADD: {
                        f = this.getFile(fileHeader.getNewPath(), true);
                        this.apply(repository, fileHeader.getNewPath(), cache, f, fileHeader);
                        break;
                    }
                    case MODIFY: {
                        f = this.getFile(fileHeader.getOldPath(), false);
                        this.apply(repository, fileHeader.getOldPath(), cache, f, fileHeader);
                        break;
                    }
                    case DELETE: {
                        f = this.getFile(fileHeader.getOldPath(), false);
                        if (f.delete()) break;
                        throw new PatchApplyException(MessageFormat.format(JGitText.get().cannotDeleteFile, f));
                    }
                    case RENAME: {
                        f = this.getFile(fileHeader.getOldPath(), false);
                        File dest = this.getFile(fileHeader.getNewPath(), false);
                        try {
                            FileUtils.mkdirs(dest.getParentFile(), true);
                            FileUtils.rename(f, dest, StandardCopyOption.ATOMIC_MOVE);
                        }
                        catch (IOException e) {
                            throw new PatchApplyException(MessageFormat.format(JGitText.get().renameFileFailed, f, dest), e);
                        }
                        this.apply(repository, fileHeader.getOldPath(), cache, dest, fileHeader);
                        r.addUpdatedFile(dest);
                        break;
                    }
                    case COPY: {
                        File src = this.getFile(fileHeader.getOldPath(), false);
                        f = this.getFile(fileHeader.getNewPath(), false);
                        FileUtils.mkdirs(f.getParentFile(), true);
                        Files.copy(src.toPath(), f.toPath(), new CopyOption[0]);
                        this.apply(repository, fileHeader.getOldPath(), cache, f, fileHeader);
                    }
                }
                r.addUpdatedFile(f);
            }
        }
        catch (IOException e) {
            throw new PatchApplyException(MessageFormat.format(JGitText.get().patchApplyException, e.getMessage()), e);
        }
        return r;
    }

    private File getFile(String path, boolean create) throws PatchApplyException {
        File f = new File(this.getRepository().getWorkTree(), path);
        if (create) {
            try {
                File parent = f.getParentFile();
                FileUtils.mkdirs(parent, true);
                FileUtils.createNewFile(f);
            }
            catch (IOException e) {
                throw new PatchApplyException(MessageFormat.format(JGitText.get().createNewFileFailed, f), e);
            }
        }
        return f;
    }

    private void apply(Repository repository, String path, DirCache cache, File f, FileHeader fh) throws IOException, PatchApplyException {
        DirCacheCheckout.CheckoutMetadata checkOut;
        boolean convertCrLf;
        block34: {
            if (FileHeader.PatchType.BINARY.equals((Object)fh.getPatchType())) {
                return;
            }
            convertCrLf = this.needsCrLfConversion(f, fh);
            Throwable throwable = null;
            Object var8_9 = null;
            try (TreeWalk walk = new TreeWalk(repository);){
                walk.setOperationType(TreeWalk.OperationType.CHECKIN_OP);
                FileTreeIterator files = new FileTreeIterator(repository);
                int fileIdx = walk.addTree(files);
                int cacheIdx = walk.addTree(new DirCacheIterator(cache));
                files.setDirCacheIterator(walk, cacheIdx);
                walk.setFilter(AndTreeFilter.create(PathFilterGroup.createFromStrings(path), new NotIgnoredFilter(fileIdx)));
                walk.setRecursive(true);
                if (!walk.next()) break block34;
                CoreConfig.EolStreamType streamType = convertCrLf ? CoreConfig.EolStreamType.TEXT_CRLF : walk.getEolStreamType(TreeWalk.OperationType.CHECKOUT_OP);
                String command = walk.getFilterCommand("smudge");
                DirCacheCheckout.CheckoutMetadata checkOut2 = new DirCacheCheckout.CheckoutMetadata(streamType, command);
                FileTreeIterator file = walk.getTree(fileIdx, FileTreeIterator.class);
                if (file == null) break block34;
                if (FileHeader.PatchType.GIT_BINARY.equals((Object)fh.getPatchType())) {
                    this.applyBinary(repository, path, f, fh, file::openEntryStream, file.getEntryObjectId(), checkOut2);
                } else {
                    RawText raw;
                    command = walk.getFilterCommand("clean");
                    Throwable throwable2 = null;
                    Object var20_24 = null;
                    try (InputStream input = this.filterClean(repository, path, new FileInputStream(f), convertCrLf, command);){
                        raw = new RawText(IO.readWholeStream(input, 0).array());
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                    this.applyText(repository, path, raw, f, fh, checkOut2);
                }
                return;
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        if (FileHeader.PatchType.GIT_BINARY.equals((Object)fh.getPatchType())) {
            checkOut = new DirCacheCheckout.CheckoutMetadata(CoreConfig.EolStreamType.DIRECT, null);
            this.applyBinary(repository, path, f, fh, () -> new FileInputStream(f), null, checkOut);
        } else {
            RawText raw;
            if (convertCrLf) {
                Throwable throwable = null;
                Object var10_13 = null;
                try (InputStream input = EolStreamTypeUtil.wrapInputStream(new FileInputStream(f), CoreConfig.EolStreamType.TEXT_LF);){
                    raw = new RawText(IO.readWholeStream(input, 0).array());
                }
                catch (Throwable throwable5) {
                    if (throwable == null) {
                        throwable = throwable5;
                    } else if (throwable != throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                    throw throwable;
                }
                checkOut = new DirCacheCheckout.CheckoutMetadata(CoreConfig.EolStreamType.TEXT_CRLF, null);
            } else {
                raw = new RawText(f);
                checkOut = new DirCacheCheckout.CheckoutMetadata(CoreConfig.EolStreamType.DIRECT, null);
            }
            this.applyText(repository, path, raw, f, fh, checkOut);
        }
    }

    private boolean needsCrLfConversion(File f, FileHeader fileHeader) throws IOException {
        if (FileHeader.PatchType.GIT_BINARY.equals((Object)fileHeader.getPatchType())) {
            return false;
        }
        if (!ApplyCommand.hasCrLf(fileHeader)) {
            Throwable throwable = null;
            Object var4_5 = null;
            try (FileInputStream input = new FileInputStream(f);){
                return RawText.isCrLfText(input);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        return false;
    }

    private static boolean hasCrLf(FileHeader fileHeader) {
        if (FileHeader.PatchType.GIT_BINARY.equals((Object)fileHeader.getPatchType())) {
            return false;
        }
        block0: for (HunkHeader hunkHeader : fileHeader.getHunks()) {
            byte[] buf = hunkHeader.getBuffer();
            int hunkEnd = hunkHeader.getEndOffset();
            int lineStart = hunkHeader.getStartOffset();
            while (lineStart < hunkEnd) {
                char first;
                int nextLineStart = RawParseUtils.nextLF(buf, lineStart);
                if (nextLineStart > hunkEnd) {
                    nextLineStart = hunkEnd;
                }
                if (nextLineStart <= lineStart) continue block0;
                if (nextLineStart - lineStart > 1 && ((first = (char)(buf[lineStart] & 0xFF)) == ' ' || first == '-') && buf[nextLineStart - 2] == 13) {
                    return true;
                }
                lineStart = nextLineStart;
            }
        }
        return false;
    }

    private InputStream filterClean(Repository repository, String path, InputStream fromFile, boolean convertCrLf, String filterCommand) throws IOException {
        FS.ExecutionResult result;
        InputStream input = fromFile;
        if (convertCrLf) {
            input = EolStreamTypeUtil.wrapInputStream(input, CoreConfig.EolStreamType.TEXT_LF);
        }
        if (StringUtils.isEmptyOrNull(filterCommand)) {
            return input;
        }
        if (FilterCommandRegistry.isRegistered(filterCommand)) {
            TemporaryBuffer.LocalFile buffer = new TemporaryBuffer.LocalFile(null);
            FilterCommand command = FilterCommandRegistry.createFilterCommand(filterCommand, repository, input, buffer);
            while (command.run() != -1) {
            }
            return buffer.openInputStreamWithAutoDestroy();
        }
        FS fs = repository.getFS();
        ProcessBuilder filterProcessBuilder = fs.runInShell(filterCommand, new String[0]);
        filterProcessBuilder.directory(repository.getWorkTree());
        filterProcessBuilder.environment().put("GIT_DIR", repository.getDirectory().getAbsolutePath());
        try {
            result = fs.execute(filterProcessBuilder, this.in);
        }
        catch (IOException | InterruptedException e) {
            throw new IOException(new FilterFailedException(e, filterCommand, path));
        }
        int rc = result.getRc();
        if (rc != 0) {
            throw new IOException(new FilterFailedException(rc, filterCommand, path, result.getStdout().toByteArray(4096), RawParseUtils.decode(result.getStderr().toByteArray(4096))));
        }
        return result.getStdout().openInputStreamWithAutoDestroy();
    }

    private void initHash(SHA1 hash, long size) {
        hash.update(Constants.encodedTypeString(3));
        hash.update((byte)32);
        hash.update(Constants.encodeASCII(size));
        hash.update((byte)0);
    }

    private ObjectId hash(File f) throws IOException {
        SHA1 hash = SHA1.newInstance();
        this.initHash(hash, f.length());
        Throwable throwable = null;
        Object var4_5 = null;
        try (FileInputStream input = new FileInputStream(f);){
            int n;
            byte[] buf = new byte[8192];
            while ((n = ((InputStream)input).read(buf)) >= 0) {
                hash.update(buf, 0, n);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return hash.toObjectId();
    }

    private void checkOid(ObjectId baseId, ObjectId id, DiffEntry.ChangeType type, File f, String path) throws PatchApplyException, IOException {
        boolean hashOk = false;
        if (id != null) {
            hashOk = baseId.equals(id);
            if (!hashOk && DiffEntry.ChangeType.ADD.equals((Object)type) && ObjectId.zeroId().equals(baseId)) {
                hashOk = Constants.EMPTY_BLOB_ID.equals(id);
            }
        } else {
            hashOk = ObjectId.zeroId().equals(baseId) ? !f.exists() || f.length() == 0L : baseId.equals(this.hash(f));
        }
        if (!hashOk) {
            throw new PatchApplyException(MessageFormat.format(JGitText.get().applyBinaryBaseOidWrong, path));
        }
    }

    /*
     * Unable to fully structure code
     */
    private void applyBinary(Repository repository, String path, File f, FileHeader fh, DirCacheCheckout.StreamSupplier loader, ObjectId id, DirCacheCheckout.CheckoutMetadata checkOut) throws PatchApplyException, IOException {
        if (!fh.getOldId().isComplete() || !fh.getNewId().isComplete()) {
            throw new PatchApplyException(MessageFormat.format(JGitText.get().applyBinaryOidTooShort, new Object[]{path}));
        }
        hunk = fh.getForwardBinaryHunk();
        start = RawParseUtils.nextLF(hunk.getBuffer(), hunk.getStartOffset());
        length = hunk.getEndOffset() - start;
        hash = SHA1.newInstance();
        buffer = new TemporaryBuffer.LocalFile(null);
        try {
            switch (ApplyCommand.$SWITCH_TABLE$org$eclipse$jgit$patch$BinaryHunk$Type()[hunk.getType().ordinal()]) {
                case 1: {
                    this.checkOid(fh.getOldId().toObjectId(), id, fh.getChangeType(), f, path);
                    this.initHash(hash, hunk.getSize());
                    var13_13 = null;
                    var14_17 = null;
                    try {
                        out = buffer;
                        try {
                            inflated = new SHA1InputStream(hash, new InflaterInputStream(new BinaryHunkInputStream(new ByteArrayInputStream(hunk.getBuffer(), start, length))));
                            try {
                                DirCacheCheckout.getContent(repository, path, checkOut, (DirCacheCheckout.StreamSupplier)LambdaMetafactory.metafactory(null, null, null, ()Ljava/io/InputStream;, lambda$2(java.io.InputStream ), ()Ljava/io/InputStream;)((InputStream)inflated), null, (OutputStream)out);
                                if (!fh.getNewId().toObjectId().equals(hash.toObjectId())) {
                                    throw new PatchApplyException(MessageFormat.format(JGitText.get().applyBinaryResultOidWrong, new Object[]{path}));
                                }
                            }
                            finally {
                                if (inflated != null) {
                                    inflated.close();
                                }
                            }
                            ** if (out == null) goto lbl30
                        }
                        catch (Throwable var14_18) {
                            if (var13_13 == null) {
                                var13_13 = var14_18;
                            } else if (var13_13 != var14_18) {
                                var13_13.addSuppressed(var14_18);
                            }
                            if (out != null) {
                                out.close();
                            }
                            throw var13_13;
                        }
lbl-1000:
                        // 1 sources

                        {
                            out.close();
                        }
lbl30:
                        // 2 sources

                    }
                    catch (Throwable var14_19) {
                        if (var13_13 == null) {
                            var13_13 = var14_19;
                        } else if (var13_13 != var14_19) {
                            var13_13.addSuppressed(var14_19);
                        }
                        throw var13_13;
                    }
                    var13_13 = null;
                    var14_17 = null;
                    try {
                        bufIn = buffer.openInputStream();
                        try {
                            Files.copy(bufIn, f.toPath(), new CopyOption[]{StandardCopyOption.REPLACE_EXISTING});
                            break;
                        }
                        finally {
                            if (bufIn != null) {
                                bufIn.close();
                            }
                        }
                    }
                    catch (Throwable var14_20) {
                        if (var13_13 == null) {
                            var13_13 = var14_20;
                        } else if (var13_13 != var14_20) {
                            var13_13.addSuppressed(var14_20);
                        }
                        throw var13_13;
                    }
                }
                case 2: {
                    var14_21 = null;
                    var15_26 = null;
                    try {
                        input = loader.load();
                        try {
                            base = IO.readWholeStream(input, 0).array();
                        }
                        finally {
                            if (input != null) {
                                input.close();
                            }
                        }
                    }
                    catch (Throwable var15_27) {
                        if (var14_21 == null) {
                            var14_21 = var15_27;
                        } else if (var14_21 != var15_27) {
                            var14_21.addSuppressed(var15_27);
                        }
                        throw var14_21;
                    }
                    var14_21 = null;
                    var15_26 = null;
                    try {
                        input = new BinaryDeltaInputStream(base, new InflaterInputStream(new BinaryHunkInputStream(new ByteArrayInputStream(hunk.getBuffer(), start, length))));
                        try {
                            finalSize = input.getExpectedResultSize();
                            this.initHash(hash, finalSize);
                            var19_33 = null;
                            var20_35 = null;
                            try {
                                out = buffer;
                                try {
                                    hashed = new SHA1InputStream(hash, input);
                                    try {
                                        DirCacheCheckout.getContent(repository, path, checkOut, (DirCacheCheckout.StreamSupplier)LambdaMetafactory.metafactory(null, null, null, ()Ljava/io/InputStream;, lambda$3(org.eclipse.jgit.api.ApplyCommand$SHA1InputStream ), ()Ljava/io/InputStream;)((SHA1InputStream)hashed), null, (OutputStream)out);
                                        if (!fh.getNewId().toObjectId().equals(hash.toObjectId())) {
                                            throw new PatchApplyException(MessageFormat.format(JGitText.get().applyBinaryResultOidWrong, new Object[]{path}));
                                        }
                                    }
                                    finally {
                                        if (hashed != null) {
                                            hashed.close();
                                        }
                                    }
                                    ** if (out == null) goto lbl109
                                }
                                catch (Throwable var20_36) {
                                    if (var19_33 == null) {
                                        var19_33 = var20_36;
                                    } else if (var19_33 != var20_36) {
                                        var19_33.addSuppressed(var20_36);
                                    }
                                    if (out != null) {
                                        out.close();
                                    }
                                    throw var19_33;
                                }
lbl-1000:
                                // 1 sources

                                {
                                    out.close();
                                }
lbl109:
                                // 2 sources

                            }
                            catch (Throwable var20_37) {
                                if (var19_33 == null) {
                                    var19_33 = var20_37;
                                } else if (var19_33 != var20_37) {
                                    var19_33.addSuppressed(var20_37);
                                }
                                throw var19_33;
                            }
                        }
                        finally {
                            if (input != null) {
                                input.close();
                            }
                        }
                    }
                    catch (Throwable var15_28) {
                        if (var14_21 == null) {
                            var14_21 = var15_28;
                        } else if (var14_21 != var15_28) {
                            var14_21.addSuppressed(var15_28);
                        }
                        throw var14_21;
                    }
                    var14_21 = null;
                    var15_26 = null;
                    try {
                        bufIn = buffer.openInputStream();
                        try {
                            Files.copy(bufIn, f.toPath(), new CopyOption[]{StandardCopyOption.REPLACE_EXISTING});
                            break;
                        }
                        finally {
                            if (bufIn != null) {
                                bufIn.close();
                            }
                        }
                    }
                    catch (Throwable var15_29) {
                        if (var14_21 == null) {
                            var14_21 = var15_29;
                        } else if (var14_21 != var15_29) {
                            var14_21.addSuppressed(var15_29);
                        }
                        throw var14_21;
                    }
                }
            }
        }
        finally {
            buffer.destroy();
        }
    }

    private void applyText(Repository repository, String path, RawText rt, File f, FileHeader fh, DirCacheCheckout.CheckoutMetadata checkOut) throws IOException, PatchApplyException {
        ArrayList<ByteBuffer> oldLines = new ArrayList<ByteBuffer>(rt.size());
        int i = 0;
        while (i < rt.size()) {
            oldLines.add(rt.getRawString(i));
            ++i;
        }
        ArrayList<ByteBuffer> newLines = new ArrayList<ByteBuffer>(oldLines);
        int afterLastHunk = 0;
        int lineNumberShift = 0;
        int lastHunkNewLine = -1;
        for (HunkHeader hunkHeader : fh.getHunks()) {
            if (hunkHeader.getNewStartLine() <= lastHunkNewLine) {
                throw new PatchApplyException(MessageFormat.format(JGitText.get().patchApplyException, hunkHeader));
            }
            lastHunkNewLine = hunkHeader.getNewStartLine();
            byte[] b = new byte[hunkHeader.getEndOffset() - hunkHeader.getStartOffset()];
            System.arraycopy(hunkHeader.getBuffer(), hunkHeader.getStartOffset(), b, 0, b.length);
            RawText hrt = new RawText(b);
            ArrayList<ByteBuffer> hunkLines = new ArrayList<ByteBuffer>(hrt.size());
            int i2 = 0;
            while (i2 < hrt.size()) {
                hunkLines.add(hrt.getRawString(i2));
                ++i2;
            }
            if (hunkHeader.getNewStartLine() == 0) {
                if (fh.getHunks().size() == 1 && this.canApplyAt(hunkLines, newLines, 0)) {
                    newLines.clear();
                    break;
                }
                throw new PatchApplyException(MessageFormat.format(JGitText.get().patchApplyException, hunkHeader));
            }
            int applyAt = hunkHeader.getNewStartLine() - 1 + lineNumberShift;
            if (applyAt < afterLastHunk && lineNumberShift < 0) {
                applyAt = hunkHeader.getNewStartLine() - 1;
                lineNumberShift = 0;
            }
            if (applyAt < afterLastHunk) {
                throw new PatchApplyException(MessageFormat.format(JGitText.get().patchApplyException, hunkHeader));
            }
            boolean applies = false;
            int oldLinesInHunk = hunkHeader.getLinesContext() + hunkHeader.getOldImage().getLinesDeleted();
            if (oldLinesInHunk <= 1) {
                applies = this.canApplyAt(hunkLines, newLines, applyAt);
                if (!applies && lineNumberShift != 0) {
                    applyAt = hunkHeader.getNewStartLine() - 1;
                    applies = applyAt >= afterLastHunk && this.canApplyAt(hunkLines, newLines, applyAt);
                }
            } else {
                int maxShift = applyAt - afterLastHunk;
                int shift = 0;
                while (shift <= maxShift) {
                    if (this.canApplyAt(hunkLines, newLines, applyAt - shift)) {
                        applies = true;
                        applyAt -= shift;
                        break;
                    }
                    ++shift;
                }
                if (!applies) {
                    applyAt = hunkHeader.getNewStartLine() - 1 + lineNumberShift;
                    maxShift = newLines.size() - applyAt - oldLinesInHunk;
                    shift = 1;
                    while (shift <= maxShift) {
                        if (this.canApplyAt(hunkLines, newLines, applyAt + shift)) {
                            applies = true;
                            applyAt += shift;
                            break;
                        }
                        ++shift;
                    }
                }
            }
            if (!applies) {
                throw new PatchApplyException(MessageFormat.format(JGitText.get().patchApplyException, hunkHeader));
            }
            lineNumberShift = applyAt - hunkHeader.getNewStartLine() + 1;
            int sz = hunkLines.size();
            int j = 1;
            while (j < sz) {
                ByteBuffer hunkLine = (ByteBuffer)hunkLines.get(j);
                if (!hunkLine.hasRemaining()) {
                    ++applyAt;
                } else {
                    switch (hunkLine.array()[hunkLine.position()]) {
                        case 32: {
                            ++applyAt;
                            break;
                        }
                        case 45: {
                            newLines.remove(applyAt);
                            break;
                        }
                        case 43: {
                            newLines.add(applyAt++, this.slice(hunkLine, 1));
                            break;
                        }
                    }
                }
                ++j;
            }
            afterLastHunk = applyAt;
        }
        if (!this.isNoNewlineAtEndOfFile(fh)) {
            newLines.add(null);
        }
        if (!rt.isMissingNewlineAtEnd()) {
            oldLines.add(null);
        }
        if (oldLines.equals(newLines)) {
            return;
        }
        TemporaryBuffer.LocalFile localFile = new TemporaryBuffer.LocalFile(null);
        try {
            Object object = null;
            Object throwable = null;
            try (TemporaryBuffer.LocalFile out = localFile;){
                Iterator l = newLines.iterator();
                while (l.hasNext()) {
                    ByteBuffer line = (ByteBuffer)l.next();
                    if (line == null) {
                        break;
                    }
                    ((OutputStream)out).write(line.array(), line.position(), line.remaining());
                    if (!l.hasNext()) continue;
                    ((OutputStream)out).write(10);
                }
            }
            catch (Throwable throwable2) {
                if (object == null) {
                    object = throwable2;
                } else if (object != throwable2) {
                    ((Throwable)object).addSuppressed(throwable2);
                }
                throw object;
            }
            object = null;
            throwable = null;
            try (FileOutputStream output = new FileOutputStream(f);){
                DirCacheCheckout.getContent(repository, path, checkOut, localFile::openInputStream, null, (OutputStream)output);
            }
            catch (Throwable throwable2) {
                if (object == null) {
                    object = throwable2;
                } else if (object != throwable2) {
                    ((Throwable)object).addSuppressed(throwable2);
                }
                throw object;
            }
        }
        finally {
            ((TemporaryBuffer)localFile).destroy();
        }
        repository.getFS().setExecute(f, fh.getNewMode() == FileMode.EXECUTABLE_FILE);
    }

    private boolean canApplyAt(List<ByteBuffer> hunkLines, List<ByteBuffer> newLines, int line) {
        int sz = hunkLines.size();
        int limit = newLines.size();
        int pos = line;
        int j = 1;
        while (j < sz) {
            ByteBuffer hunkLine = hunkLines.get(j);
            if (!hunkLine.hasRemaining()) {
                if (pos >= limit || newLines.get(pos).hasRemaining()) {
                    return false;
                }
                ++pos;
            } else {
                switch (hunkLine.array()[hunkLine.position()]) {
                    case 32: 
                    case 45: {
                        if (pos >= limit || !newLines.get(pos).equals(this.slice(hunkLine, 1))) {
                            return false;
                        }
                        ++pos;
                        break;
                    }
                }
            }
            ++j;
        }
        return true;
    }

    private ByteBuffer slice(ByteBuffer b, int off) {
        int newOffset = b.position() + off;
        return ByteBuffer.wrap(b.array(), newOffset, b.limit() - newOffset);
    }

    private boolean isNoNewlineAtEndOfFile(FileHeader fh) {
        List<? extends HunkHeader> hunks = fh.getHunks();
        if (hunks == null || hunks.isEmpty()) {
            return false;
        }
        HunkHeader lastHunk = hunks.get(hunks.size() - 1);
        byte[] buf = new byte[lastHunk.getEndOffset() - lastHunk.getStartOffset()];
        System.arraycopy(lastHunk.getBuffer(), lastHunk.getStartOffset(), buf, 0, buf.length);
        RawText lhrt = new RawText(buf);
        return lhrt.getString(lhrt.size() - 1).equals("\\ No newline at end of file");
    }

    static /* synthetic */ int[] $SWITCH_TABLE$org$eclipse$jgit$patch$BinaryHunk$Type() {
        if ($SWITCH_TABLE$org$eclipse$jgit$patch$BinaryHunk$Type != null) {
            return $SWITCH_TABLE$org$eclipse$jgit$patch$BinaryHunk$Type;
        }
        int[] nArray = new int[BinaryHunk.Type.values().length];
        try {
            nArray[BinaryHunk.Type.DELTA_DEFLATED.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[BinaryHunk.Type.LITERAL_DEFLATED.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$org$eclipse$jgit$patch$BinaryHunk$Type = nArray;
        return nArray;
    }

    private static /* synthetic */ InputStream lambda$2(InputStream inputStream) throws IOException {
        return inputStream;
    }

    private static /* synthetic */ InputStream lambda$3(SHA1InputStream sHA1InputStream) throws IOException {
        return sHA1InputStream;
    }

    private static class SHA1InputStream
    extends InputStream {
        private final SHA1 hash;
        private final InputStream in;

        SHA1InputStream(SHA1 hash, InputStream in) {
            this.hash = hash;
            this.in = in;
        }

        @Override
        public int read() throws IOException {
            int b = this.in.read();
            if (b >= 0) {
                this.hash.update((byte)b);
            }
            return b;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int n = this.in.read(b, off, len);
            if (n > 0) {
                this.hash.update(b, off, n);
            }
            return n;
        }

        @Override
        public void close() throws IOException {
            this.in.close();
        }
    }
}

