/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Vector;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.api.errors.AbortedByHookException;
import org.eclipse.jgit.errors.NotSupportedException;
import org.eclipse.jgit.errors.TransportException;
import org.eclipse.jgit.hooks.Hooks;
import org.eclipse.jgit.hooks.PrePushHook;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.ObjectChecker;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.storage.pack.PackConfig;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.FetchConnection;
import org.eclipse.jgit.transport.FetchProcess;
import org.eclipse.jgit.transport.FetchResult;
import org.eclipse.jgit.transport.FilterSpec;
import org.eclipse.jgit.transport.PushConnection;
import org.eclipse.jgit.transport.PushProcess;
import org.eclipse.jgit.transport.PushResult;
import org.eclipse.jgit.transport.RefLeaseSpec;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.RemoteRefUpdate;
import org.eclipse.jgit.transport.TagOpt;
import org.eclipse.jgit.transport.TransferConfig;
import org.eclipse.jgit.transport.TransportAmazonS3;
import org.eclipse.jgit.transport.TransportBundleFile;
import org.eclipse.jgit.transport.TransportGitAnon;
import org.eclipse.jgit.transport.TransportGitSsh;
import org.eclipse.jgit.transport.TransportHttp;
import org.eclipse.jgit.transport.TransportLocal;
import org.eclipse.jgit.transport.TransportProtocol;
import org.eclipse.jgit.transport.TransportSftp;
import org.eclipse.jgit.transport.URIish;

public abstract class Transport
implements AutoCloseable {
    private static final List<WeakReference<TransportProtocol>> protocols = new CopyOnWriteArrayList<WeakReference<TransportProtocol>>();
    public static final boolean DEFAULT_FETCH_THIN = true;
    public static final boolean DEFAULT_PUSH_THIN = false;
    public static final RefSpec REFSPEC_TAGS;
    public static final RefSpec REFSPEC_PUSH_ALL;
    protected final Repository local;
    protected final URIish uri;
    private String optionUploadPack = "git-upload-pack";
    private List<RefSpec> fetch = Collections.emptyList();
    private TagOpt tagopt = TagOpt.NO_TAGS;
    private boolean fetchThin = true;
    private String optionReceivePack = "git-receive-pack";
    private List<RefSpec> push = Collections.emptyList();
    private boolean pushThin = false;
    private boolean pushAtomic;
    private boolean dryRun;
    private ObjectChecker objectChecker;
    private boolean removeDeletedRefs;
    private FilterSpec filterSpec = FilterSpec.NO_FILTER;
    private int timeout;
    private PackConfig packConfig;
    private CredentialsProvider credentialsProvider;
    private List<String> pushOptions;
    private PrintStream hookOutRedirect;
    private PrePushHook prePush;
    private Integer depth;
    private Instant deepenSince;
    private List<String> deepenNots = new ArrayList<String>();
    @Nullable
    TransferConfig.ProtocolVersion protocol;

    static {
        Transport.register(TransportLocal.PROTO_LOCAL);
        Transport.register(TransportBundleFile.PROTO_BUNDLE);
        Transport.register(TransportAmazonS3.PROTO_S3);
        Transport.register(TransportGitAnon.PROTO_GIT);
        Transport.register(TransportSftp.PROTO_SFTP);
        Transport.register(TransportHttp.PROTO_FTP);
        Transport.register(TransportHttp.PROTO_HTTP);
        Transport.register(TransportGitSsh.PROTO_SSH);
        Transport.registerByService();
        REFSPEC_TAGS = new RefSpec("refs/tags/*:refs/tags/*");
        REFSPEC_PUSH_ALL = new RefSpec("refs/heads/*:refs/heads/*");
    }

    private static void registerByService() {
        ClassLoader ldr = Thread.currentThread().getContextClassLoader();
        if (ldr == null) {
            ldr = Transport.class.getClassLoader();
        }
        Enumeration<URL> catalogs = Transport.catalogs(ldr);
        while (catalogs.hasMoreElements()) {
            Transport.scan(ldr, catalogs.nextElement());
        }
    }

    private static Enumeration<URL> catalogs(ClassLoader ldr) {
        try {
            String prefix = "META-INF/services/";
            String name = String.valueOf(prefix) + Transport.class.getName();
            return ldr.getResources(name);
        }
        catch (IOException err) {
            return new Vector().elements();
        }
    }

    private static void scan(ClassLoader ldr, URL url) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (BufferedReader br = new BufferedReader(new InputStreamReader(url.openStream(), StandardCharsets.UTF_8));){
                String line;
                while ((line = br.readLine()) != null) {
                    int comment;
                    if ((line = line.trim()).length() == 0 || (comment = line.indexOf(35)) == 0) continue;
                    if (comment != -1) {
                        line = line.substring(0, comment).trim();
                    }
                    Transport.load(ldr, line);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void load(ClassLoader ldr, String cn) {
        Class<?> clazz;
        try {
            clazz = Class.forName(cn, false, ldr);
        }
        catch (ClassNotFoundException notBuiltin) {
            return;
        }
        Field[] fieldArray = clazz.getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            block7: {
                Field f = fieldArray[n2];
                if ((f.getModifiers() & 8) == 8 && TransportProtocol.class.isAssignableFrom(f.getType())) {
                    TransportProtocol proto;
                    try {
                        proto = (TransportProtocol)f.get(null);
                    }
                    catch (IllegalAccessException | IllegalArgumentException e) {
                        break block7;
                    }
                    if (proto != null) {
                        Transport.register(proto);
                    }
                }
            }
            ++n2;
        }
    }

    public static void register(TransportProtocol proto) {
        protocols.add(0, new WeakReference<TransportProtocol>(proto));
    }

    public static void unregister(TransportProtocol proto) {
        for (WeakReference<TransportProtocol> ref : protocols) {
            TransportProtocol refProto = (TransportProtocol)ref.get();
            if (refProto != null && refProto != proto) continue;
            protocols.remove(ref);
        }
    }

    public static List<TransportProtocol> getTransportProtocols() {
        int cnt = protocols.size();
        ArrayList<TransportProtocol> res = new ArrayList<TransportProtocol>(cnt);
        for (WeakReference<TransportProtocol> ref : protocols) {
            TransportProtocol proto = (TransportProtocol)ref.get();
            if (proto != null) {
                res.add(proto);
                continue;
            }
            protocols.remove(ref);
        }
        return Collections.unmodifiableList(res);
    }

    public static Transport open(Repository local, String remote) throws NotSupportedException, URISyntaxException, TransportException {
        return Transport.open(local, remote, Operation.FETCH);
    }

    public static Transport open(Repository local, String remote, Operation op) throws NotSupportedException, URISyntaxException, TransportException {
        if (local != null) {
            RemoteConfig cfg = new RemoteConfig(local.getConfig(), remote);
            if (Transport.doesNotExist(cfg)) {
                return Transport.open(local, new URIish(remote), null);
            }
            return Transport.open(local, cfg, op);
        }
        return Transport.open(new URIish(remote));
    }

    public static List<Transport> openAll(Repository local, String remote) throws NotSupportedException, URISyntaxException, TransportException {
        return Transport.openAll(local, remote, Operation.FETCH);
    }

    public static List<Transport> openAll(Repository local, String remote, Operation op) throws NotSupportedException, URISyntaxException, TransportException {
        RemoteConfig cfg = new RemoteConfig(local.getConfig(), remote);
        if (Transport.doesNotExist(cfg)) {
            ArrayList<Transport> transports = new ArrayList<Transport>(1);
            transports.add(Transport.open(local, new URIish(remote), null));
            return transports;
        }
        return Transport.openAll(local, cfg, op);
    }

    public static Transport open(Repository local, RemoteConfig cfg) throws NotSupportedException, TransportException {
        return Transport.open(local, cfg, Operation.FETCH);
    }

    public static Transport open(Repository local, RemoteConfig cfg, Operation op) throws NotSupportedException, TransportException {
        List<URIish> uris = Transport.getURIs(cfg, op);
        if (uris.isEmpty()) {
            throw new IllegalArgumentException(MessageFormat.format(JGitText.get().remoteConfigHasNoURIAssociated, cfg.getName()));
        }
        Transport tn = Transport.open(local, uris.get(0), cfg.getName());
        tn.applyConfig(cfg);
        return tn;
    }

    public static List<Transport> openAll(Repository local, RemoteConfig cfg) throws NotSupportedException, TransportException {
        return Transport.openAll(local, cfg, Operation.FETCH);
    }

    public static List<Transport> openAll(Repository local, RemoteConfig cfg, Operation op) throws NotSupportedException, TransportException {
        List<URIish> uris = Transport.getURIs(cfg, op);
        ArrayList<Transport> transports = new ArrayList<Transport>(uris.size());
        for (URIish uri : uris) {
            Transport tn = Transport.open(local, uri, cfg.getName());
            tn.applyConfig(cfg);
            transports.add(tn);
        }
        return transports;
    }

    private static List<URIish> getURIs(RemoteConfig cfg, Operation op) {
        switch (op) {
            case FETCH: {
                return cfg.getURIs();
            }
            case PUSH: {
                List<URIish> uris = cfg.getPushURIs();
                if (uris.isEmpty()) {
                    uris = cfg.getURIs();
                }
                return uris;
            }
        }
        throw new IllegalArgumentException(op.toString());
    }

    private static boolean doesNotExist(RemoteConfig cfg) {
        return cfg.getURIs().isEmpty() && cfg.getPushURIs().isEmpty();
    }

    public static Transport open(Repository local, URIish uri) throws NotSupportedException, TransportException {
        return Transport.open(local, uri, null);
    }

    public static Transport open(Repository local, URIish uri, String remoteName) throws NotSupportedException, TransportException {
        for (WeakReference<TransportProtocol> ref : protocols) {
            TransportProtocol proto = (TransportProtocol)ref.get();
            if (proto == null) {
                protocols.remove(ref);
                continue;
            }
            if (!proto.canHandle(uri, local, remoteName)) continue;
            Transport tn = proto.open(uri, local, remoteName);
            tn.prePush = Hooks.prePush(local, tn.hookOutRedirect);
            tn.prePush.setRemoteLocation(uri.toString());
            tn.prePush.setRemoteName(remoteName);
            return tn;
        }
        throw new NotSupportedException(MessageFormat.format(JGitText.get().URINotSupported, uri));
    }

    public static Transport open(URIish uri) throws NotSupportedException, TransportException {
        for (WeakReference<TransportProtocol> ref : protocols) {
            TransportProtocol proto = (TransportProtocol)ref.get();
            if (proto == null) {
                protocols.remove(ref);
                continue;
            }
            if (!proto.canHandle(uri, null, null)) continue;
            return proto.open(uri);
        }
        throw new NotSupportedException(MessageFormat.format(JGitText.get().URINotSupported, uri));
    }

    public static Collection<RemoteRefUpdate> findRemoteRefUpdatesFor(Repository db, Collection<RefSpec> specs, Map<String, RefLeaseSpec> leases, Collection<RefSpec> fetchSpecs) throws IOException {
        if (fetchSpecs == null) {
            fetchSpecs = Collections.emptyList();
        }
        LinkedList<RemoteRefUpdate> result = new LinkedList<RemoteRefUpdate>();
        Collection<RefSpec> procRefs = Transport.expandPushWildcardsFor(db, specs);
        for (RefSpec spec : procRefs) {
            String destSpec;
            String srcSpec = spec.getSource();
            Ref srcRef = db.findRef(srcSpec);
            if (srcRef != null) {
                srcSpec = srcRef.getName();
            }
            if ((destSpec = spec.getDestination()) == null) {
                destSpec = srcSpec;
            }
            if (srcRef != null && !destSpec.startsWith("refs/")) {
                String n = srcRef.getName();
                int kindEnd = n.indexOf(47, "refs/".length());
                destSpec = String.valueOf(n.substring(0, kindEnd + 1)) + destSpec;
            }
            boolean forceUpdate = spec.isForceUpdate();
            String localName = Transport.findTrackingRefName(destSpec, fetchSpecs);
            RefLeaseSpec leaseSpec = leases.get(destSpec);
            ObjectId expected = leaseSpec == null ? null : db.resolve(leaseSpec.getExpected());
            RemoteRefUpdate rru = new RemoteRefUpdate(db, srcSpec, destSpec, forceUpdate, localName, expected);
            result.add(rru);
        }
        return result;
    }

    public static Collection<RemoteRefUpdate> findRemoteRefUpdatesFor(Repository db, Collection<RefSpec> specs, Collection<RefSpec> fetchSpecs) throws IOException {
        return Transport.findRemoteRefUpdatesFor(db, specs, Collections.emptyMap(), fetchSpecs);
    }

    private static Collection<RefSpec> expandPushWildcardsFor(Repository db, Collection<RefSpec> specs) throws IOException {
        List<Ref> localRefs = db.getRefDatabase().getRefs();
        LinkedHashSet<RefSpec> procRefs = new LinkedHashSet<RefSpec>();
        for (RefSpec spec : specs) {
            if (spec.isWildcard()) {
                for (Ref localRef : localRefs) {
                    if (!spec.matchSource(localRef)) continue;
                    procRefs.add(spec.expandFromSource(localRef));
                }
                continue;
            }
            procRefs.add(spec);
        }
        return procRefs;
    }

    private static String findTrackingRefName(String remoteName, Collection<RefSpec> fetchSpecs) {
        for (RefSpec fetchSpec : fetchSpecs) {
            if (!fetchSpec.matchSource(remoteName)) continue;
            if (fetchSpec.isWildcard()) {
                return fetchSpec.expandFromSource(remoteName).getDestination();
            }
            return fetchSpec.getDestination();
        }
        return null;
    }

    protected Transport(Repository local, URIish uri) {
        TransferConfig tc = local.getConfig().get(TransferConfig.KEY);
        this.local = local;
        this.uri = uri;
        this.protocol = tc.protocolVersion;
        this.objectChecker = tc.newObjectChecker();
        this.credentialsProvider = CredentialsProvider.getDefault();
        this.prePush = Hooks.prePush(local, this.hookOutRedirect);
    }

    protected Transport(URIish uri) {
        this.uri = uri;
        this.local = null;
        this.objectChecker = new ObjectChecker();
        this.credentialsProvider = CredentialsProvider.getDefault();
    }

    public URIish getURI() {
        return this.uri;
    }

    public String getOptionUploadPack() {
        return this.optionUploadPack;
    }

    public void setOptionUploadPack(String where) {
        this.optionUploadPack = where != null && where.length() > 0 ? where : "git-upload-pack";
    }

    public TagOpt getTagOpt() {
        return this.tagopt;
    }

    public void setTagOpt(TagOpt option) {
        this.tagopt = option != null ? option : TagOpt.AUTO_FOLLOW;
    }

    public boolean isFetchThin() {
        return this.fetchThin;
    }

    public void setFetchThin(boolean fetchThin) {
        this.fetchThin = fetchThin;
    }

    public boolean isCheckFetchedObjects() {
        return this.getObjectChecker() != null;
    }

    public void setCheckFetchedObjects(boolean check) {
        if (check && this.objectChecker == null) {
            this.setObjectChecker(new ObjectChecker());
        } else if (!check && this.objectChecker != null) {
            this.setObjectChecker(null);
        }
    }

    public ObjectChecker getObjectChecker() {
        return this.objectChecker;
    }

    public void setObjectChecker(ObjectChecker impl) {
        this.objectChecker = impl;
    }

    public String getOptionReceivePack() {
        return this.optionReceivePack;
    }

    public void setOptionReceivePack(String optionReceivePack) {
        this.optionReceivePack = optionReceivePack != null && optionReceivePack.length() > 0 ? optionReceivePack : "git-receive-pack";
    }

    public boolean isPushThin() {
        return this.pushThin;
    }

    public void setPushThin(boolean pushThin) {
        this.pushThin = pushThin;
    }

    public boolean isPushAtomic() {
        return this.pushAtomic;
    }

    public void setPushAtomic(boolean atomic) {
        this.pushAtomic = atomic;
    }

    public boolean isRemoveDeletedRefs() {
        return this.removeDeletedRefs;
    }

    public void setRemoveDeletedRefs(boolean remove) {
        this.removeDeletedRefs = remove;
    }

    @Deprecated
    public final long getFilterBlobLimit() {
        return this.filterSpec.getBlobLimit();
    }

    @Deprecated
    public final void setFilterBlobLimit(long bytes) {
        this.setFilterSpec(FilterSpec.withBlobLimit(bytes));
    }

    public final FilterSpec getFilterSpec() {
        return this.filterSpec;
    }

    public final void setFilterSpec(@NonNull FilterSpec filter) {
        this.filterSpec = Objects.requireNonNull(filter);
    }

    public final Integer getDepth() {
        return this.depth;
    }

    public final void setDepth(int depth) {
        if (depth < 1) {
            throw new IllegalArgumentException(JGitText.get().depthMustBeAt1);
        }
        this.depth = depth;
    }

    public final void setDepth(Integer depth) {
        if (depth != null && depth < 1) {
            throw new IllegalArgumentException(JGitText.get().depthMustBeAt1);
        }
        this.depth = depth;
    }

    public final Instant getDeepenSince() {
        return this.deepenSince;
    }

    public final void setDeepenSince(@NonNull Instant deepenSince) {
        this.deepenSince = deepenSince;
    }

    public final List<String> getDeepenNots() {
        return this.deepenNots;
    }

    public final void setDeepenNots(@NonNull List<String> deepenNots) {
        this.deepenNots = deepenNots;
    }

    public void applyConfig(RemoteConfig cfg) {
        this.setOptionUploadPack(cfg.getUploadPack());
        this.setOptionReceivePack(cfg.getReceivePack());
        this.setTagOpt(cfg.getTagOpt());
        this.fetch = cfg.getFetchRefSpecs();
        this.push = cfg.getPushRefSpecs();
        this.timeout = cfg.getTimeout();
    }

    public boolean isDryRun() {
        return this.dryRun;
    }

    public void setDryRun(boolean dryRun) {
        this.dryRun = dryRun;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int seconds) {
        this.timeout = seconds;
    }

    public PackConfig getPackConfig() {
        if (this.packConfig == null) {
            this.packConfig = new PackConfig(this.local);
        }
        return this.packConfig;
    }

    public void setPackConfig(PackConfig pc) {
        this.packConfig = pc;
    }

    public void setCredentialsProvider(CredentialsProvider credentialsProvider) {
        this.credentialsProvider = credentialsProvider;
    }

    public CredentialsProvider getCredentialsProvider() {
        return this.credentialsProvider;
    }

    public List<String> getPushOptions() {
        return this.pushOptions;
    }

    public void setPushOptions(List<String> pushOptions) {
        this.pushOptions = pushOptions;
    }

    public FetchResult fetch(ProgressMonitor monitor, Collection<RefSpec> toFetch) throws NotSupportedException, TransportException {
        return this.fetch(monitor, toFetch, null);
    }

    public FetchResult fetch(ProgressMonitor monitor, Collection<RefSpec> toFetch, String branch) throws NotSupportedException, TransportException {
        if (toFetch == null || toFetch.isEmpty()) {
            if (this.fetch.isEmpty()) {
                throw new TransportException(JGitText.get().nothingToFetch);
            }
            toFetch = this.fetch;
        } else if (!this.fetch.isEmpty()) {
            ArrayList<RefSpec> tmp = new ArrayList<RefSpec>(toFetch);
            block0: for (RefSpec requested : toFetch) {
                String reqSrc = requested.getSource();
                for (RefSpec configured : this.fetch) {
                    String cfgSrc = configured.getSource();
                    String cfgDst = configured.getDestination();
                    if (!cfgSrc.equals(reqSrc) || cfgDst == null) continue;
                    tmp.add(configured);
                    continue block0;
                }
            }
            toFetch = tmp;
        }
        FetchResult result = new FetchResult();
        new FetchProcess(this, toFetch).execute(monitor, result, branch);
        this.local.autoGC(monitor);
        return result;
    }

    public PushResult push(ProgressMonitor monitor, Collection<RemoteRefUpdate> toPush, OutputStream out) throws NotSupportedException, TransportException {
        if (toPush == null || toPush.isEmpty()) {
            try {
                toPush = this.findRemoteRefUpdatesFor(this.push);
            }
            catch (IOException e) {
                throw new TransportException(MessageFormat.format(JGitText.get().problemWithResolvingPushRefSpecsLocally, e.getMessage()), e);
            }
            if (toPush.isEmpty()) {
                throw new TransportException(JGitText.get().nothingToPush);
            }
        }
        if (this.prePush != null) {
            try {
                this.prePush.setRefs(toPush);
                this.prePush.call();
            }
            catch (IOException | AbortedByHookException e) {
                throw new TransportException(e.getMessage(), e);
            }
        }
        PushProcess pushProcess = new PushProcess(this, toPush, out);
        return pushProcess.execute(monitor);
    }

    public PushResult push(ProgressMonitor monitor, Collection<RemoteRefUpdate> toPush) throws NotSupportedException, TransportException {
        return this.push(monitor, toPush, null);
    }

    public Collection<RemoteRefUpdate> findRemoteRefUpdatesFor(Collection<RefSpec> specs) throws IOException {
        return Transport.findRemoteRefUpdatesFor(this.local, specs, Collections.emptyMap(), this.fetch);
    }

    public Collection<RemoteRefUpdate> findRemoteRefUpdatesFor(Collection<RefSpec> specs, Map<String, RefLeaseSpec> leases) throws IOException {
        return Transport.findRemoteRefUpdatesFor(this.local, specs, leases, this.fetch);
    }

    public abstract FetchConnection openFetch() throws NotSupportedException, TransportException;

    public FetchConnection openFetch(Collection<RefSpec> refSpecs, String ... additionalPatterns) throws NotSupportedException, TransportException {
        return this.openFetch();
    }

    public abstract PushConnection openPush() throws NotSupportedException, TransportException;

    @Override
    public abstract void close();

    public static enum Operation {
        FETCH,
        PUSH;

    }
}

