/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.util.sha1;

import java.text.MessageFormat;
import java.util.Arrays;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.MutableObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.util.NB;
import org.eclipse.jgit.util.SystemReader;
import org.eclipse.jgit.util.sha1.SHA1;
import org.eclipse.jgit.util.sha1.Sha1CollisionException;
import org.eclipse.jgit.util.sha1.UbcCheck;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SHA1Java
extends SHA1 {
    private static final Logger LOG = LoggerFactory.getLogger(SHA1Java.class);
    private static final boolean DETECT_COLLISIONS;
    private final State h = new State();
    private final int[] w = new int[80];
    private final byte[] buffer = new byte[64];
    private long length;
    private boolean detectCollision = DETECT_COLLISIONS;
    private boolean foundCollision;
    private final int[] w2 = new int[80];
    private final State state58 = new State();
    private final State state65 = new State();
    private final State hIn = new State();
    private final State hTmp = new State();

    SHA1Java() {
        this.h.init();
    }

    @Override
    public SHA1 setDetectCollision(boolean detect) {
        this.detectCollision = detect;
        return this;
    }

    @Override
    public void update(byte b) {
        int bufferLen = (int)(this.length & 0x3FL);
        ++this.length;
        this.buffer[bufferLen] = b;
        if (bufferLen == 63) {
            this.compress(this.buffer, 0);
        }
    }

    @Override
    public void update(byte[] in) {
        this.update(in, 0, in.length);
    }

    @Override
    public void update(byte[] in, int p, int len) {
        int bufferLen = (int)(this.length & 0x3FL);
        this.length += (long)len;
        if (bufferLen > 0) {
            int n = Math.min(64 - bufferLen, len);
            System.arraycopy(in, p, this.buffer, bufferLen, n);
            p += n;
            len -= n;
            if (bufferLen + n < 64) {
                return;
            }
            this.compress(this.buffer, 0);
        }
        while (len >= 64) {
            this.compress(in, p);
            p += 64;
            len -= 64;
        }
        if (len > 0) {
            System.arraycopy(in, p, this.buffer, 0, len);
        }
    }

    private void compress(byte[] block, int p) {
        int b;
        this.initBlock(block, p);
        this.compress();
        for (int ubcDvMask = this.detectCollision ? UbcCheck.check(this.w) : 0; ubcDvMask != 0; ubcDvMask &= ~(1 << b)) {
            b = Integer.numberOfTrailingZeros(Integer.lowestOneBit(ubcDvMask));
            UbcCheck.DvInfo dv = UbcCheck.DV[b];
            for (int i = 0; i < 80; ++i) {
                this.w2[i] = this.w[i] ^ dv.dm[i];
            }
            this.recompress(dv.testt);
            if (!SHA1Java.eq(this.hTmp, this.h)) continue;
            this.foundCollision = true;
            break;
        }
    }

    private void initBlock(byte[] block, int p) {
        int t;
        for (t = 0; t < 16; ++t) {
            this.w[t] = NB.decodeInt32(block, p + (t << 2));
        }
        for (t = 16; t < 80; ++t) {
            int x = this.w[t - 3] ^ this.w[t - 8] ^ this.w[t - 14] ^ this.w[t - 16];
            this.w[t] = Integer.rotateLeft(x, 1);
        }
    }

    private void compress() {
        int a = this.h.a;
        int b = this.h.b;
        int c = this.h.c;
        int d = this.h.d;
        int e = this.h.e;
        e += SHA1Java.s1(a, b, c, d, this.w[0]);
        b = Integer.rotateLeft(b, 30);
        d += SHA1Java.s1(e, a, b, c, this.w[1]);
        a = Integer.rotateLeft(a, 30);
        c += SHA1Java.s1(d, e, a, b, this.w[2]);
        e = Integer.rotateLeft(e, 30);
        b += SHA1Java.s1(c, d, e, a, this.w[3]);
        d = Integer.rotateLeft(d, 30);
        a += SHA1Java.s1(b, c, d, e, this.w[4]);
        c = Integer.rotateLeft(c, 30);
        e += SHA1Java.s1(a, b, c, d, this.w[5]);
        b = Integer.rotateLeft(b, 30);
        d += SHA1Java.s1(e, a, b, c, this.w[6]);
        a = Integer.rotateLeft(a, 30);
        c += SHA1Java.s1(d, e, a, b, this.w[7]);
        e = Integer.rotateLeft(e, 30);
        b += SHA1Java.s1(c, d, e, a, this.w[8]);
        d = Integer.rotateLeft(d, 30);
        a += SHA1Java.s1(b, c, d, e, this.w[9]);
        c = Integer.rotateLeft(c, 30);
        e += SHA1Java.s1(a, b, c, d, this.w[10]);
        b = Integer.rotateLeft(b, 30);
        d += SHA1Java.s1(e, a, b, c, this.w[11]);
        a = Integer.rotateLeft(a, 30);
        c += SHA1Java.s1(d, e, a, b, this.w[12]);
        e = Integer.rotateLeft(e, 30);
        b += SHA1Java.s1(c, d, e, a, this.w[13]);
        d = Integer.rotateLeft(d, 30);
        a += SHA1Java.s1(b, c, d, e, this.w[14]);
        c = Integer.rotateLeft(c, 30);
        e += SHA1Java.s1(a, b, c, d, this.w[15]);
        b = Integer.rotateLeft(b, 30);
        d += SHA1Java.s1(e, a, b, c, this.w[16]);
        a = Integer.rotateLeft(a, 30);
        c += SHA1Java.s1(d, e, a, b, this.w[17]);
        e = Integer.rotateLeft(e, 30);
        b += SHA1Java.s1(c, d, e, a, this.w[18]);
        d = Integer.rotateLeft(d, 30);
        a += SHA1Java.s1(b, c, d, e, this.w[19]);
        c = Integer.rotateLeft(c, 30);
        e += SHA1Java.s2(a, b, c, d, this.w[20]);
        b = Integer.rotateLeft(b, 30);
        d += SHA1Java.s2(e, a, b, c, this.w[21]);
        a = Integer.rotateLeft(a, 30);
        c += SHA1Java.s2(d, e, a, b, this.w[22]);
        e = Integer.rotateLeft(e, 30);
        b += SHA1Java.s2(c, d, e, a, this.w[23]);
        d = Integer.rotateLeft(d, 30);
        a += SHA1Java.s2(b, c, d, e, this.w[24]);
        c = Integer.rotateLeft(c, 30);
        e += SHA1Java.s2(a, b, c, d, this.w[25]);
        b = Integer.rotateLeft(b, 30);
        d += SHA1Java.s2(e, a, b, c, this.w[26]);
        a = Integer.rotateLeft(a, 30);
        c += SHA1Java.s2(d, e, a, b, this.w[27]);
        e = Integer.rotateLeft(e, 30);
        b += SHA1Java.s2(c, d, e, a, this.w[28]);
        d = Integer.rotateLeft(d, 30);
        a += SHA1Java.s2(b, c, d, e, this.w[29]);
        c = Integer.rotateLeft(c, 30);
        e += SHA1Java.s2(a, b, c, d, this.w[30]);
        b = Integer.rotateLeft(b, 30);
        d += SHA1Java.s2(e, a, b, c, this.w[31]);
        a = Integer.rotateLeft(a, 30);
        c += SHA1Java.s2(d, e, a, b, this.w[32]);
        e = Integer.rotateLeft(e, 30);
        b += SHA1Java.s2(c, d, e, a, this.w[33]);
        d = Integer.rotateLeft(d, 30);
        a += SHA1Java.s2(b, c, d, e, this.w[34]);
        c = Integer.rotateLeft(c, 30);
        e += SHA1Java.s2(a, b, c, d, this.w[35]);
        b = Integer.rotateLeft(b, 30);
        d += SHA1Java.s2(e, a, b, c, this.w[36]);
        a = Integer.rotateLeft(a, 30);
        c += SHA1Java.s2(d, e, a, b, this.w[37]);
        e = Integer.rotateLeft(e, 30);
        b += SHA1Java.s2(c, d, e, a, this.w[38]);
        d = Integer.rotateLeft(d, 30);
        a += SHA1Java.s2(b, c, d, e, this.w[39]);
        c = Integer.rotateLeft(c, 30);
        e += SHA1Java.s3(a, b, c, d, this.w[40]);
        b = Integer.rotateLeft(b, 30);
        d += SHA1Java.s3(e, a, b, c, this.w[41]);
        a = Integer.rotateLeft(a, 30);
        c += SHA1Java.s3(d, e, a, b, this.w[42]);
        e = Integer.rotateLeft(e, 30);
        b += SHA1Java.s3(c, d, e, a, this.w[43]);
        d = Integer.rotateLeft(d, 30);
        a += SHA1Java.s3(b, c, d, e, this.w[44]);
        c = Integer.rotateLeft(c, 30);
        e += SHA1Java.s3(a, b, c, d, this.w[45]);
        b = Integer.rotateLeft(b, 30);
        d += SHA1Java.s3(e, a, b, c, this.w[46]);
        a = Integer.rotateLeft(a, 30);
        c += SHA1Java.s3(d, e, a, b, this.w[47]);
        e = Integer.rotateLeft(e, 30);
        b += SHA1Java.s3(c, d, e, a, this.w[48]);
        d = Integer.rotateLeft(d, 30);
        a += SHA1Java.s3(b, c, d, e, this.w[49]);
        c = Integer.rotateLeft(c, 30);
        e += SHA1Java.s3(a, b, c, d, this.w[50]);
        b = Integer.rotateLeft(b, 30);
        d += SHA1Java.s3(e, a, b, c, this.w[51]);
        a = Integer.rotateLeft(a, 30);
        c += SHA1Java.s3(d, e, a, b, this.w[52]);
        e = Integer.rotateLeft(e, 30);
        b += SHA1Java.s3(c, d, e, a, this.w[53]);
        d = Integer.rotateLeft(d, 30);
        a += SHA1Java.s3(b, c, d, e, this.w[54]);
        c = Integer.rotateLeft(c, 30);
        e += SHA1Java.s3(a, b, c, d, this.w[55]);
        b = Integer.rotateLeft(b, 30);
        d += SHA1Java.s3(e, a, b, c, this.w[56]);
        a = Integer.rotateLeft(a, 30);
        c += SHA1Java.s3(d, e, a, b, this.w[57]);
        e = Integer.rotateLeft(e, 30);
        this.state58.save(a, b, c, d, e);
        b += SHA1Java.s3(c, d, e, a, this.w[58]);
        d = Integer.rotateLeft(d, 30);
        a += SHA1Java.s3(b, c, d, e, this.w[59]);
        c = Integer.rotateLeft(c, 30);
        e += SHA1Java.s4(a, b, c, d, this.w[60]);
        b = Integer.rotateLeft(b, 30);
        d += SHA1Java.s4(e, a, b, c, this.w[61]);
        a = Integer.rotateLeft(a, 30);
        c += SHA1Java.s4(d, e, a, b, this.w[62]);
        e = Integer.rotateLeft(e, 30);
        b += SHA1Java.s4(c, d, e, a, this.w[63]);
        d = Integer.rotateLeft(d, 30);
        a += SHA1Java.s4(b, c, d, e, this.w[64]);
        c = Integer.rotateLeft(c, 30);
        this.state65.save(a, b, c, d, e);
        e += SHA1Java.s4(a, b, c, d, this.w[65]);
        b = Integer.rotateLeft(b, 30);
        d += SHA1Java.s4(e, a, b, c, this.w[66]);
        a = Integer.rotateLeft(a, 30);
        c += SHA1Java.s4(d, e, a, b, this.w[67]);
        e = Integer.rotateLeft(e, 30);
        b += SHA1Java.s4(c, d, e, a, this.w[68]);
        d = Integer.rotateLeft(d, 30);
        a += SHA1Java.s4(b, c, d, e, this.w[69]);
        c = Integer.rotateLeft(c, 30);
        e += SHA1Java.s4(a, b, c, d, this.w[70]);
        b = Integer.rotateLeft(b, 30);
        d += SHA1Java.s4(e, a, b, c, this.w[71]);
        a = Integer.rotateLeft(a, 30);
        c += SHA1Java.s4(d, e, a, b, this.w[72]);
        e = Integer.rotateLeft(e, 30);
        b += SHA1Java.s4(c, d, e, a, this.w[73]);
        d = Integer.rotateLeft(d, 30);
        a += SHA1Java.s4(b, c, d, e, this.w[74]);
        c = Integer.rotateLeft(c, 30);
        e += SHA1Java.s4(a, b, c, d, this.w[75]);
        b = Integer.rotateLeft(b, 30);
        d += SHA1Java.s4(e, a, b, c, this.w[76]);
        a = Integer.rotateLeft(a, 30);
        c += SHA1Java.s4(d, e, a, b, this.w[77]);
        e = Integer.rotateLeft(e, 30);
        b += SHA1Java.s4(c, d, e, a, this.w[78]);
        d = Integer.rotateLeft(d, 30);
        a += SHA1Java.s4(b, c, d, e, this.w[79]);
        c = Integer.rotateLeft(c, 30);
        this.h.save(this.h.a + a, this.h.b + b, this.h.c + c, this.h.d + d, this.h.e + e);
    }

    private void recompress(int t) {
        State s;
        switch (t) {
            case 58: {
                s = this.state58;
                break;
            }
            case 65: {
                s = this.state65;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        int a = s.a;
        int b = s.b;
        int c = s.c;
        int d = s.d;
        int e = s.e;
        if (t == 65) {
            c = Integer.rotateRight(c, 30);
            a -= SHA1Java.s4(b, c, d, e, this.w2[64]);
            d = Integer.rotateRight(d, 30);
            b -= SHA1Java.s4(c, d, e, a, this.w2[63]);
            e = Integer.rotateRight(e, 30);
            c -= SHA1Java.s4(d, e, a, b, this.w2[62]);
            a = Integer.rotateRight(a, 30);
            d -= SHA1Java.s4(e, a, b, c, this.w2[61]);
            b = Integer.rotateRight(b, 30);
            e -= SHA1Java.s4(a, b, c, d, this.w2[60]);
            c = Integer.rotateRight(c, 30);
            a -= SHA1Java.s3(b, c, d, e, this.w2[59]);
            d = Integer.rotateRight(d, 30);
            b -= SHA1Java.s3(c, d, e, a, this.w2[58]);
        }
        e = Integer.rotateRight(e, 30);
        c -= SHA1Java.s3(d, e, a, b, this.w2[57]);
        a = Integer.rotateRight(a, 30);
        d -= SHA1Java.s3(e, a, b, c, this.w2[56]);
        b = Integer.rotateRight(b, 30);
        e -= SHA1Java.s3(a, b, c, d, this.w2[55]);
        c = Integer.rotateRight(c, 30);
        a -= SHA1Java.s3(b, c, d, e, this.w2[54]);
        d = Integer.rotateRight(d, 30);
        b -= SHA1Java.s3(c, d, e, a, this.w2[53]);
        e = Integer.rotateRight(e, 30);
        c -= SHA1Java.s3(d, e, a, b, this.w2[52]);
        a = Integer.rotateRight(a, 30);
        d -= SHA1Java.s3(e, a, b, c, this.w2[51]);
        b = Integer.rotateRight(b, 30);
        e -= SHA1Java.s3(a, b, c, d, this.w2[50]);
        c = Integer.rotateRight(c, 30);
        a -= SHA1Java.s3(b, c, d, e, this.w2[49]);
        d = Integer.rotateRight(d, 30);
        b -= SHA1Java.s3(c, d, e, a, this.w2[48]);
        e = Integer.rotateRight(e, 30);
        c -= SHA1Java.s3(d, e, a, b, this.w2[47]);
        a = Integer.rotateRight(a, 30);
        d -= SHA1Java.s3(e, a, b, c, this.w2[46]);
        b = Integer.rotateRight(b, 30);
        e -= SHA1Java.s3(a, b, c, d, this.w2[45]);
        c = Integer.rotateRight(c, 30);
        a -= SHA1Java.s3(b, c, d, e, this.w2[44]);
        d = Integer.rotateRight(d, 30);
        b -= SHA1Java.s3(c, d, e, a, this.w2[43]);
        e = Integer.rotateRight(e, 30);
        c -= SHA1Java.s3(d, e, a, b, this.w2[42]);
        a = Integer.rotateRight(a, 30);
        d -= SHA1Java.s3(e, a, b, c, this.w2[41]);
        b = Integer.rotateRight(b, 30);
        e -= SHA1Java.s3(a, b, c, d, this.w2[40]);
        c = Integer.rotateRight(c, 30);
        a -= SHA1Java.s2(b, c, d, e, this.w2[39]);
        d = Integer.rotateRight(d, 30);
        b -= SHA1Java.s2(c, d, e, a, this.w2[38]);
        e = Integer.rotateRight(e, 30);
        c -= SHA1Java.s2(d, e, a, b, this.w2[37]);
        a = Integer.rotateRight(a, 30);
        d -= SHA1Java.s2(e, a, b, c, this.w2[36]);
        b = Integer.rotateRight(b, 30);
        e -= SHA1Java.s2(a, b, c, d, this.w2[35]);
        c = Integer.rotateRight(c, 30);
        a -= SHA1Java.s2(b, c, d, e, this.w2[34]);
        d = Integer.rotateRight(d, 30);
        b -= SHA1Java.s2(c, d, e, a, this.w2[33]);
        e = Integer.rotateRight(e, 30);
        c -= SHA1Java.s2(d, e, a, b, this.w2[32]);
        a = Integer.rotateRight(a, 30);
        d -= SHA1Java.s2(e, a, b, c, this.w2[31]);
        b = Integer.rotateRight(b, 30);
        e -= SHA1Java.s2(a, b, c, d, this.w2[30]);
        c = Integer.rotateRight(c, 30);
        a -= SHA1Java.s2(b, c, d, e, this.w2[29]);
        d = Integer.rotateRight(d, 30);
        b -= SHA1Java.s2(c, d, e, a, this.w2[28]);
        e = Integer.rotateRight(e, 30);
        c -= SHA1Java.s2(d, e, a, b, this.w2[27]);
        a = Integer.rotateRight(a, 30);
        d -= SHA1Java.s2(e, a, b, c, this.w2[26]);
        b = Integer.rotateRight(b, 30);
        e -= SHA1Java.s2(a, b, c, d, this.w2[25]);
        c = Integer.rotateRight(c, 30);
        a -= SHA1Java.s2(b, c, d, e, this.w2[24]);
        d = Integer.rotateRight(d, 30);
        b -= SHA1Java.s2(c, d, e, a, this.w2[23]);
        e = Integer.rotateRight(e, 30);
        c -= SHA1Java.s2(d, e, a, b, this.w2[22]);
        a = Integer.rotateRight(a, 30);
        d -= SHA1Java.s2(e, a, b, c, this.w2[21]);
        b = Integer.rotateRight(b, 30);
        e -= SHA1Java.s2(a, b, c, d, this.w2[20]);
        c = Integer.rotateRight(c, 30);
        a -= SHA1Java.s1(b, c, d, e, this.w2[19]);
        d = Integer.rotateRight(d, 30);
        b -= SHA1Java.s1(c, d, e, a, this.w2[18]);
        e = Integer.rotateRight(e, 30);
        c -= SHA1Java.s1(d, e, a, b, this.w2[17]);
        a = Integer.rotateRight(a, 30);
        d -= SHA1Java.s1(e, a, b, c, this.w2[16]);
        b = Integer.rotateRight(b, 30);
        e -= SHA1Java.s1(a, b, c, d, this.w2[15]);
        c = Integer.rotateRight(c, 30);
        a -= SHA1Java.s1(b, c, d, e, this.w2[14]);
        d = Integer.rotateRight(d, 30);
        b -= SHA1Java.s1(c, d, e, a, this.w2[13]);
        e = Integer.rotateRight(e, 30);
        c -= SHA1Java.s1(d, e, a, b, this.w2[12]);
        a = Integer.rotateRight(a, 30);
        d -= SHA1Java.s1(e, a, b, c, this.w2[11]);
        b = Integer.rotateRight(b, 30);
        e -= SHA1Java.s1(a, b, c, d, this.w2[10]);
        c = Integer.rotateRight(c, 30);
        a -= SHA1Java.s1(b, c, d, e, this.w2[9]);
        d = Integer.rotateRight(d, 30);
        b -= SHA1Java.s1(c, d, e, a, this.w2[8]);
        e = Integer.rotateRight(e, 30);
        c -= SHA1Java.s1(d, e, a, b, this.w2[7]);
        a = Integer.rotateRight(a, 30);
        d -= SHA1Java.s1(e, a, b, c, this.w2[6]);
        b = Integer.rotateRight(b, 30);
        e -= SHA1Java.s1(a, b, c, d, this.w2[5]);
        c = Integer.rotateRight(c, 30);
        a -= SHA1Java.s1(b, c, d, e, this.w2[4]);
        d = Integer.rotateRight(d, 30);
        b -= SHA1Java.s1(c, d, e, a, this.w2[3]);
        e = Integer.rotateRight(e, 30);
        c -= SHA1Java.s1(d, e, a, b, this.w2[2]);
        a = Integer.rotateRight(a, 30);
        d -= SHA1Java.s1(e, a, b, c, this.w2[1]);
        b = Integer.rotateRight(b, 30);
        this.hIn.save(a, b, c, d, e -= SHA1Java.s1(a, b, c, d, this.w2[0]));
        a = s.a;
        b = s.b;
        c = s.c;
        d = s.d;
        e = s.e;
        if (t == 58) {
            b += SHA1Java.s3(c, d, e, a, this.w2[58]);
            d = Integer.rotateLeft(d, 30);
            a += SHA1Java.s3(b, c, d, e, this.w2[59]);
            c = Integer.rotateLeft(c, 30);
            e += SHA1Java.s4(a, b, c, d, this.w2[60]);
            b = Integer.rotateLeft(b, 30);
            d += SHA1Java.s4(e, a, b, c, this.w2[61]);
            a = Integer.rotateLeft(a, 30);
            c += SHA1Java.s4(d, e, a, b, this.w2[62]);
            e = Integer.rotateLeft(e, 30);
            b += SHA1Java.s4(c, d, e, a, this.w2[63]);
            d = Integer.rotateLeft(d, 30);
            a += SHA1Java.s4(b, c, d, e, this.w2[64]);
            c = Integer.rotateLeft(c, 30);
        }
        e += SHA1Java.s4(a, b, c, d, this.w2[65]);
        b = Integer.rotateLeft(b, 30);
        d += SHA1Java.s4(e, a, b, c, this.w2[66]);
        a = Integer.rotateLeft(a, 30);
        c += SHA1Java.s4(d, e, a, b, this.w2[67]);
        e = Integer.rotateLeft(e, 30);
        b += SHA1Java.s4(c, d, e, a, this.w2[68]);
        d = Integer.rotateLeft(d, 30);
        a += SHA1Java.s4(b, c, d, e, this.w2[69]);
        c = Integer.rotateLeft(c, 30);
        e += SHA1Java.s4(a, b, c, d, this.w2[70]);
        b = Integer.rotateLeft(b, 30);
        d += SHA1Java.s4(e, a, b, c, this.w2[71]);
        a = Integer.rotateLeft(a, 30);
        c += SHA1Java.s4(d, e, a, b, this.w2[72]);
        e = Integer.rotateLeft(e, 30);
        b += SHA1Java.s4(c, d, e, a, this.w2[73]);
        d = Integer.rotateLeft(d, 30);
        a += SHA1Java.s4(b, c, d, e, this.w2[74]);
        c = Integer.rotateLeft(c, 30);
        e += SHA1Java.s4(a, b, c, d, this.w2[75]);
        b = Integer.rotateLeft(b, 30);
        d += SHA1Java.s4(e, a, b, c, this.w2[76]);
        a = Integer.rotateLeft(a, 30);
        c += SHA1Java.s4(d, e, a, b, this.w2[77]);
        e = Integer.rotateLeft(e, 30);
        b += SHA1Java.s4(c, d, e, a, this.w2[78]);
        d = Integer.rotateLeft(d, 30);
        a += SHA1Java.s4(b, c, d, e, this.w2[79]);
        c = Integer.rotateLeft(c, 30);
        this.hTmp.save(this.hIn.a + a, this.hIn.b + b, this.hIn.c + c, this.hIn.d + d, this.hIn.e + e);
    }

    private static int s1(int a, int b, int c, int d, int w_t) {
        return Integer.rotateLeft(a, 5) + (b & c | ~b & d) + 1518500249 + w_t;
    }

    private static int s2(int a, int b, int c, int d, int w_t) {
        return Integer.rotateLeft(a, 5) + (b ^ c ^ d) + 1859775393 + w_t;
    }

    private static int s3(int a, int b, int c, int d, int w_t) {
        return Integer.rotateLeft(a, 5) + (b & c | b & d | c & d) + -1894007588 + w_t;
    }

    private static int s4(int a, int b, int c, int d, int w_t) {
        return Integer.rotateLeft(a, 5) + (b ^ c ^ d) + -899497514 + w_t;
    }

    private static boolean eq(State q, State r) {
        return q.a == r.a && q.b == r.b && q.c == r.c && q.d == r.d && q.e == r.e;
    }

    private void finish() {
        int bufferLen = (int)(this.length & 0x3FL);
        if (bufferLen > 55) {
            this.buffer[bufferLen++] = -128;
            Arrays.fill(this.buffer, bufferLen, 64, (byte)0);
            this.compress(this.buffer, 0);
            Arrays.fill(this.buffer, 0, 56, (byte)0);
        } else {
            this.buffer[bufferLen++] = -128;
            Arrays.fill(this.buffer, bufferLen, 56, (byte)0);
        }
        NB.encodeInt32(this.buffer, 56, (int)(this.length >>> 29));
        NB.encodeInt32(this.buffer, 60, (int)(this.length << 3));
        this.compress(this.buffer, 0);
        if (this.foundCollision) {
            ObjectId id = this.h.toObjectId();
            LOG.warn(MessageFormat.format(JGitText.get().sha1CollisionDetected, id.name()));
            throw new Sha1CollisionException(id);
        }
    }

    @Override
    public byte[] digest() throws Sha1CollisionException {
        this.finish();
        byte[] b = new byte[20];
        NB.encodeInt32(b, 0, this.h.a);
        NB.encodeInt32(b, 4, this.h.b);
        NB.encodeInt32(b, 8, this.h.c);
        NB.encodeInt32(b, 12, this.h.d);
        NB.encodeInt32(b, 16, this.h.e);
        return b;
    }

    @Override
    public ObjectId toObjectId() throws Sha1CollisionException {
        this.finish();
        return this.h.toObjectId();
    }

    @Override
    public void digest(MutableObjectId id) throws Sha1CollisionException {
        this.finish();
        id.set(this.h.a, this.h.b, this.h.c, this.h.d, this.h.e);
    }

    @Override
    public boolean hasCollision() {
        return this.foundCollision;
    }

    @Override
    public SHA1 reset() {
        this.h.init();
        this.length = 0L;
        this.foundCollision = false;
        return this;
    }

    static {
        SystemReader sr = SystemReader.getInstance();
        String v = sr.getProperty("org.eclipse.jgit.util.sha1.detectCollision");
        DETECT_COLLISIONS = v != null ? Boolean.parseBoolean(v) : true;
    }

    private static final class State {
        int a;
        int b;
        int c;
        int d;
        int e;

        private State() {
        }

        final void init() {
            this.save(1732584193, -271733879, -1732584194, 271733878, -1009589776);
        }

        final void save(int a1, int b1, int c1, int d1, int e1) {
            this.a = a1;
            this.b = b1;
            this.c = c1;
            this.d = d1;
            this.e = e1;
        }

        ObjectId toObjectId() {
            return new ObjectId(this.a, this.b, this.c, this.d, this.e);
        }
    }
}

