/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.util.io;

import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.jgit.util.Base85;

public class BinaryHunkOutputStream
extends OutputStream {
    private static final int MAX_BYTES = 52;
    private final OutputStream out;
    private final byte[] buffer = new byte[52];
    private int pos;

    public BinaryHunkOutputStream(OutputStream out) {
        this.out = out;
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.out.close();
    }

    @Override
    public void flush() throws IOException {
        if (this.pos > 0) {
            this.encode(this.buffer, 0, this.pos);
            this.pos = 0;
        }
        this.out.flush();
    }

    @Override
    public void write(int b) throws IOException {
        this.buffer[this.pos++] = (byte)b;
        if (this.pos == this.buffer.length) {
            this.encode(this.buffer, 0, this.pos);
            this.pos = 0;
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (len == 0) {
            return;
        }
        int toCopy = len;
        int in = off;
        if (this.pos > 0) {
            int chunk = Math.min(toCopy, this.buffer.length - this.pos);
            System.arraycopy(b, in, this.buffer, this.pos, chunk);
            in += chunk;
            this.pos += chunk;
            toCopy -= chunk;
            if (this.pos == this.buffer.length) {
                this.encode(this.buffer, 0, this.pos);
                this.pos = 0;
            }
            if (toCopy == 0) {
                return;
            }
        }
        while (toCopy >= 52) {
            this.encode(b, in, 52);
            toCopy -= 52;
            in += 52;
        }
        if (toCopy > 0) {
            System.arraycopy(b, in, this.buffer, 0, toCopy);
            this.pos = toCopy;
        }
    }

    private void encode(byte[] data, int off, int length) throws IOException {
        if (length <= 26) {
            this.out.write(65 + length - 1);
        } else {
            this.out.write(97 + length - 27);
        }
        this.out.write(Base85.encode(data, off, length));
        this.out.write(10);
    }
}

