/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.eclipse.jgit.errors.NoRemoteRepositoryException;
import org.eclipse.jgit.errors.NotSupportedException;
import org.eclipse.jgit.errors.TransportException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryBuilder;
import org.eclipse.jgit.lib.RepositoryCache;
import org.eclipse.jgit.transport.BasePackFetchConnection;
import org.eclipse.jgit.transport.BasePackPushConnection;
import org.eclipse.jgit.transport.FetchConnection;
import org.eclipse.jgit.transport.InternalFetchConnection;
import org.eclipse.jgit.transport.InternalPushConnection;
import org.eclipse.jgit.transport.PackTransport;
import org.eclipse.jgit.transport.PushConnection;
import org.eclipse.jgit.transport.ReceivePack;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.TransferConfig;
import org.eclipse.jgit.transport.Transport;
import org.eclipse.jgit.transport.TransportBundleFile;
import org.eclipse.jgit.transport.TransportProtocol;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.transport.UploadPack;
import org.eclipse.jgit.transport.resolver.ReceivePackFactory;
import org.eclipse.jgit.transport.resolver.UploadPackFactory;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.io.MessageWriter;
import org.eclipse.jgit.util.io.StreamCopyThread;

class TransportLocal
extends Transport
implements PackTransport {
    static final TransportProtocol PROTO_LOCAL = new TransportProtocol(){

        @Override
        public String getName() {
            return JGitText.get().transportProtoLocal;
        }

        @Override
        public Set<String> getSchemes() {
            return Collections.singleton("file");
        }

        @Override
        public boolean canHandle(URIish uri, Repository local, String remoteName) {
            return uri.getPath() != null && uri.getPort() <= 0 && uri.getUser() == null && uri.getPass() == null && uri.getHost() == null && (uri.getScheme() == null || this.getSchemes().contains(uri.getScheme()));
        }

        @Override
        public Transport open(URIish uri, Repository local, String remoteName) throws NoRemoteRepositoryException {
            File localPath = local.isBare() ? local.getDirectory() : local.getWorkTree();
            File path = local.getFS().resolve(localPath, uri.getPath());
            if (path.isFile()) {
                return new TransportBundleFile(local, uri, path);
            }
            File gitDir = RepositoryCache.FileKey.resolve(path, local.getFS());
            if (gitDir == null) {
                throw new NoRemoteRepositoryException(uri, JGitText.get().notFound);
            }
            return new TransportLocal(local, uri, gitDir);
        }

        @Override
        public Transport open(URIish uri) throws NotSupportedException, TransportException {
            File path = FS.DETECTED.resolve(new File("."), uri.getPath());
            if (path.isFile()) {
                return new TransportBundleFile(uri, path);
            }
            File gitDir = RepositoryCache.FileKey.resolve(path, FS.DETECTED);
            if (gitDir == null) {
                throw new NoRemoteRepositoryException(uri, JGitText.get().notFound);
            }
            return new TransportLocal(uri, gitDir);
        }
    };
    private final File remoteGitDir;

    TransportLocal(Repository local, URIish uri, File gitDir) {
        super(local, uri);
        this.remoteGitDir = gitDir;
    }

    TransportLocal(URIish uri, File gitDir) {
        super(uri);
        this.remoteGitDir = gitDir;
    }

    UploadPack createUploadPack(Repository dst) {
        return new UploadPack(dst);
    }

    ReceivePack createReceivePack(Repository dst) {
        return new ReceivePack(dst);
    }

    private Repository openRepo() throws TransportException {
        try {
            return ((RepositoryBuilder)((RepositoryBuilder)new RepositoryBuilder().setFS(this.local != null ? this.local.getFS() : FS.DETECTED)).setGitDir(this.remoteGitDir)).build();
        }
        catch (IOException err) {
            TransportException te = new TransportException(this.uri, JGitText.get().notAGitDirectory);
            te.initCause(err);
            throw te;
        }
    }

    @Override
    public FetchConnection openFetch() throws TransportException {
        return this.openFetch(Collections.emptyList(), new String[0]);
    }

    @Override
    public FetchConnection openFetch(Collection<RefSpec> refSpecs, String ... additionalPatterns) throws TransportException {
        String up = this.getOptionUploadPack();
        if (!"git-upload-pack".equals(up) && !"git upload-pack".equals(up)) {
            return new ForkLocalFetchConnection(refSpecs, additionalPatterns);
        }
        UploadPackFactory<Void> upf = (req, db) -> this.createUploadPack(db);
        return new InternalFetchConnection<Object>(this, upf, null, this.openRepo());
    }

    @Override
    public PushConnection openPush() throws TransportException {
        String rp = this.getOptionReceivePack();
        if (!"git-receive-pack".equals(rp) && !"git receive-pack".equals(rp)) {
            return new ForkLocalPushConnection();
        }
        ReceivePackFactory<Void> rpf = (req, db) -> this.createReceivePack(db);
        return new InternalPushConnection<Object>(this, rpf, null, this.openRepo());
    }

    @Override
    public void close() {
    }

    protected Process spawn(String cmd) throws TransportException {
        return this.spawn(cmd, null);
    }

    private Process spawn(String cmd, TransferConfig.ProtocolVersion protocolVersion) throws TransportException {
        try {
            String[] args = new String[]{"."};
            ProcessBuilder proc = this.local.getFS().runInShell(cmd, args);
            proc.directory(this.remoteGitDir);
            Map<String, String> env = proc.environment();
            env.remove("GIT_ALTERNATE_OBJECT_DIRECTORIES");
            env.remove("GIT_CONFIG");
            env.remove("GIT_CONFIG_PARAMETERS");
            env.remove("GIT_DIR");
            env.remove("GIT_WORK_TREE");
            env.remove("GIT_GRAFT_FILE");
            env.remove("GIT_INDEX_FILE");
            env.remove("GIT_NO_REPLACE_OBJECTS");
            if (TransferConfig.ProtocolVersion.V2.equals((Object)protocolVersion)) {
                env.put("GIT_PROTOCOL", "version=2");
            }
            return proc.start();
        }
        catch (IOException err) {
            throw new TransportException(this.uri, err.getMessage(), err);
        }
    }

    class ForkLocalPushConnection
    extends BasePackPushConnection {
        private Process receivePack;
        private Thread errorReaderThread;

        ForkLocalPushConnection() throws TransportException {
            super(TransportLocal.this);
            MessageWriter msg = new MessageWriter();
            this.setMessageWriter(msg);
            this.receivePack = TransportLocal.this.spawn(TransportLocal.this.getOptionReceivePack());
            InputStream rpErr = this.receivePack.getErrorStream();
            this.errorReaderThread = new StreamCopyThread(rpErr, msg.getRawStream());
            this.errorReaderThread.start();
            InputStream rpIn = this.receivePack.getInputStream();
            OutputStream rpOut = this.receivePack.getOutputStream();
            rpIn = new BufferedInputStream(rpIn);
            rpOut = new BufferedOutputStream(rpOut);
            this.init(rpIn, rpOut);
            this.readAdvertisedRefs();
        }

        @Override
        public void close() {
            super.close();
            if (this.receivePack != null) {
                try {
                    this.receivePack.waitFor();
                }
                catch (InterruptedException interruptedException) {
                }
                finally {
                    this.receivePack = null;
                }
            }
            if (this.errorReaderThread != null) {
                try {
                    this.errorReaderThread.join();
                }
                catch (InterruptedException interruptedException) {
                }
                finally {
                    this.errorReaderThread = null;
                }
            }
        }
    }

    class ForkLocalFetchConnection
    extends BasePackFetchConnection {
        private Process uploadPack;
        private Thread errorReaderThread;

        ForkLocalFetchConnection() throws TransportException {
            this(Collections.emptyList(), new String[0]);
        }

        ForkLocalFetchConnection(Collection<RefSpec> refSpecs, String ... additionalPatterns) throws TransportException {
            super(TransportLocal.this);
            MessageWriter msg = new MessageWriter();
            this.setMessageWriter(msg);
            TransferConfig.ProtocolVersion gitProtocol = TransportLocal.this.protocol;
            if (gitProtocol == null) {
                gitProtocol = TransferConfig.ProtocolVersion.V2;
            }
            this.uploadPack = TransportLocal.this.spawn(TransportLocal.this.getOptionUploadPack(), gitProtocol);
            InputStream upErr = this.uploadPack.getErrorStream();
            this.errorReaderThread = new StreamCopyThread(upErr, msg.getRawStream());
            this.errorReaderThread.start();
            InputStream upIn = this.uploadPack.getInputStream();
            OutputStream upOut = this.uploadPack.getOutputStream();
            upIn = new BufferedInputStream(upIn);
            upOut = new BufferedOutputStream(upOut);
            this.init(upIn, upOut);
            if (!this.readAdvertisedRefs()) {
                this.lsRefs(refSpecs, additionalPatterns);
            }
        }

        @Override
        public void close() {
            super.close();
            if (this.uploadPack != null) {
                try {
                    this.uploadPack.waitFor();
                }
                catch (InterruptedException interruptedException) {
                }
                finally {
                    this.uploadPack = null;
                }
            }
            if (this.errorReaderThread != null) {
                try {
                    this.errorReaderThread.join();
                }
                catch (InterruptedException interruptedException) {
                }
                finally {
                    this.errorReaderThread = null;
                }
            }
        }
    }
}

