/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.file;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.text.MessageFormat;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.storage.file.RefDirectory;
import org.eclipse.jgit.internal.storage.file.WriteConfig;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.CoreConfig;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.ReflogEntry;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.util.FileUtils;

public class ReflogWriter {
    private final RefDirectory refdb;
    private final boolean forceWrite;

    public static String refLockFor(String name) {
        return name + ".lock";
    }

    public ReflogWriter(RefDirectory refdb) {
        this(refdb, false);
    }

    public ReflogWriter(RefDirectory refdb, boolean forceWrite) {
        this.refdb = refdb;
        this.forceWrite = forceWrite;
    }

    public ReflogWriter create() throws IOException {
        FileUtils.mkdir(this.refdb.logsDir);
        FileUtils.mkdir(this.refdb.logsRefsDir);
        FileUtils.mkdir(new File(this.refdb.logsRefsDir, "refs/heads/".substring("refs/".length())));
        return this;
    }

    public ReflogWriter log(String refName, ReflogEntry entry) throws IOException {
        return this.log(refName, entry.getOldId(), entry.getNewId(), entry.getWho(), entry.getComment());
    }

    public ReflogWriter log(String refName, ObjectId oldId, ObjectId newId, PersonIdent ident, String message) throws IOException {
        byte[] encoded = this.encode(oldId, newId, ident, message);
        return this.log(refName, encoded);
    }

    public ReflogWriter log(RefUpdate update, String msg, boolean deref) throws IOException {
        ObjectId oldId = update.getOldObjectId();
        ObjectId newId = update.getNewObjectId();
        Ref ref = update.getRef();
        PersonIdent ident = update.getRefLogIdent();
        ident = ident == null ? new PersonIdent(this.refdb.getRepository()) : new PersonIdent(ident);
        byte[] rec = this.encode(oldId, newId, ident, msg);
        if (deref && ref.isSymbolic()) {
            this.log(ref.getName(), rec);
            this.log(ref.getLeaf().getName(), rec);
        } else {
            this.log(ref.getName(), rec);
        }
        return this;
    }

    private byte[] encode(ObjectId oldId, ObjectId newId, PersonIdent ident, String message) {
        StringBuilder r = new StringBuilder();
        r.append(ObjectId.toString(oldId));
        r.append(' ');
        r.append(ObjectId.toString(newId));
        r.append(' ');
        r.append(ident.toExternalString());
        r.append('\t');
        r.append(message.replace("\r\n", " ").replace("\n", " "));
        r.append('\n');
        return Constants.encode(r.toString());
    }

    private FileOutputStream getFileOutputStream(File log) throws IOException {
        try {
            return new FileOutputStream(log, true);
        }
        catch (FileNotFoundException err) {
            File dir = log.getParentFile();
            if (dir.exists()) {
                throw err;
            }
            if (!dir.mkdirs() && !dir.isDirectory()) {
                throw new IOException(MessageFormat.format(JGitText.get().cannotCreateDirectory, dir));
            }
            return new FileOutputStream(log, true);
        }
    }

    private ReflogWriter log(String refName, byte[] rec) throws IOException {
        boolean write;
        File log = this.refdb.logFor(refName);
        boolean bl = write = this.forceWrite || this.shouldAutoCreateLog(refName) || log.isFile();
        if (!write) {
            return this;
        }
        WriteConfig wc = this.refdb.getRepository().getConfig().get(WriteConfig.KEY);
        try (FileOutputStream out = this.getFileOutputStream(log);){
            if (wc.getFSyncRefFiles()) {
                FileChannel fc = out.getChannel();
                ByteBuffer buf = ByteBuffer.wrap(rec);
                while (0 < buf.remaining()) {
                    fc.write(buf);
                }
                fc.force(true);
            } else {
                out.write(rec);
            }
        }
        return this;
    }

    private boolean shouldAutoCreateLog(String refName) {
        Repository repo = this.refdb.getRepository();
        CoreConfig.LogRefUpdates value = repo.isBare() ? CoreConfig.LogRefUpdates.FALSE : CoreConfig.LogRefUpdates.TRUE;
        value = repo.getConfig().getEnum("core", null, "logallrefupdates", value);
        if (value != null) {
            switch (value) {
                case FALSE: {
                    break;
                }
                case TRUE: {
                    return refName.equals("HEAD") || refName.startsWith("refs/heads/") || refName.startsWith("refs/remotes/") || refName.startsWith("refs/notes/");
                }
                case ALWAYS: {
                    return refName.equals("HEAD") || refName.startsWith("refs/");
                }
            }
        }
        return false;
    }
}

