/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.gitrepo;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.TreeMap;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.GitCommand;
import org.eclipse.jgit.api.SubmoduleAddCommand;
import org.eclipse.jgit.api.errors.ConcurrentRefUpdateException;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.InvalidRefNameException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheBuilder;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.gitrepo.ManifestParser;
import org.eclipse.jgit.gitrepo.RepoProject;
import org.eclipse.jgit.gitrepo.internal.RepoText;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.CommitBuilder;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefDatabase;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.util.FileUtils;

public class RepoCommand
extends GitCommand<RevCommit> {
    private static final int LOCK_FAILURE_MAX_RETRIES = 5;
    private static final int LOCK_FAILURE_MIN_RETRY_DELAY_MILLIS = 50;
    private static final int LOCK_FAILURE_MAX_RETRY_DELAY_MILLIS = 5000;
    private String manifestPath;
    private String baseUri;
    private URI targetUri;
    private String groupsParam;
    private String branch;
    private String targetBranch = "HEAD";
    private boolean recordRemoteBranch = true;
    private boolean recordSubmoduleLabels = true;
    private boolean recordShallowSubmodules = true;
    private PersonIdent author;
    private RemoteReader callback;
    private InputStream inputStream;
    private ManifestParser.IncludedFileReader includedReader;
    private boolean ignoreRemoteFailures = false;
    private ProgressMonitor monitor;
    private static final String SLASH = "/";

    public RepoCommand(Repository repo) {
        super(repo);
    }

    public RepoCommand setPath(String path) {
        this.manifestPath = path;
        return this;
    }

    public RepoCommand setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
        return this;
    }

    public RepoCommand setURI(String uri) {
        this.baseUri = uri;
        return this;
    }

    public RepoCommand setTargetURI(String uri) {
        this.targetUri = URI.create(uri + SLASH);
        return this;
    }

    public RepoCommand setGroups(String groups) {
        this.groupsParam = groups;
        return this;
    }

    public RepoCommand setBranch(String branch) {
        this.branch = branch;
        return this;
    }

    public RepoCommand setTargetBranch(String branch) {
        this.targetBranch = "refs/heads/" + branch;
        return this;
    }

    public RepoCommand setRecordRemoteBranch(boolean enable) {
        this.recordRemoteBranch = enable;
        return this;
    }

    public RepoCommand setRecordSubmoduleLabels(boolean enable) {
        this.recordSubmoduleLabels = enable;
        return this;
    }

    public RepoCommand setRecommendShallow(boolean enable) {
        this.recordShallowSubmodules = enable;
        return this;
    }

    public RepoCommand setProgressMonitor(ProgressMonitor monitor) {
        this.monitor = monitor;
        return this;
    }

    public RepoCommand setIgnoreRemoteFailures(boolean ignore) {
        this.ignoreRemoteFailures = ignore;
        return this;
    }

    public RepoCommand setAuthor(PersonIdent author) {
        this.author = author;
        return this;
    }

    public RepoCommand setRemoteReader(RemoteReader callback) {
        this.callback = callback;
        return this;
    }

    public RepoCommand setIncludedFileReader(ManifestParser.IncludedFileReader reader) {
        this.includedReader = reader;
        return this;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public RevCommit call() throws GitAPIException {
        List<RepoProject> filteredProjects;
        this.checkCallable();
        if (this.baseUri == null) {
            this.baseUri = "";
        }
        if (this.inputStream == null) {
            if (this.manifestPath == null || this.manifestPath.length() == 0) {
                throw new IllegalArgumentException(JGitText.get().pathNotConfigured);
            }
            try {
                this.inputStream = new FileInputStream(this.manifestPath);
            }
            catch (IOException e) {
                throw new IllegalArgumentException(JGitText.get().pathNotConfigured, e);
            }
        }
        try {
            ManifestParser parser = new ManifestParser(this.includedReader, this.manifestPath, this.branch, this.baseUri, this.groupsParam, this.repo);
            parser.read(this.inputStream);
            filteredProjects = parser.getFilteredProjects();
        }
        catch (IOException e) {
            throw new ManifestErrorException(e);
        }
        finally {
            try {
                this.inputStream.close();
            }
            catch (IOException iOException) {}
        }
        if (this.repo.isBare()) {
            if (this.author == null) {
                this.author = new PersonIdent(this.repo);
            }
            if (this.callback == null) {
                this.callback = new DefaultRemoteReader();
            }
            List<RepoProject> renamedProjects = this.renameProjects(filteredProjects);
            DirCache index = DirCache.newInCore();
            DirCacheBuilder builder = index.builder();
            ObjectInserter inserter = this.repo.newObjectInserter();
            try (RevWalk rw = new RevWalk(this.repo);){
                Object dcEntry;
                Config cfg = new Config();
                StringBuilder attributes = new StringBuilder();
                for (RepoProject proj : renamedProjects) {
                    ObjectId objectId;
                    String name = proj.getName();
                    String path = proj.getPath();
                    String url = proj.getUrl();
                    if (ObjectId.isId(proj.getRevision())) {
                        objectId = ObjectId.fromString(proj.getRevision());
                    } else {
                        objectId = this.callback.sha1(url, proj.getRevision());
                        if (objectId == null && !this.ignoreRemoteFailures) {
                            throw new RemoteUnavailableException(url);
                        }
                        if (this.recordRemoteBranch) {
                            String field = proj.getRevision().startsWith("refs/tags/") ? "ref" : "branch";
                            cfg.setString("submodule", name, field, proj.getRevision());
                        }
                        if (this.recordShallowSubmodules && proj.getRecommendShallow() != null) {
                            cfg.setBoolean("submodule", name, "shallow", true);
                        }
                    }
                    if (this.recordSubmoduleLabels) {
                        StringBuilder rec = new StringBuilder();
                        rec.append(SLASH);
                        rec.append(path);
                        for (String group : proj.getGroups()) {
                            rec.append(" ");
                            rec.append(group);
                        }
                        rec.append("\n");
                        attributes.append(rec.toString());
                    }
                    URI submodUrl = URI.create(url);
                    if (this.targetUri != null) {
                        submodUrl = RepoCommand.relativize(this.targetUri, submodUrl);
                    }
                    cfg.setString("submodule", name, "path", path);
                    cfg.setString("submodule", name, "url", submodUrl.toString());
                    if (objectId == null) continue;
                    dcEntry = new DirCacheEntry(path);
                    ((DirCacheEntry)dcEntry).setObjectId(objectId);
                    ((DirCacheEntry)dcEntry).setFileMode(FileMode.GITLINK);
                    builder.add((DirCacheEntry)dcEntry);
                    for (RepoProject.CopyFile copyfile : proj.getCopyFiles()) {
                        RemoteFile rf = this.callback.readFileWithMode(url, proj.getRevision(), copyfile.src);
                        objectId = inserter.insert(3, rf.getContents());
                        dcEntry = new DirCacheEntry(copyfile.dest);
                        ((DirCacheEntry)dcEntry).setObjectId(objectId);
                        ((DirCacheEntry)dcEntry).setFileMode(rf.getFileMode());
                        builder.add((DirCacheEntry)dcEntry);
                    }
                    for (RepoProject.LinkFile linkfile : proj.getLinkFiles()) {
                        String link = linkfile.dest.contains(SLASH) ? FileUtils.relativizeGitPath(linkfile.dest.substring(0, linkfile.dest.lastIndexOf(47)), proj.getPath() + SLASH + linkfile.src) : proj.getPath() + SLASH + linkfile.src;
                        objectId = inserter.insert(3, link.getBytes(StandardCharsets.UTF_8));
                        dcEntry = new DirCacheEntry(linkfile.dest);
                        ((DirCacheEntry)dcEntry).setObjectId(objectId);
                        ((DirCacheEntry)dcEntry).setFileMode(FileMode.SYMLINK);
                        builder.add((DirCacheEntry)dcEntry);
                    }
                }
                String content = cfg.toText();
                DirCacheEntry dcEntry2 = new DirCacheEntry(".gitmodules");
                ObjectId objectId = inserter.insert(3, content.getBytes(StandardCharsets.UTF_8));
                dcEntry2.setObjectId(objectId);
                dcEntry2.setFileMode(FileMode.REGULAR_FILE);
                builder.add(dcEntry2);
                if (this.recordSubmoduleLabels) {
                    DirCacheEntry dcEntryAttr = new DirCacheEntry(".gitattributes");
                    ObjectId attrId = inserter.insert(3, attributes.toString().getBytes(StandardCharsets.UTF_8));
                    dcEntryAttr.setObjectId(attrId);
                    dcEntryAttr.setFileMode(FileMode.REGULAR_FILE);
                    builder.add(dcEntryAttr);
                }
                builder.finish();
                ObjectId treeId = index.writeTree(inserter);
                long prevDelay = 0L;
                for (int i = 0; i < 4; ++i) {
                    try {
                        dcEntry = this.commitTreeOnCurrentTip(inserter, rw, treeId);
                        return dcEntry;
                    }
                    catch (ConcurrentRefUpdateException e) {
                        prevDelay = FileUtils.delay(prevDelay, 50L, 5000L);
                        Thread.sleep(prevDelay);
                        this.repo.getRefDatabase().refresh();
                        continue;
                    }
                }
                RevCommit revCommit = this.commitTreeOnCurrentTip(inserter, rw, treeId);
                return revCommit;
            }
            catch (IOException | InterruptedException | GitAPIException e) {
                throw new ManifestErrorException(e);
            }
        }
        try (Git git = new Git(this.repo);){
            for (RepoProject proj : filteredProjects) {
                this.addSubmodule(proj.getName(), proj.getUrl(), proj.getPath(), proj.getRevision(), proj.getCopyFiles(), proj.getLinkFiles(), git);
            }
            RevCommit revCommit = git.commit().setMessage(RepoText.get().repoCommitMessage).call();
            return revCommit;
        }
        catch (IOException | GitAPIException e) {
            throw new ManifestErrorException(e);
        }
    }

    private RevCommit commitTreeOnCurrentTip(ObjectInserter inserter, RevWalk rw, ObjectId treeId) throws IOException, ConcurrentRefUpdateException {
        ObjectId headId = this.repo.resolve(this.targetBranch + "^{commit}");
        if (headId != null && rw.parseCommit(headId).getTree().getId().equals(treeId)) {
            return rw.parseCommit(headId);
        }
        CommitBuilder commit = new CommitBuilder();
        commit.setTreeId(treeId);
        if (headId != null) {
            commit.setParentIds(headId);
        }
        commit.setAuthor(this.author);
        commit.setCommitter(this.author);
        commit.setMessage(RepoText.get().repoCommitMessage);
        ObjectId commitId = inserter.insert(commit);
        inserter.flush();
        RefUpdate ru = this.repo.updateRef(this.targetBranch);
        ru.setNewObjectId(commitId);
        ru.setExpectedOldObjectId(headId != null ? headId : ObjectId.zeroId());
        RefUpdate.Result rc = ru.update(rw);
        switch (rc) {
            case NEW: 
            case FORCED: 
            case FAST_FORWARD: {
                break;
            }
            case REJECTED: 
            case LOCK_FAILURE: {
                throw new ConcurrentRefUpdateException(MessageFormat.format(JGitText.get().cannotLock, this.targetBranch), ru.getRef(), rc);
            }
            default: {
                throw new JGitInternalException(MessageFormat.format(JGitText.get().updatingRefFailed, new Object[]{this.targetBranch, commitId.name(), rc}));
            }
        }
        return rw.parseCommit(commitId);
    }

    private void addSubmodule(String name, String url, String path, String revision, List<RepoProject.CopyFile> copyfiles, List<RepoProject.LinkFile> linkfiles, Git git) throws GitAPIException, IOException {
        assert (!this.repo.isBare());
        assert (git != null);
        if (!linkfiles.isEmpty()) {
            throw new UnsupportedOperationException(JGitText.get().nonBareLinkFilesNotSupported);
        }
        SubmoduleAddCommand add = git.submoduleAdd().setName(name).setPath(path).setURI(url);
        if (this.monitor != null) {
            add.setProgressMonitor(this.monitor);
        }
        Repository subRepo = add.call();
        if (revision != null) {
            try (Git sub = new Git(subRepo);){
                sub.checkout().setName(RepoCommand.findRef(revision, subRepo)).call();
            }
            subRepo.close();
            git.add().addFilepattern(path).call();
        }
        for (RepoProject.CopyFile copyfile : copyfiles) {
            copyfile.copy();
            git.add().addFilepattern(copyfile.dest).call();
        }
    }

    private List<RepoProject> renameProjects(List<RepoProject> projects) {
        TreeMap<String, ArrayList<RepoProject>> m = new TreeMap<String, ArrayList<RepoProject>>();
        for (RepoProject proj : projects) {
            ArrayList<RepoProject> l = (ArrayList<RepoProject>)m.get(proj.getName());
            if (l == null) {
                l = new ArrayList<RepoProject>();
                m.put(proj.getName(), l);
            }
            l.add(proj);
        }
        ArrayList<RepoProject> ret = new ArrayList<RepoProject>();
        for (List ps : m.values()) {
            boolean nameConflict = ps.size() != 1;
            for (RepoProject proj : ps) {
                String name = proj.getName();
                if (nameConflict) {
                    name = name + SLASH + proj.getPath();
                }
                RepoProject p = new RepoProject(name, proj.getPath(), proj.getRevision(), null, proj.getGroups(), proj.getRecommendShallow());
                p.setUrl(proj.getUrl());
                p.addCopyFiles(proj.getCopyFiles());
                p.addLinkFiles(proj.getLinkFiles());
                ret.add(p);
            }
        }
        return ret;
    }

    static URI relativize(URI current, URI target) {
        int i;
        if (!Objects.equals(current.getHost(), target.getHost())) {
            return target;
        }
        String cur = current.normalize().getPath();
        String dest = target.normalize().getPath();
        if (cur.startsWith(SLASH) != dest.startsWith(SLASH)) {
            return target;
        }
        while (cur.startsWith(SLASH)) {
            cur = cur.substring(1);
        }
        while (dest.startsWith(SLASH)) {
            dest = dest.substring(1);
        }
        if (cur.indexOf(47) == -1 || dest.indexOf(47) == -1) {
            String prefix = "prefix/";
            cur = prefix + cur;
            dest = prefix + dest;
        }
        if (!cur.endsWith(SLASH)) {
            int lastSlash = cur.lastIndexOf(47);
            cur = cur.substring(0, lastSlash);
        }
        String destFile = "";
        if (!dest.endsWith(SLASH)) {
            int lastSlash = dest.lastIndexOf(47);
            destFile = dest.substring(lastSlash + 1, dest.length());
            dest = dest.substring(0, dest.lastIndexOf(47));
        }
        String[] cs = cur.split(SLASH);
        String[] ds = dest.split(SLASH);
        for (int common = 0; common < cs.length && common < ds.length && cs[common].equals(ds[common]); ++common) {
        }
        StringJoiner j = new StringJoiner(SLASH);
        for (i = common; i < cs.length; ++i) {
            j.add("..");
        }
        for (i = common; i < ds.length; ++i) {
            j.add(ds[i]);
        }
        j.add(destFile);
        return URI.create(j.toString());
    }

    private static String findRef(String ref, Repository repo) throws IOException {
        Ref r;
        if (!ObjectId.isId(ref) && (r = repo.exactRef("refs/remotes/origin/" + ref)) != null) {
            return r.getName();
        }
        return ref;
    }

    private static class RemoteUnavailableException
    extends GitAPIException {
        RemoteUnavailableException(String uri) {
            super(MessageFormat.format(RepoText.get().errorRemoteUnavailable, uri));
        }
    }

    private static class ManifestErrorException
    extends GitAPIException {
        ManifestErrorException(Throwable cause) {
            super(RepoText.get().invalidManifest, cause);
        }
    }

    public static class DefaultRemoteReader
    implements RemoteReader {
        @Override
        public ObjectId sha1(String uri, String ref) throws GitAPIException {
            Map<String, Ref> map = Git.lsRemoteRepository().setRemote(uri).callAsMap();
            Ref r = RefDatabase.findRef(map, ref);
            return r != null ? r.getObjectId() : null;
        }

        /*
         * Loose catch block
         */
        @Override
        public RemoteFile readFileWithMode(String uri, String ref, String path) throws GitAPIException, IOException {
            File dir = FileUtils.createTempDir("jgit_", ".git", null);
            try {
                try (Git git = Git.cloneRepository().setBare(true).setDirectory(dir).setURI(uri).call();){
                    Repository repo = git.getRepository();
                    ObjectId refCommitId = this.sha1(uri, ref);
                    if (refCommitId == null) {
                        throw new InvalidRefNameException(MessageFormat.format(JGitText.get().refNotResolved, ref));
                    }
                    RevCommit commit = repo.parseCommit(refCommitId);
                    TreeWalk tw = TreeWalk.forPath(repo, path, commit.getTree());
                    RemoteFile remoteFile = new RemoteFile(tw.getObjectReader().open(tw.getObjectId(0)).getCachedBytes(Integer.MAX_VALUE), tw.getFileMode(0));
                    return remoteFile;
                }
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                FileUtils.delete(dir, 1);
            }
        }
    }

    public static final class RemoteFile {
        @NonNull
        private final byte[] contents;
        @NonNull
        private final FileMode fileMode;

        public RemoteFile(@NonNull byte[] contents, @NonNull FileMode fileMode) {
            this.contents = Objects.requireNonNull(contents);
            this.fileMode = Objects.requireNonNull(fileMode);
        }

        @NonNull
        public byte[] getContents() {
            return this.contents;
        }

        @NonNull
        public FileMode getFileMode() {
            return this.fileMode;
        }
    }

    public static interface RemoteReader {
        @Nullable
        public ObjectId sha1(String var1, String var2) throws GitAPIException;

        @Deprecated
        default public byte[] readFile(String uri, String ref, String path) throws GitAPIException, IOException {
            return this.readFileWithMode(uri, ref, path).getContents();
        }

        @NonNull
        public RemoteFile readFileWithMode(String var1, String var2, String var3) throws GitAPIException, IOException;
    }
}

