/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.api;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.jgit.api.GitCommand;
import org.eclipse.jgit.api.SubmoduleDeinitResult;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.submodule.SubmoduleWalk;
import org.eclipse.jgit.treewalk.filter.PathFilter;
import org.eclipse.jgit.treewalk.filter.PathFilterGroup;
import org.eclipse.jgit.util.FileUtils;

public class SubmoduleDeinitCommand
extends GitCommand<Collection<SubmoduleDeinitResult>> {
    private final Collection<String> paths = new ArrayList<String>();
    private boolean force;

    public SubmoduleDeinitCommand(Repository repo) {
        super(repo);
    }

    @Override
    public Collection<SubmoduleDeinitResult> call() throws GitAPIException {
        this.checkCallable();
        try {
            if (this.paths.isEmpty()) {
                return Collections.emptyList();
            }
            for (String path : this.paths) {
                if (this.submoduleExists(path)) continue;
                throw new NoSuchSubmoduleException(path);
            }
            ArrayList<SubmoduleDeinitResult> results = new ArrayList<SubmoduleDeinitResult>(this.paths.size());
            Object object = null;
            Object var3_5 = null;
            try {
                RevWalk revWalk = new RevWalk(this.repo);
                try {
                    try (SubmoduleWalk generator = SubmoduleWalk.forIndex(this.repo);){
                        generator.setFilter(PathFilterGroup.createFromStrings(this.paths));
                        StoredConfig config = this.repo.getConfig();
                        while (generator.next()) {
                            String path = generator.getPath();
                            String name = generator.getModuleName();
                            SubmoduleDeinitStatus status = this.checkDirty(revWalk, path);
                            switch (status) {
                                case SUCCESS: {
                                    this.deinit(path);
                                    break;
                                }
                                case ALREADY_DEINITIALIZED: {
                                    break;
                                }
                                case DIRTY: {
                                    if (!this.force) break;
                                    this.deinit(path);
                                    status = SubmoduleDeinitStatus.FORCED;
                                    break;
                                }
                                default: {
                                    throw new JGitInternalException(MessageFormat.format(JGitText.get().unexpectedSubmoduleStatus, new Object[]{status}));
                                }
                            }
                            config.unsetSection("submodule", name);
                            results.add(new SubmoduleDeinitResult(path, status));
                        }
                    }
                    if (revWalk != null) {
                        revWalk.close();
                    }
                }
                catch (Throwable throwable) {
                    if (object == null) {
                        object = throwable;
                    } else if (object != throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                    if (revWalk != null) {
                        revWalk.close();
                    }
                    throw object;
                }
            }
            catch (Throwable throwable) {
                if (object == null) {
                    object = throwable;
                } else if (object != throwable) {
                    ((Throwable)object).addSuppressed(throwable);
                }
                throw object;
            }
            return results;
        }
        catch (IOException e) {
            throw new JGitInternalException(e.getMessage(), e);
        }
    }

    private void deinit(String path) throws IOException {
        File dir = new File(this.repo.getWorkTree(), path);
        if (!dir.isDirectory()) {
            throw new JGitInternalException(MessageFormat.format(JGitText.get().expectedDirectoryNotSubmodule, path));
        }
        File[] ls = dir.listFiles();
        if (ls != null) {
            int i = 0;
            while (i < ls.length) {
                FileUtils.delete(ls[i], 1);
                ++i;
            }
        }
    }

    /*
     * Exception decompiling
     */
    private SubmoduleDeinitStatus checkDirty(RevWalk revWalk, String path) throws GitAPIException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [9[TRYBLOCK]], but top level block is 10[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean submoduleExists(String path) throws IOException {
        PathFilter filter = PathFilter.create(path);
        Throwable throwable = null;
        Object var4_5 = null;
        try (SubmoduleWalk w = SubmoduleWalk.forIndex(this.repo);){
            return w.setFilter(filter).next();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public SubmoduleDeinitCommand addPath(String path) {
        this.paths.add(path);
        return this;
    }

    public SubmoduleDeinitCommand setForce(boolean force) {
        this.force = force;
        return this;
    }

    public static class NoSuchSubmoduleException
    extends GitAPIException {
        private static final long serialVersionUID = 1L;

        public NoSuchSubmoduleException(String path) {
            super(MessageFormat.format(JGitText.get().noSuchSubmodule, path));
        }
    }

    public static enum SubmoduleDeinitStatus {
        ALREADY_DEINITIALIZED,
        SUCCESS,
        FORCED,
        DIRTY;

    }
}

