/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheCheckout;
import org.eclipse.jgit.dircache.InvalidPathException;
import org.eclipse.jgit.errors.AmbiguousObjectException;
import org.eclipse.jgit.errors.CorruptObjectException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.errors.NoWorkTreeException;
import org.eclipse.jgit.errors.RevisionSyntaxException;
import org.eclipse.jgit.events.IndexChangedEvent;
import org.eclipse.jgit.events.IndexChangedListener;
import org.eclipse.jgit.events.ListenerList;
import org.eclipse.jgit.events.RepositoryEvent;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.storage.file.ObjectDirectory;
import org.eclipse.jgit.lib.AbbreviatedObjectId;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.BaseRepositoryBuilder;
import org.eclipse.jgit.lib.CheckoutEntry;
import org.eclipse.jgit.lib.ObjectDatabase;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.RebaseTodoFile;
import org.eclipse.jgit.lib.RebaseTodoLine;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefDatabase;
import org.eclipse.jgit.lib.RefRename;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.ReflogEntry;
import org.eclipse.jgit.lib.ReflogReader;
import org.eclipse.jgit.lib.RepositoryState;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.revwalk.RevBlob;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.FileUtils;
import org.eclipse.jgit.util.IO;
import org.eclipse.jgit.util.RawParseUtils;
import org.eclipse.jgit.util.io.SafeBufferedOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Repository {
    private static final ListenerList globalListeners = new ListenerList();
    private final AtomicInteger useCnt = new AtomicInteger(1);
    private final File gitDir;
    private final FS fs;
    private final ListenerList myListeners = new ListenerList();
    private final File workTree;
    private final File indexFile;

    public static ListenerList getGlobalListenerList() {
        return globalListeners;
    }

    protected Repository(BaseRepositoryBuilder options) {
        this.gitDir = options.getGitDir();
        this.fs = options.getFS();
        this.workTree = options.getWorkTree();
        this.indexFile = options.getIndexFile();
    }

    public ListenerList getListenerList() {
        return this.myListeners;
    }

    public void fireEvent(RepositoryEvent<?> event) {
        event.setRepository(this);
        this.myListeners.dispatch(event);
        globalListeners.dispatch(event);
    }

    public void create() throws IOException {
        this.create(false);
    }

    public abstract void create(boolean var1) throws IOException;

    public File getDirectory() {
        return this.gitDir;
    }

    public abstract ObjectDatabase getObjectDatabase();

    public ObjectInserter newObjectInserter() {
        return this.getObjectDatabase().newInserter();
    }

    public ObjectReader newObjectReader() {
        return this.getObjectDatabase().newReader();
    }

    public abstract RefDatabase getRefDatabase();

    public abstract StoredConfig getConfig();

    public FS getFS() {
        return this.fs;
    }

    public boolean hasObject(AnyObjectId objectId) {
        try {
            return this.getObjectDatabase().has(objectId);
        }
        catch (IOException e) {
            return false;
        }
    }

    public ObjectLoader open(AnyObjectId objectId) throws MissingObjectException, IOException {
        return this.getObjectDatabase().open(objectId);
    }

    public ObjectLoader open(AnyObjectId objectId, int typeHint) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        return this.getObjectDatabase().open(objectId, typeHint);
    }

    public RefUpdate updateRef(String ref) throws IOException {
        return this.updateRef(ref, false);
    }

    public RefUpdate updateRef(String ref, boolean detach) throws IOException {
        return this.getRefDatabase().newUpdate(ref, detach);
    }

    public RefRename renameRef(String fromRef, String toRef) throws IOException {
        return this.getRefDatabase().newRename(fromRef, toRef);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectId resolve(String revstr) throws AmbiguousObjectException, IncorrectObjectTypeException, RevisionSyntaxException, IOException {
        Object resolved;
        RevWalk rw;
        block3: {
            rw = new RevWalk(this);
            try {
                resolved = this.resolve(rw, revstr);
                if (!(resolved instanceof String)) break block3;
                Ref ref = this.getRef((String)resolved);
                ObjectId objectId = ref != null ? ref.getLeaf().getObjectId() : null;
                Object var7_7 = null;
                rw.release();
                return objectId;
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                rw.release();
                throw throwable;
            }
        }
        ObjectId objectId = (ObjectId)resolved;
        Object var7_8 = null;
        rw.release();
        return objectId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String simplify(String revstr) throws AmbiguousObjectException, IOException {
        RevWalk rw;
        block4: {
            Object resolved;
            block5: {
                rw = new RevWalk(this);
                try {
                    resolved = this.resolve(rw, revstr);
                    if (resolved == null) break block4;
                    if (!(resolved instanceof String)) break block5;
                    String string = (String)resolved;
                    Object var6_7 = null;
                    rw.release();
                    return string;
                }
                catch (Throwable throwable) {
                    Object var6_10 = null;
                    rw.release();
                    throw throwable;
                }
            }
            String string = ((AnyObjectId)resolved).getName();
            Object var6_8 = null;
            rw.release();
            return string;
        }
        String string = null;
        Object var6_9 = null;
        rw.release();
        return string;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object resolve(RevWalk rw, String revstr) throws IOException {
        void var4_5;
        char[] revChars = revstr.toCharArray();
        Object var4_4 = null;
        String name = null;
        int done = 0;
        block16: for (int i = 0; i < revChars.length; ++i) {
            switch (revChars[i]) {
                case '^': {
                    void var4_7;
                    if (var4_5 == null) {
                        if (name == null) {
                            if (done == 0) {
                                name = new String(revChars, done, i);
                            } else {
                                done = i + 1;
                                continue block16;
                            }
                        }
                        RevObject revObject = this.parseSimple(rw, name);
                        name = null;
                        if (revObject == null) {
                            return null;
                        }
                    }
                    if (i + 1 < revChars.length) {
                        switch (revChars[i + 1]) {
                            case '0': 
                            case '1': 
                            case '2': 
                            case '3': 
                            case '4': 
                            case '5': 
                            case '6': 
                            case '7': 
                            case '8': 
                            case '9': {
                                int pnum;
                                int j;
                                RevCommit revCommit = rw.parseCommit((AnyObjectId)var4_7);
                                for (j = i + 1; j < revChars.length && Character.isDigit(revChars[j]); ++j) {
                                }
                                String parentnum = new String(revChars, i + 1, j - i - 1);
                                try {
                                    pnum = Integer.parseInt(parentnum);
                                }
                                catch (NumberFormatException e) {
                                    throw new RevisionSyntaxException(JGitText.get().invalidCommitParentNumber, revstr);
                                }
                                if (pnum != 0) {
                                    RevCommit commit = revCommit;
                                    if (pnum > commit.getParentCount()) {
                                        Object var4_9 = null;
                                    } else {
                                        RevCommit revCommit2 = commit.getParent(pnum - 1);
                                    }
                                }
                                i = j - 1;
                                done = j;
                                break;
                            }
                            case '{': {
                                int k;
                                String item = null;
                                for (k = i + 2; k < revChars.length; ++k) {
                                    if (revChars[k] != '}') continue;
                                    item = new String(revChars, i + 2, k - i - 2);
                                    break;
                                }
                                i = k;
                                if (item == null) throw new RevisionSyntaxException(revstr);
                                if (item.equals("tree")) {
                                    RevTree revTree = rw.parseTree((AnyObjectId)var4_7);
                                } else if (item.equals("commit")) {
                                    RevCommit revCommit = rw.parseCommit((AnyObjectId)var4_7);
                                } else if (item.equals("blob")) {
                                    RevObject revObject = rw.peel((RevObject)var4_7);
                                    if (!(revObject instanceof RevBlob)) {
                                        throw new IncorrectObjectTypeException((ObjectId)revObject, "blob");
                                    }
                                } else {
                                    if (!item.equals("")) throw new RevisionSyntaxException(revstr);
                                    RevObject revObject = rw.peel((RevObject)var4_7);
                                }
                                done = k;
                                break;
                            }
                            default: {
                                RevObject revObject = rw.peel((RevObject)var4_7);
                                if (!(revObject instanceof RevCommit)) throw new IncorrectObjectTypeException((ObjectId)revObject, "commit");
                                RevCommit commit = (RevCommit)revObject;
                                if (commit.getParentCount() == 0) {
                                    Object var4_18 = null;
                                    break;
                                }
                                RevCommit revCommit = commit.getParent(0);
                                break;
                            }
                        }
                    } else {
                        RevObject revObject = rw.peel((RevObject)var4_7);
                        if (!(revObject instanceof RevCommit)) throw new IncorrectObjectTypeException((ObjectId)revObject, "commit");
                        RevCommit commit = (RevCommit)revObject;
                        if (commit.getParentCount() == 0) {
                            Object var4_23 = null;
                        } else {
                            RevCommit revCommit = commit.getParent(0);
                        }
                    }
                    done = i + 1;
                    continue block16;
                }
                case '~': {
                    int dist;
                    int l;
                    void var4_28;
                    RevObject revObject;
                    if (var4_5 == null) {
                        if (name == null) {
                            if (done == 0) {
                                name = new String(revChars, done, i);
                            } else {
                                done = i + 1;
                                continue block16;
                            }
                        }
                        RevObject revObject2 = this.parseSimple(rw, name);
                        name = null;
                        if (revObject2 == null) {
                            return null;
                        }
                    }
                    if (!((revObject = rw.peel((RevObject)var4_28)) instanceof RevCommit)) {
                        throw new IncorrectObjectTypeException((ObjectId)revObject, "commit");
                    }
                    for (l = i + 1; l < revChars.length && Character.isDigit(revChars[l]); ++l) {
                    }
                    if (l - i > 1) {
                        String distnum = new String(revChars, i + 1, l - i - 1);
                        try {
                            dist = Integer.parseInt(distnum);
                        }
                        catch (NumberFormatException e) {
                            throw new RevisionSyntaxException(JGitText.get().invalidAncestryLength, revstr);
                        }
                    } else {
                        dist = 1;
                    }
                    while (dist > 0) {
                        void var4_30;
                        RevCommit commit = (RevCommit)var4_30;
                        if (commit.getParentCount() == 0) {
                            Object var4_31 = null;
                            break;
                        }
                        commit = commit.getParent(0);
                        rw.parseHeaders(commit);
                        RevCommit revCommit = commit;
                        --dist;
                    }
                    i = l - 1;
                    done = l;
                    continue block16;
                }
                case '@': {
                    Ref ref;
                    int m;
                    if (var4_5 != null) {
                        throw new RevisionSyntaxException(revstr);
                    }
                    if (i + 1 < revChars.length && revChars[i + 1] != '{') continue block16;
                    String time = null;
                    for (m = i + 2; m < revChars.length; ++m) {
                        if (revChars[m] != '}') continue;
                        time = new String(revChars, i + 2, m - i - 2);
                        break;
                    }
                    if (time == null) throw new RevisionSyntaxException(revstr);
                    if (time.equals("upstream")) {
                        RemoteConfig remoteConfig;
                        if (name == null) {
                            name = new String(revChars, done, i);
                        }
                        if (name.equals("")) {
                            name = "HEAD";
                        }
                        if (!Repository.isValidRefName("x/" + name)) {
                            throw new RevisionSyntaxException(revstr);
                        }
                        ref = this.getRef(name);
                        name = null;
                        if (ref == null) {
                            return null;
                        }
                        if (ref.isSymbolic()) {
                            ref = ref.getLeaf();
                        }
                        name = ref.getName();
                        try {
                            remoteConfig = new RemoteConfig(this.getConfig(), "origin");
                        }
                        catch (URISyntaxException e) {
                            throw new RevisionSyntaxException(revstr);
                        }
                        String remoteBranchName = this.getConfig().getString("branch", Repository.shortenRefName(ref.getName()), "merge");
                        List<RefSpec> fetchRefSpecs = remoteConfig.getFetchRefSpecs();
                        for (RefSpec refSpec : fetchRefSpecs) {
                            if (!refSpec.matchSource(remoteBranchName)) continue;
                            RefSpec expandFromSource = refSpec.expandFromSource(remoteBranchName);
                            name = expandFromSource.getDestination();
                            break;
                        }
                        if (name == null) {
                            throw new RevisionSyntaxException(revstr);
                        }
                    } else if (time.matches("^-\\d+$")) {
                        if (name != null) {
                            throw new RevisionSyntaxException(revstr);
                        }
                        String previousCheckout = this.resolveReflogCheckout(-Integer.parseInt(time));
                        if (ObjectId.isId(previousCheckout)) {
                            RevObject revObject = this.parseSimple(rw, previousCheckout);
                        } else {
                            name = previousCheckout;
                        }
                    } else {
                        if (name == null) {
                            name = new String(revChars, done, i);
                        }
                        if (name.equals("")) {
                            name = "HEAD";
                        }
                        if (!Repository.isValidRefName("x/" + name)) {
                            throw new RevisionSyntaxException(revstr);
                        }
                        ref = this.getRef(name);
                        name = null;
                        if (ref == null) {
                            return null;
                        }
                        if (ref.isSymbolic()) {
                            ref = ref.getLeaf();
                        }
                        RevCommit revCommit = this.resolveReflog(rw, ref, time);
                    }
                    i = m;
                    continue block16;
                }
                case ':': {
                    void var4_37;
                    if (var4_5 == null) {
                        if (name == null) {
                            name = new String(revChars, done, i);
                        }
                        if (name.equals("")) {
                            name = "HEAD";
                        }
                        RevObject revObject = this.parseSimple(rw, name);
                        name = null;
                    }
                    if (var4_37 == null) {
                        return null;
                    }
                    RevTree tree = rw.parseTree((AnyObjectId)var4_37);
                    if (i == revChars.length - 1) {
                        return tree.copy();
                    }
                    TreeWalk tw = TreeWalk.forPath(rw.getObjectReader(), new String(revChars, i + 1, revChars.length - i - 1), tree);
                    if (tw == null) return null;
                    ObjectId objectId = tw.getObjectId(0);
                    return objectId;
                }
                default: {
                    if (var4_5 == null) continue block16;
                    throw new RevisionSyntaxException(revstr);
                }
            }
        }
        if (var4_5 != null) {
            return var4_5.copy();
        }
        if (name != null) {
            return name;
        }
        if (done == revstr.length()) {
            return null;
        }
        name = revstr.substring(done);
        if (!Repository.isValidRefName("x/" + name)) {
            throw new RevisionSyntaxException(revstr);
        }
        if (this.getRef(name) == null) return this.resolveSimple(name);
        return name;
    }

    private static boolean isHex(char c) {
        return '0' <= c && c <= '9' || 'a' <= c && c <= 'f' || 'A' <= c && c <= 'F';
    }

    private static boolean isAllHex(String str, int ptr) {
        while (ptr < str.length()) {
            if (Repository.isHex(str.charAt(ptr++))) continue;
            return false;
        }
        return true;
    }

    private RevObject parseSimple(RevWalk rw, String revstr) throws IOException {
        ObjectId id = this.resolveSimple(revstr);
        return id != null ? rw.parseAny(id) : null;
    }

    private ObjectId resolveSimple(String revstr) throws IOException {
        String s;
        Ref r;
        if (ObjectId.isId(revstr)) {
            return ObjectId.fromString(revstr);
        }
        if (Repository.isValidRefName("x/" + revstr) && (r = this.getRefDatabase().getRef(revstr)) != null) {
            return r.getObjectId();
        }
        if (AbbreviatedObjectId.isId(revstr)) {
            return this.resolveAbbreviation(revstr);
        }
        int dashg = revstr.indexOf("-g");
        if (dashg + 5 < revstr.length() && 0 <= dashg && Repository.isHex(revstr.charAt(dashg + 2)) && Repository.isHex(revstr.charAt(dashg + 3)) && Repository.isAllHex(revstr, dashg + 4) && AbbreviatedObjectId.isId(s = revstr.substring(dashg + 2))) {
            return this.resolveAbbreviation(s);
        }
        return null;
    }

    private String resolveReflogCheckout(int checkoutNo) throws IOException {
        List<ReflogEntry> reflogEntries = this.getReflogReader("HEAD").getReverseEntries();
        for (ReflogEntry entry : reflogEntries) {
            CheckoutEntry checkout = entry.parseCheckout();
            if (checkout == null || checkoutNo-- != 1) continue;
            return checkout.getFromBranch();
        }
        return null;
    }

    private RevCommit resolveReflog(RevWalk rw, Ref ref, String time) throws IOException {
        int number;
        try {
            number = Integer.parseInt(time);
        }
        catch (NumberFormatException nfe) {
            throw new RevisionSyntaxException(MessageFormat.format(JGitText.get().invalidReflogRevision, time));
        }
        assert (number >= 0);
        ReflogReader reader = this.getReflogReader(ref.getName());
        ReflogEntry entry = reader.getReverseEntry(number);
        if (entry == null) {
            throw new RevisionSyntaxException(MessageFormat.format(JGitText.get().reflogEntryNotFound, number, ref.getName()));
        }
        return rw.parseCommit(entry.getNewId());
    }

    private ObjectId resolveAbbreviation(String revstr) throws IOException, AmbiguousObjectException {
        Collection<ObjectId> matches;
        AbbreviatedObjectId id;
        block5: {
            ObjectReader reader;
            block4: {
                id = AbbreviatedObjectId.fromString(revstr);
                reader = this.newObjectReader();
                try {
                    matches = reader.resolve(id);
                    if (matches.size() != 0) break block4;
                    ObjectId objectId = null;
                    Object var7_7 = null;
                    reader.release();
                    return objectId;
                }
                catch (Throwable throwable) {
                    Object var7_9 = null;
                    reader.release();
                    throw throwable;
                }
            }
            if (matches.size() != 1) break block5;
            ObjectId objectId = matches.iterator().next();
            Object var7_8 = null;
            reader.release();
            return objectId;
        }
        throw new AmbiguousObjectException(id, matches);
    }

    public void incrementOpen() {
        this.useCnt.incrementAndGet();
    }

    public void close() {
        if (this.useCnt.decrementAndGet() == 0) {
            this.doClose();
        }
    }

    protected void doClose() {
        this.getObjectDatabase().close();
        this.getRefDatabase().close();
    }

    public String toString() {
        String desc = this.getDirectory() != null ? this.getDirectory().getPath() : this.getClass().getSimpleName() + "-" + System.identityHashCode(this);
        return "Repository[" + desc + "]";
    }

    public String getFullBranch() throws IOException {
        Ref head = this.getRef("HEAD");
        if (head == null) {
            return null;
        }
        if (head.isSymbolic()) {
            return head.getTarget().getName();
        }
        if (head.getObjectId() != null) {
            return head.getObjectId().name();
        }
        return null;
    }

    public String getBranch() throws IOException {
        String name = this.getFullBranch();
        if (name != null) {
            return Repository.shortenRefName(name);
        }
        return name;
    }

    public Set<ObjectId> getAdditionalHaves() {
        return Collections.emptySet();
    }

    public Ref getRef(String name) throws IOException {
        return this.getRefDatabase().getRef(name);
    }

    public Map<String, Ref> getAllRefs() {
        try {
            return this.getRefDatabase().getRefs("");
        }
        catch (IOException e) {
            return new HashMap<String, Ref>();
        }
    }

    public Map<String, Ref> getTags() {
        try {
            return this.getRefDatabase().getRefs("refs/tags/");
        }
        catch (IOException e) {
            return new HashMap<String, Ref>();
        }
    }

    public Set<ObjectId> getShallows() {
        ObjectDatabase objectDatabase = this.getObjectDatabase();
        if (objectDatabase instanceof ObjectDirectory) {
            try {
                return ((ObjectDirectory)objectDatabase).getShallowCommits();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return Collections.emptySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeShallows(Set<ObjectId> unshallows) {
        if (unshallows.isEmpty()) {
            return;
        }
        HashSet<ObjectId> shallowChangesets = new HashSet<ObjectId>(this.getShallows());
        shallowChangesets.removeAll(unshallows);
        File shallowFile = this.getFS().resolve(this.getDirectory(), "shallow");
        try {
            FileWriter fw = new FileWriter(shallowFile);
            try {
                for (ObjectId shallow : shallowChangesets) {
                    fw.write(shallow.name() + "\n");
                }
                Object var8_8 = null;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                fw.close();
                throw throwable;
            }
            fw.close();
            {
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addShallows(Set<ObjectId> newShallows) {
        if (newShallows.isEmpty()) {
            return;
        }
        HashSet<ObjectId> shallowChangesets = new HashSet<ObjectId>(this.getShallows());
        File shallowFile = this.getFS().resolve(this.getDirectory(), "shallow");
        try {
            FileWriter fw = new FileWriter(shallowFile, true);
            try {
                for (ObjectId shallow : newShallows) {
                    if (shallowChangesets.contains(shallow)) continue;
                    fw.write(shallow.name() + "\n");
                    shallowChangesets.add(shallow);
                }
                Object var8_8 = null;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                fw.close();
                throw throwable;
            }
            fw.close();
            {
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Ref peel(Ref ref) {
        try {
            return this.getRefDatabase().peel(ref);
        }
        catch (IOException e) {
            return ref;
        }
    }

    public Map<AnyObjectId, Set<Ref>> getAllRefsByPeeledObjectId() {
        Map<String, Ref> allRefs = this.getAllRefs();
        HashMap<AnyObjectId, Set<Ref>> ret = new HashMap<AnyObjectId, Set<Ref>>(allRefs.size());
        for (Ref ref : allRefs.values()) {
            Set<Ref> oset;
            ObjectId target = (ref = this.peel(ref)).getPeeledObjectId();
            if (target == null) {
                target = ref.getObjectId();
            }
            if ((oset = ret.put(target, Collections.singleton(ref))) == null) continue;
            if (oset.size() == 1) {
                oset = new HashSet<Ref>(oset);
            }
            ret.put(target, oset);
            oset.add(ref);
        }
        return ret;
    }

    public File getIndexFile() throws NoWorkTreeException {
        if (this.isBare()) {
            throw new NoWorkTreeException();
        }
        return this.indexFile;
    }

    public DirCache readDirCache() throws NoWorkTreeException, CorruptObjectException, IOException {
        return DirCache.read(this);
    }

    public DirCache lockDirCache() throws NoWorkTreeException, CorruptObjectException, IOException {
        IndexChangedListener l = new IndexChangedListener(){

            public void onIndexChanged(IndexChangedEvent event) {
                Repository.this.notifyIndexChanged();
            }
        };
        return DirCache.lock(this, l);
    }

    static byte[] gitInternalSlash(byte[] bytes) {
        if (File.separatorChar == '/') {
            return bytes;
        }
        for (int i = 0; i < bytes.length; ++i) {
            if (bytes[i] != File.separatorChar) continue;
            bytes[i] = 47;
        }
        return bytes;
    }

    public RepositoryState getRepositoryState() {
        if (this.isBare() || this.getDirectory() == null) {
            return RepositoryState.BARE;
        }
        if (new File(this.getWorkTree(), ".dotest").exists()) {
            return RepositoryState.REBASING;
        }
        if (new File(this.getDirectory(), ".dotest-merge").exists()) {
            return RepositoryState.REBASING_INTERACTIVE;
        }
        if (new File(this.getDirectory(), "rebase-apply/rebasing").exists()) {
            return RepositoryState.REBASING_REBASING;
        }
        if (new File(this.getDirectory(), "rebase-apply/applying").exists()) {
            return RepositoryState.APPLY;
        }
        if (new File(this.getDirectory(), "rebase-apply").exists()) {
            return RepositoryState.REBASING;
        }
        if (new File(this.getDirectory(), "rebase-merge/interactive").exists()) {
            return RepositoryState.REBASING_INTERACTIVE;
        }
        if (new File(this.getDirectory(), "rebase-merge").exists()) {
            return RepositoryState.REBASING_MERGE;
        }
        if (new File(this.getDirectory(), "MERGE_HEAD").exists()) {
            try {
                if (!this.readDirCache().hasUnmergedPaths()) {
                    return RepositoryState.MERGING_RESOLVED;
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            return RepositoryState.MERGING;
        }
        if (new File(this.getDirectory(), "BISECT_LOG").exists()) {
            return RepositoryState.BISECTING;
        }
        if (new File(this.getDirectory(), "CHERRY_PICK_HEAD").exists()) {
            try {
                if (!this.readDirCache().hasUnmergedPaths()) {
                    return RepositoryState.CHERRY_PICKING_RESOLVED;
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            return RepositoryState.CHERRY_PICKING;
        }
        if (new File(this.getDirectory(), "REVERT_HEAD").exists()) {
            try {
                if (!this.readDirCache().hasUnmergedPaths()) {
                    return RepositoryState.REVERTING_RESOLVED;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return RepositoryState.REVERTING;
        }
        return RepositoryState.SAFE;
    }

    public static boolean isValidRefName(String refName) {
        int len = refName.length();
        if (len == 0) {
            return false;
        }
        if (refName.endsWith(".lock")) {
            return false;
        }
        try {
            DirCacheCheckout.checkValidPath(refName);
        }
        catch (InvalidPathException e) {
            return false;
        }
        int components = 1;
        int p = 0;
        for (int i = 0; i < len; ++i) {
            char c = refName.charAt(i);
            if (c <= ' ') {
                return false;
            }
            switch (c) {
                case '.': {
                    switch (p) {
                        case 0: 
                        case 46: 
                        case 47: {
                            return false;
                        }
                    }
                    if (i != len - 1) break;
                    return false;
                }
                case '/': {
                    if (i == 0 || i == len - 1) {
                        return false;
                    }
                    if (p == 47) {
                        return false;
                    }
                    ++components;
                    break;
                }
                case '{': {
                    if (p != 64) break;
                    return false;
                }
                case '*': 
                case ':': 
                case '?': 
                case '[': 
                case '\\': 
                case '^': 
                case '~': 
                case '\u007f': {
                    return false;
                }
            }
            p = c;
        }
        return components > 1;
    }

    public static String stripWorkDir(File workDir, File file) {
        String filePath = file.getPath();
        String workDirPath = workDir.getPath();
        if (filePath.length() <= workDirPath.length() || filePath.charAt(workDirPath.length()) != File.separatorChar || !filePath.startsWith(workDirPath)) {
            File absFile;
            File absWd = workDir.isAbsolute() ? workDir : workDir.getAbsoluteFile();
            File file2 = absFile = file.isAbsolute() ? file : file.getAbsoluteFile();
            if (absWd == workDir && absFile == file) {
                return "";
            }
            return Repository.stripWorkDir(absWd, absFile);
        }
        String relName = filePath.substring(workDirPath.length() + 1);
        if (File.separatorChar != '/') {
            relName = relName.replace(File.separatorChar, '/');
        }
        return relName;
    }

    public boolean isBare() {
        return this.workTree == null;
    }

    public File getWorkTree() throws NoWorkTreeException {
        if (this.isBare()) {
            throw new NoWorkTreeException();
        }
        return this.workTree;
    }

    public abstract void scanForRepoChanges() throws IOException;

    public abstract void notifyIndexChanged();

    public static String shortenRefName(String refName) {
        if (refName.startsWith("refs/heads/")) {
            return refName.substring("refs/heads/".length());
        }
        if (refName.startsWith("refs/tags/")) {
            return refName.substring("refs/tags/".length());
        }
        if (refName.startsWith("refs/remotes/")) {
            return refName.substring("refs/remotes/".length());
        }
        return refName;
    }

    public String shortenRemoteBranchName(String refName) {
        for (String remote : this.getRemoteNames()) {
            String remotePrefix = "refs/remotes/" + remote + "/";
            if (!refName.startsWith(remotePrefix)) continue;
            return refName.substring(remotePrefix.length());
        }
        return null;
    }

    public String getRemoteName(String refName) {
        for (String remote : this.getRemoteNames()) {
            String remotePrefix = "refs/remotes/" + remote + "/";
            if (!refName.startsWith(remotePrefix)) continue;
            return remote;
        }
        return null;
    }

    public abstract ReflogReader getReflogReader(String var1) throws IOException;

    public String readMergeCommitMsg() throws IOException, NoWorkTreeException {
        return this.readCommitMsgFile("MERGE_MSG");
    }

    public void writeMergeCommitMsg(String msg) throws IOException {
        File mergeMsgFile = new File(this.gitDir, "MERGE_MSG");
        this.writeCommitMsg(mergeMsgFile, msg);
    }

    public List<ObjectId> readMergeHeads() throws IOException, NoWorkTreeException {
        if (this.isBare() || this.getDirectory() == null) {
            throw new NoWorkTreeException();
        }
        byte[] raw = this.readGitDirectoryFile("MERGE_HEAD");
        if (raw == null) {
            return null;
        }
        LinkedList<ObjectId> heads = new LinkedList<ObjectId>();
        int p = 0;
        while (p < raw.length) {
            heads.add(ObjectId.fromString(raw, p));
            p = RawParseUtils.nextLF(raw, p + 40);
        }
        return heads;
    }

    public void writeMergeHeads(List<? extends ObjectId> heads) throws IOException {
        this.writeHeadsFile(heads, "MERGE_HEAD");
    }

    public ObjectId readCherryPickHead() throws IOException, NoWorkTreeException {
        if (this.isBare() || this.getDirectory() == null) {
            throw new NoWorkTreeException();
        }
        byte[] raw = this.readGitDirectoryFile("CHERRY_PICK_HEAD");
        if (raw == null) {
            return null;
        }
        return ObjectId.fromString(raw, 0);
    }

    public ObjectId readRevertHead() throws IOException, NoWorkTreeException {
        if (this.isBare() || this.getDirectory() == null) {
            throw new NoWorkTreeException();
        }
        byte[] raw = this.readGitDirectoryFile("REVERT_HEAD");
        if (raw == null) {
            return null;
        }
        return ObjectId.fromString(raw, 0);
    }

    public void writeCherryPickHead(ObjectId head) throws IOException {
        List<ObjectId> heads = head != null ? Collections.singletonList(head) : null;
        this.writeHeadsFile(heads, "CHERRY_PICK_HEAD");
    }

    public void writeRevertHead(ObjectId head) throws IOException {
        List<ObjectId> heads = head != null ? Collections.singletonList(head) : null;
        this.writeHeadsFile(heads, "REVERT_HEAD");
    }

    public void writeOrigHead(ObjectId head) throws IOException {
        List<ObjectId> heads = head != null ? Collections.singletonList(head) : null;
        this.writeHeadsFile(heads, "ORIG_HEAD");
    }

    public ObjectId readOrigHead() throws IOException, NoWorkTreeException {
        if (this.isBare() || this.getDirectory() == null) {
            throw new NoWorkTreeException();
        }
        byte[] raw = this.readGitDirectoryFile("ORIG_HEAD");
        return raw != null ? ObjectId.fromString(raw, 0) : null;
    }

    public String readSquashCommitMsg() throws IOException {
        return this.readCommitMsgFile("SQUASH_MSG");
    }

    public void writeSquashCommitMsg(String msg) throws IOException {
        File squashMsgFile = new File(this.gitDir, "SQUASH_MSG");
        this.writeCommitMsg(squashMsgFile, msg);
    }

    private String readCommitMsgFile(String msgFilename) throws IOException {
        if (this.isBare() || this.getDirectory() == null) {
            throw new NoWorkTreeException();
        }
        File mergeMsgFile = new File(this.getDirectory(), msgFilename);
        try {
            return RawParseUtils.decode(IO.readFully(mergeMsgFile));
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeCommitMsg(File msgFile, String msg) throws IOException {
        block3: {
            if (msg != null) {
                FileOutputStream fos = new FileOutputStream(msgFile);
                try {
                    fos.write(msg.getBytes("UTF-8"));
                    Object var5_4 = null;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    fos.close();
                    throw throwable;
                }
                fos.close();
                {
                    break block3;
                }
            }
            FileUtils.delete(msgFile, 4);
        }
    }

    private byte[] readGitDirectoryFile(String filename) throws IOException {
        File file = new File(this.getDirectory(), filename);
        try {
            byte[] raw = IO.readFully(file);
            return (byte[])(raw.length > 0 ? raw : null);
        }
        catch (FileNotFoundException notFound) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeHeadsFile(List<? extends ObjectId> heads, String filename) throws FileNotFoundException, IOException {
        block4: {
            File headsFile = new File(this.getDirectory(), filename);
            if (heads != null) {
                SafeBufferedOutputStream bos = new SafeBufferedOutputStream(new FileOutputStream(headsFile));
                try {
                    for (ObjectId objectId : heads) {
                        objectId.copyTo(bos);
                        bos.write(10);
                    }
                    Object var8_7 = null;
                }
                catch (Throwable throwable) {
                    Object var8_8 = null;
                    ((FilterOutputStream)bos).close();
                    throw throwable;
                }
                ((FilterOutputStream)bos).close();
                {
                    break block4;
                }
            }
            FileUtils.delete(headsFile, 4);
        }
    }

    public List<RebaseTodoLine> readRebaseTodo(String path, boolean includeComments) throws IOException {
        return new RebaseTodoFile(this).readRebaseTodo(path, includeComments);
    }

    public void writeRebaseTodoFile(String path, List<RebaseTodoLine> steps, boolean append) throws IOException {
        new RebaseTodoFile(this).writeRebaseTodoFile(path, steps, append);
    }

    public Set<String> getRemoteNames() {
        return this.getConfig().getSubsections("remote");
    }
}

