/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.jgit.errors.TransportException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.storage.pack.PackWriter;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectIdRef;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefWriter;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.BaseConnection;
import org.eclipse.jgit.transport.PushConnection;
import org.eclipse.jgit.transport.RemoteRefUpdate;
import org.eclipse.jgit.transport.Transport;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.transport.WalkRemoteObjectDatabase;
import org.eclipse.jgit.transport.WalkTransport;
import org.eclipse.jgit.util.io.SafeBufferedOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class WalkPushConnection
extends BaseConnection
implements PushConnection {
    private final Repository local;
    private final URIish uri;
    private final WalkRemoteObjectDatabase dest;
    private final Transport transport;
    private LinkedHashMap<String, String> packNames;
    private Map<String, Ref> newRefs;
    private Collection<RemoteRefUpdate> packedRefUpdates;

    WalkPushConnection(WalkTransport walkTransport, WalkRemoteObjectDatabase w) {
        this.transport = (Transport)((Object)walkTransport);
        this.local = this.transport.local;
        this.uri = this.transport.getURI();
        this.dest = w;
    }

    @Override
    public void push(ProgressMonitor monitor, Map<String, RemoteRefUpdate> refUpdates) throws TransportException {
        this.push(monitor, refUpdates, null);
    }

    @Override
    public void push(ProgressMonitor monitor, Map<String, RemoteRefUpdate> refUpdates, OutputStream out) throws TransportException {
        this.markStartedOperation();
        this.packNames = null;
        this.newRefs = new TreeMap<String, Ref>(this.getRefsMap());
        this.packedRefUpdates = new ArrayList<RemoteRefUpdate>(refUpdates.size());
        ArrayList<RemoteRefUpdate> updates = new ArrayList<RemoteRefUpdate>();
        for (RemoteRefUpdate remoteRefUpdate : refUpdates.values()) {
            String n = remoteRefUpdate.getRemoteName();
            if (!n.startsWith("refs/") || !Repository.isValidRefName(n)) {
                remoteRefUpdate.setStatus(RemoteRefUpdate.Status.REJECTED_OTHER_REASON);
                remoteRefUpdate.setMessage(JGitText.get().funnyRefname);
                continue;
            }
            if (AnyObjectId.equals(ObjectId.zeroId(), remoteRefUpdate.getNewObjectId())) {
                this.deleteCommand(remoteRefUpdate);
                continue;
            }
            updates.add(remoteRefUpdate);
        }
        if (!updates.isEmpty()) {
            this.sendpack(updates, monitor);
        }
        for (RemoteRefUpdate remoteRefUpdate : updates) {
            this.updateCommand(remoteRefUpdate);
        }
        if (!updates.isEmpty() && this.isNewRepository()) {
            this.createNewRepository(updates);
        }
        RefWriter refWriter = new RefWriter(this.newRefs.values()){

            protected void writeFile(String file, byte[] content) throws IOException {
                WalkPushConnection.this.dest.writeFile("../" + file, content);
            }
        };
        if (!this.packedRefUpdates.isEmpty()) {
            try {
                refWriter.writePackedRefs();
                for (RemoteRefUpdate u : this.packedRefUpdates) {
                    u.setStatus(RemoteRefUpdate.Status.OK);
                }
            }
            catch (IOException iOException) {
                for (RemoteRefUpdate u : this.packedRefUpdates) {
                    u.setStatus(RemoteRefUpdate.Status.REJECTED_OTHER_REASON);
                    u.setMessage(iOException.getMessage());
                }
                throw new TransportException(this.uri, JGitText.get().failedUpdatingRefs, iOException);
            }
        }
        try {
            refWriter.writeInfoRefs();
        }
        catch (IOException iOException) {
            throw new TransportException(this.uri, JGitText.get().failedUpdatingRefs, iOException);
        }
    }

    @Override
    public void close() {
        this.dest.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendpack(List<RemoteRefUpdate> updates, ProgressMonitor monitor) throws TransportException {
        String pathPack = null;
        String pathIdx = null;
        PackWriter writer = new PackWriter(this.transport.getPackConfig(), this.local.newObjectReader());
        try {
            try {
                HashSet<ObjectId> need = new HashSet<ObjectId>();
                HashSet<ObjectId> have = new HashSet<ObjectId>();
                for (RemoteRefUpdate remoteRefUpdate : updates) {
                    need.add(remoteRefUpdate.getNewObjectId());
                }
                for (Ref ref : this.getRefs()) {
                    have.add(ref.getObjectId());
                    if (ref.getPeeledObjectId() == null) continue;
                    have.add(ref.getPeeledObjectId());
                }
                writer.preparePack(monitor, (Set<? extends ObjectId>)need, (Set<? extends ObjectId>)have);
                if (writer.getObjectCount() == 0L) {
                    Object var17_16 = null;
                    writer.release();
                    return;
                }
                this.packNames = new LinkedHashMap();
                for (String string : this.dest.getPackNames()) {
                    this.packNames.put(string, string);
                }
                String base = "pack-" + writer.computeName().name();
                String string = base + ".pack";
                pathPack = "pack/" + string;
                pathIdx = "pack/" + base + ".idx";
                if (this.packNames.remove(string) != null) {
                    this.dest.writeInfoPacks(this.packNames.keySet());
                    this.dest.deleteFile(pathIdx);
                }
                String wt = "Put " + base.substring(0, 12);
                OutputStream os = this.dest.writeFile(pathPack, monitor, wt + "..pack");
                try {
                    os = new SafeBufferedOutputStream(os);
                    writer.writePack(monitor, monitor, os);
                    Object var13_21 = null;
                }
                catch (Throwable throwable) {
                    Object var13_22 = null;
                    os.close();
                    throw throwable;
                }
                os.close();
                os = this.dest.writeFile(pathIdx, monitor, wt + "..idx");
                try {
                    os = new SafeBufferedOutputStream(os);
                    writer.writeIndex(os);
                    Object var15_25 = null;
                }
                catch (Throwable throwable) {
                    Object var15_26 = null;
                    os.close();
                    throw throwable;
                }
                os.close();
                ArrayList<String> infoPacks = new ArrayList<String>();
                infoPacks.add(string);
                infoPacks.addAll(this.packNames.keySet());
                this.dest.writeInfoPacks(infoPacks);
            }
            catch (IOException err) {
                this.safeDelete(pathIdx);
                this.safeDelete(pathPack);
                throw new TransportException(this.uri, JGitText.get().cannotStoreObjects, err);
            }
        }
        catch (Throwable throwable) {
            Object var17_18 = null;
            writer.release();
            throw throwable;
        }
        Object var17_17 = null;
        writer.release();
    }

    private void safeDelete(String path) {
        if (path != null) {
            try {
                this.dest.deleteFile(path);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void deleteCommand(RemoteRefUpdate u) {
        Ref r = this.newRefs.remove(u.getRemoteName());
        if (r == null) {
            u.setStatus(RemoteRefUpdate.Status.OK);
            return;
        }
        if (r.getStorage().isPacked()) {
            this.packedRefUpdates.add(u);
        }
        if (r.getStorage().isLoose()) {
            try {
                this.dest.deleteRef(u.getRemoteName());
                u.setStatus(RemoteRefUpdate.Status.OK);
            }
            catch (IOException e) {
                u.setStatus(RemoteRefUpdate.Status.REJECTED_OTHER_REASON);
                u.setMessage(e.getMessage());
            }
        }
        try {
            this.dest.deleteRefLog(u.getRemoteName());
        }
        catch (IOException e) {
            u.setStatus(RemoteRefUpdate.Status.REJECTED_OTHER_REASON);
            u.setMessage(e.getMessage());
        }
    }

    private void updateCommand(RemoteRefUpdate u) {
        try {
            this.dest.writeRef(u.getRemoteName(), u.getNewObjectId());
            this.newRefs.put(u.getRemoteName(), new ObjectIdRef.Unpeeled(Ref.Storage.LOOSE, u.getRemoteName(), u.getNewObjectId()));
            u.setStatus(RemoteRefUpdate.Status.OK);
        }
        catch (IOException e) {
            u.setStatus(RemoteRefUpdate.Status.REJECTED_OTHER_REASON);
            u.setMessage(e.getMessage());
        }
    }

    private boolean isNewRepository() {
        return this.getRefsMap().isEmpty() && this.packNames != null && this.packNames.isEmpty();
    }

    private void createNewRepository(List<RemoteRefUpdate> updates) throws TransportException {
        byte[] bytes;
        try {
            String ref = "ref: " + WalkPushConnection.pickHEAD(updates) + "\n";
            bytes = Constants.encode(ref);
            this.dest.writeFile("../HEAD", bytes);
        }
        catch (IOException e) {
            throw new TransportException(this.uri, JGitText.get().cannotCreateHEAD, e);
        }
        try {
            String config = "[core]\n\trepositoryformatversion = 0\n";
            bytes = Constants.encode("[core]\n\trepositoryformatversion = 0\n");
            this.dest.writeFile("../config", bytes);
        }
        catch (IOException e) {
            throw new TransportException(this.uri, JGitText.get().cannotCreateConfig, e);
        }
    }

    private static String pickHEAD(List<RemoteRefUpdate> updates) {
        String n;
        for (RemoteRefUpdate u : updates) {
            n = u.getRemoteName();
            if (!n.equals("refs/heads/master")) continue;
            return n;
        }
        for (RemoteRefUpdate u : updates) {
            n = u.getRemoteName();
            if (!n.startsWith("refs/heads/")) continue;
            return n;
        }
        return updates.get(0).getRemoteName();
    }
}

