/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import org.eclipse.jgit.errors.TransportException;
import org.eclipse.jgit.transport.RemoteSession;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.util.io.StreamCopyThread;

public class JschSession
implements RemoteSession {
    private final Session sock;
    private final URIish uri;

    public JschSession(Session session, URIish uri) {
        this.sock = session;
        this.uri = uri;
    }

    public Process exec(String command, int timeout) throws IOException {
        return new JschProcess(command, timeout);
    }

    public void disconnect() {
        if (this.sock.isConnected()) {
            this.sock.disconnect();
        }
    }

    public Channel getSftpChannel() throws JSchException {
        return this.sock.openChannel("sftp");
    }

    private class JschProcess
    extends Process {
        private ChannelExec channel;
        private final int timeout;
        private InputStream inputStream;
        private OutputStream outputStream;
        private InputStream errStream;

        private JschProcess(String commandName, int tms) throws TransportException, IOException {
            this.timeout = tms;
            try {
                this.channel = (ChannelExec)JschSession.this.sock.openChannel("exec");
                this.channel.setCommand(commandName);
                this.setupStreams();
                this.channel.connect(this.timeout > 0 ? this.timeout * 1000 : 0);
                if (!this.channel.isConnected()) {
                    this.closeOutputStream();
                    throw new TransportException(JschSession.this.uri, "connection failed");
                }
            }
            catch (JSchException e) {
                this.closeOutputStream();
                throw new TransportException(JschSession.this.uri, e.getMessage(), e);
            }
        }

        private void closeOutputStream() {
            if (this.outputStream != null) {
                try {
                    this.outputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        private void setupStreams() throws IOException {
            this.inputStream = this.channel.getInputStream();
            OutputStream out = this.channel.getOutputStream();
            if (this.timeout <= 0) {
                this.outputStream = out;
            } else {
                PipedInputStream pipeIn = new PipedInputStream();
                final StreamCopyThread copier = new StreamCopyThread(pipeIn, out);
                PipedOutputStream pipeOut = new PipedOutputStream(pipeIn){

                    public void flush() throws IOException {
                        super.flush();
                        copier.flush();
                    }

                    public void close() throws IOException {
                        super.close();
                        try {
                            copier.join(JschProcess.this.timeout * 1000);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                };
                copier.start();
                this.outputStream = pipeOut;
            }
            this.errStream = this.channel.getErrStream();
        }

        public InputStream getInputStream() {
            return this.inputStream;
        }

        public OutputStream getOutputStream() {
            return this.outputStream;
        }

        public InputStream getErrorStream() {
            return this.errStream;
        }

        public int exitValue() {
            if (this.isRunning()) {
                throw new IllegalStateException();
            }
            return this.channel.getExitStatus();
        }

        private boolean isRunning() {
            return this.channel.getExitStatus() < 0 && this.channel.isConnected();
        }

        public void destroy() {
            if (this.channel.isConnected()) {
                this.channel.disconnect();
            }
        }

        public int waitFor() throws InterruptedException {
            while (this.isRunning()) {
                Thread.sleep(100L);
            }
            return this.exitValue();
        }
    }
}

