/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.io.IOException;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jgit.errors.NoRemoteRepositoryException;
import org.eclipse.jgit.errors.NotSupportedException;
import org.eclipse.jgit.errors.PackProtocolException;
import org.eclipse.jgit.errors.TransportException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.storage.pack.PackWriter;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.transport.BasePackConnection;
import org.eclipse.jgit.transport.PackTransport;
import org.eclipse.jgit.transport.PacketLineIn;
import org.eclipse.jgit.transport.PushConnection;
import org.eclipse.jgit.transport.RemoteRefUpdate;
import org.eclipse.jgit.transport.SideBandInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BasePackPushConnection
extends BasePackConnection
implements PushConnection {
    public static final String CAPABILITY_REPORT_STATUS = "report-status";
    public static final String CAPABILITY_DELETE_REFS = "delete-refs";
    public static final String CAPABILITY_OFS_DELTA = "ofs-delta";
    public static final String CAPABILITY_SIDE_BAND_64K = "side-band-64k";
    private final boolean thinPack;
    private boolean capableDeleteRefs;
    private boolean capableReport;
    private boolean capableSideBand;
    private boolean capableOfsDelta;
    private boolean sentCommand;
    private boolean writePack;
    private long packTransferTime;

    public BasePackPushConnection(PackTransport packTransport) {
        super(packTransport);
        this.thinPack = this.transport.isPushThin();
    }

    @Override
    public void push(ProgressMonitor monitor, Map<String, RemoteRefUpdate> refUpdates) throws TransportException {
        this.push(monitor, refUpdates, null);
    }

    @Override
    public void push(ProgressMonitor monitor, Map<String, RemoteRefUpdate> refUpdates, OutputStream outputStream) throws TransportException {
        this.markStartedOperation();
        this.doPush(monitor, refUpdates, outputStream);
    }

    @Override
    protected TransportException noRepository() {
        try {
            this.transport.openFetch().close();
        }
        catch (NotSupportedException notSupportedException) {
        }
        catch (NoRemoteRepositoryException e) {
            return e;
        }
        catch (TransportException transportException) {
            // empty catch block
        }
        return new TransportException(this.uri, JGitText.get().pushNotPermitted);
    }

    protected void doPush(ProgressMonitor monitor, Map<String, RemoteRefUpdate> refUpdates, OutputStream outputStream) throws TransportException {
        try {
            this.writeCommands(refUpdates.values(), monitor, outputStream);
            if (this.writePack) {
                this.writePack(refUpdates, monitor);
            }
            if (this.sentCommand) {
                int b;
                if (this.capableReport) {
                    this.readStatusReport(refUpdates);
                }
                if (this.capableSideBand && 0 <= (b = this.in.read())) {
                    throw new TransportException(this.uri, MessageFormat.format(JGitText.get().expectedEOFReceived, Character.valueOf((char)b)));
                }
            }
        }
        catch (TransportException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TransportException(this.uri, e.getMessage(), e);
        }
        finally {
            this.close();
        }
    }

    private void writeCommands(Collection<RemoteRefUpdate> refUpdates, ProgressMonitor monitor, OutputStream outputStream) throws IOException {
        String capabilities = this.enableCapabilities(monitor, outputStream);
        for (RemoteRefUpdate rru : refUpdates) {
            if (!this.capableDeleteRefs && rru.isDelete()) {
                rru.setStatus(RemoteRefUpdate.Status.REJECTED_NODELETE);
                continue;
            }
            StringBuilder sb = new StringBuilder();
            Ref advertisedRef = this.getRef(rru.getRemoteName());
            ObjectId oldId = advertisedRef == null ? ObjectId.zeroId() : advertisedRef.getObjectId();
            sb.append(oldId.name());
            sb.append(' ');
            sb.append(rru.getNewObjectId().name());
            sb.append(' ');
            sb.append(rru.getRemoteName());
            if (!this.sentCommand) {
                this.sentCommand = true;
                sb.append(capabilities);
            }
            this.pckOut.writeString(sb.toString());
            rru.setStatus(RemoteRefUpdate.Status.AWAITING_REPORT);
            if (rru.isDelete()) continue;
            this.writePack = true;
        }
        if (monitor.isCancelled()) {
            throw new TransportException(this.uri, JGitText.get().pushCancelled);
        }
        this.pckOut.end();
        this.outNeedsEnd = false;
    }

    private String enableCapabilities(ProgressMonitor monitor, OutputStream outputStream) {
        StringBuilder line = new StringBuilder();
        this.capableReport = this.wantCapability(line, CAPABILITY_REPORT_STATUS);
        this.capableDeleteRefs = this.wantCapability(line, CAPABILITY_DELETE_REFS);
        this.capableOfsDelta = this.wantCapability(line, CAPABILITY_OFS_DELTA);
        this.capableSideBand = this.wantCapability(line, CAPABILITY_SIDE_BAND_64K);
        if (this.capableSideBand) {
            this.in = new SideBandInputStream(this.in, monitor, this.getMessageWriter(), outputStream);
            this.pckIn = new PacketLineIn(this.in);
        }
        if (line.length() > 0) {
            line.setCharAt(0, '\u0000');
        }
        return line.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writePack(Map<String, RemoteRefUpdate> refUpdates, ProgressMonitor monitor) throws IOException {
        HashSet<ObjectId> remoteObjects = new HashSet<ObjectId>();
        HashSet<ObjectId> newObjects = new HashSet<ObjectId>();
        PackWriter writer = new PackWriter(this.transport.getPackConfig(), this.local.newObjectReader());
        try {
            for (Ref ref : this.getRefs()) {
                ObjectId oid = ref.getObjectId();
                if (!this.local.hasObject(oid)) continue;
                remoteObjects.add(oid);
            }
            remoteObjects.addAll(this.additionalHaves);
            for (RemoteRefUpdate remoteRefUpdate : refUpdates.values()) {
                if (ObjectId.zeroId().equals(remoteRefUpdate.getNewObjectId())) continue;
                newObjects.add(remoteRefUpdate.getNewObjectId());
            }
            writer.setIndexDisabled(true);
            writer.setUseCachedPacks(true);
            writer.setUseBitmaps(true);
            writer.setThin(this.thinPack);
            writer.setReuseValidatingObjects(false);
            writer.setDeltaBaseAsOffset(this.capableOfsDelta);
            writer.preparePack(monitor, (Set<? extends ObjectId>)newObjects, (Set<? extends ObjectId>)remoteObjects);
            writer.writePack(monitor, monitor, this.out);
        }
        finally {
            writer.release();
        }
        this.packTransferTime = writer.getStatistics().getTimeWriting();
    }

    private void readStatusReport(Map<String, RemoteRefUpdate> refUpdates) throws IOException {
        String refLine;
        String unpackLine = this.readStringLongTimeout();
        if (!unpackLine.startsWith("unpack ")) {
            throw new PackProtocolException(this.uri, MessageFormat.format(JGitText.get().unexpectedReportLine, unpackLine));
        }
        String unpackStatus = unpackLine.substring("unpack ".length());
        if (!unpackStatus.equals("ok")) {
            throw new TransportException(this.uri, MessageFormat.format(JGitText.get().errorOccurredDuringUnpackingOnTheRemoteEnd, unpackStatus));
        }
        while ((refLine = this.pckIn.readString()) != PacketLineIn.END) {
            boolean ok = false;
            int refNameEnd = -1;
            if (refLine.startsWith("ok ")) {
                ok = true;
                refNameEnd = refLine.length();
            } else if (refLine.startsWith("ng ")) {
                ok = false;
                refNameEnd = refLine.indexOf(" ", 3);
            }
            if (refNameEnd == -1) {
                throw new PackProtocolException(MessageFormat.format(JGitText.get().unexpectedReportLine2, this.uri, refLine));
            }
            String refName = refLine.substring(3, refNameEnd);
            String message = ok ? null : refLine.substring(refNameEnd + 1);
            RemoteRefUpdate rru = refUpdates.get(refName);
            if (rru == null) {
                throw new PackProtocolException(MessageFormat.format(JGitText.get().unexpectedRefReport, this.uri, refName));
            }
            if (ok) {
                rru.setStatus(RemoteRefUpdate.Status.OK);
                continue;
            }
            rru.setStatus(RemoteRefUpdate.Status.REJECTED_OTHER_REASON);
            rru.setMessage(message);
        }
        for (RemoteRefUpdate rru : refUpdates.values()) {
            if (rru.getStatus() != RemoteRefUpdate.Status.AWAITING_REPORT) continue;
            throw new PackProtocolException(MessageFormat.format(JGitText.get().expectedReportForRefNotReceived, this.uri, rru.getRemoteName()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readStringLongTimeout() throws IOException {
        if (this.timeoutIn == null) {
            return this.pckIn.readString();
        }
        int oldTimeout = this.timeoutIn.getTimeout();
        int sendTime = (int)Math.min(this.packTransferTime, 28800000L);
        try {
            this.timeoutIn.setTimeout(10 * Math.max(sendTime, oldTimeout));
            String string = this.pckIn.readString();
            return string;
        }
        finally {
            this.timeoutIn.setTimeout(oldTimeout);
        }
    }
}

