/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.ignore;

import org.eclipse.jgit.errors.InvalidPatternException;
import org.eclipse.jgit.fnmatch.FileNameMatcher;

public class IgnoreRule {
    private String pattern;
    private boolean negation;
    private boolean nameOnly;
    private boolean dirOnly;
    private FileNameMatcher matcher;

    public IgnoreRule(String pattern) {
        this.pattern = pattern;
        this.negation = false;
        this.nameOnly = false;
        this.dirOnly = false;
        this.matcher = null;
        this.setup();
    }

    private void setup() {
        int startIndex = 0;
        int endIndex = this.pattern.length();
        if (this.pattern.startsWith("!")) {
            ++startIndex;
            this.negation = true;
        }
        if (this.pattern.endsWith("/")) {
            --endIndex;
            this.dirOnly = true;
        }
        this.pattern = this.pattern.substring(startIndex, endIndex);
        boolean hasSlash = this.pattern.contains("/");
        if (!hasSlash) {
            this.nameOnly = true;
        } else if (!this.pattern.startsWith("/")) {
            this.pattern = "/" + this.pattern;
        }
        if (this.pattern.contains("*") || this.pattern.contains("?") || this.pattern.contains("[")) {
            try {
                this.matcher = new FileNameMatcher(this.pattern, Character.valueOf('/'));
            }
            catch (InvalidPatternException invalidPatternException) {
                // empty catch block
            }
        }
    }

    public boolean getNameOnly() {
        return this.nameOnly;
    }

    public boolean dirOnly() {
        return this.dirOnly;
    }

    public boolean getNegation() {
        return this.negation;
    }

    public String getPattern() {
        return this.pattern;
    }

    public boolean isMatch(String target, boolean isDirectory) {
        block10: {
            block9: {
                if (!target.startsWith("/")) {
                    target = "/" + target;
                }
                if (this.matcher != null) break block9;
                if (target.equals(this.pattern)) {
                    return !this.dirOnly || isDirectory;
                }
                if (target.startsWith(this.pattern + "/")) {
                    return true;
                }
                if (!this.nameOnly) break block10;
                String[] segments = target.split("/");
                for (int idx = 0; idx < segments.length; ++idx) {
                    String segmentName = segments[idx];
                    if (segmentName.length() == 0 || !segmentName.equals(this.pattern) || !this.doesMatchDirectoryExpectations(isDirectory, idx, segments.length)) continue;
                    return true;
                }
                break block10;
            }
            this.matcher.reset();
            this.matcher.append(target);
            if (this.matcher.isMatch()) {
                return true;
            }
            String[] segments = target.split("/");
            if (this.nameOnly) {
                for (int idx = 0; idx < segments.length; ++idx) {
                    String segmentName = segments[idx];
                    if (segmentName.length() == 0) continue;
                    this.matcher.reset();
                    this.matcher.append(segmentName);
                    if (!this.matcher.isMatch() || !this.doesMatchDirectoryExpectations(isDirectory, idx, segments.length)) continue;
                    return true;
                }
            } else {
                this.matcher.reset();
                for (int idx = 0; idx < segments.length; ++idx) {
                    String segmentName = segments[idx];
                    if (segmentName.length() == 0) continue;
                    this.matcher.append("/" + segmentName);
                    if (!this.matcher.isMatch() || !this.doesMatchDirectoryExpectations(isDirectory, idx, segments.length)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean getResult() {
        return !this.negation;
    }

    private boolean doesMatchDirectoryExpectations(boolean isDirectory, int segmentIdx, int segmentLength) {
        if (segmentIdx < segmentLength - 1) {
            return true;
        }
        return !this.dirOnly || isDirectory;
    }

    public String toString() {
        return this.pattern;
    }
}

