/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.dfs;

import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import org.eclipse.jgit.internal.storage.dfs.DfsOutputStream;

class InMemoryOutputStream
extends DfsOutputStream {
    private final ByteArrayOutputStream dst = new ByteArrayOutputStream();
    private byte[] data;

    InMemoryOutputStream() {
    }

    public void write(byte[] buf, int off, int len) {
        this.data = null;
        this.dst.write(buf, off, len);
    }

    public int read(long position, ByteBuffer buf) {
        byte[] d = this.getData();
        int n = Math.min(buf.remaining(), d.length - (int)position);
        if (n <= 0) {
            return -1;
        }
        buf.put(d, (int)position, n);
        return n;
    }

    byte[] getData() {
        if (this.data == null) {
            this.data = this.dst.toByteArray();
        }
        return this.data;
    }

    public void flush() {
    }

    public void close() {
        this.flush();
    }
}

