/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.api;

import java.io.IOException;
import java.util.List;
import org.eclipse.jgit.JGitText;
import org.eclipse.jgit.api.GitCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.NoHeadException;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.diff.DiffFormatter;
import org.eclipse.jgit.dircache.DirCacheIterator;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.CanonicalTreeParser;
import org.eclipse.jgit.treewalk.FileTreeIterator;
import org.eclipse.jgit.treewalk.filter.TreeFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiffCommand
extends GitCommand<List<DiffEntry>> {
    private AbstractTreeIterator oldTree;
    private AbstractTreeIterator newTree;
    private boolean cached;
    private TreeFilter pathFilter = TreeFilter.ALL;
    private boolean showNameAndStatusOnly = true;

    protected DiffCommand(Repository repo) {
        super(repo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<DiffEntry> call() throws GitAPIException, IOException {
        block11: {
            DiffFormatter diffFmt = new DiffFormatter(null);
            diffFmt.setRepository(this.repo);
            try {
                if (this.cached) {
                    if (this.oldTree == null) {
                        ObjectId head = this.repo.resolve("HEAD^{tree}");
                        if (head == null) {
                            throw new NoHeadException(JGitText.get().cannotReadTree);
                        }
                        CanonicalTreeParser p = new CanonicalTreeParser();
                        ObjectReader reader = this.repo.newObjectReader();
                        try {
                            p.reset(reader, head);
                            Object var6_5 = null;
                            reader.release();
                        }
                        catch (Throwable throwable) {
                            Object var6_6 = null;
                            reader.release();
                            throw throwable;
                        }
                        this.oldTree = p;
                    }
                    this.newTree = new DirCacheIterator(this.repo.readDirCache());
                } else {
                    if (this.oldTree == null) {
                        this.oldTree = new DirCacheIterator(this.repo.readDirCache());
                    }
                    if (this.newTree == null) {
                        this.newTree = new FileTreeIterator(this.repo);
                    }
                }
                diffFmt.setPathFilter(this.pathFilter);
                if (!this.showNameAndStatusOnly) break block11;
                List<DiffEntry> list = diffFmt.scan(this.oldTree, this.newTree);
                Object var8_8 = null;
                diffFmt.release();
                return list;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                diffFmt.release();
                throw throwable;
            }
        }
        throw new UnsupportedOperationException();
    }

    public DiffCommand setCached(boolean cached) {
        this.cached = cached;
        return this;
    }

    public DiffCommand setPathFilter(TreeFilter pathFilter) {
        this.pathFilter = pathFilter;
        return this;
    }

    public DiffCommand setOldTree(AbstractTreeIterator oldTree) {
        this.oldTree = oldTree;
        return this;
    }

    public DiffCommand setNewTree(AbstractTreeIterator newTree) {
        this.newTree = newTree;
        return this;
    }

    public DiffCommand setShowNameAndStatusOnly(boolean showNameAndStatusOnly) {
        if (!showNameAndStatusOnly) {
            throw new UnsupportedOperationException();
        }
        this.showNameAndStatusOnly = showNameAndStatusOnly;
        return this;
    }
}

