/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.util;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import org.eclipse.jgit.lib.NullProgressMonitor;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.util.IO;

public class TemporaryBuffer
extends OutputStream {
    static final int DEFAULT_IN_CORE_LIMIT = 0x100000;
    private ArrayList<Block> blocks = new ArrayList(this.inCoreLimit / 8192);
    private int inCoreLimit = 0x100000;
    private File onDiskFile;
    private OutputStream diskOut;

    public TemporaryBuffer() {
        this.blocks.add(new Block());
    }

    public void write(int b) throws IOException {
        if (this.blocks == null) {
            this.diskOut.write(b);
            return;
        }
        Block s = this.last();
        if (s.isFull()) {
            if (this.reachedInCoreLimit()) {
                this.diskOut.write(b);
                return;
            }
            s = new Block();
            this.blocks.add(s);
        }
        s.buffer[s.count++] = (byte)b;
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (this.blocks != null) {
            while (len > 0) {
                Block s = this.last();
                if (s.isFull()) {
                    if (this.reachedInCoreLimit()) break;
                    s = new Block();
                    this.blocks.add(s);
                }
                int n = Math.min(8192 - s.count, len);
                System.arraycopy(b, off, s.buffer, s.count, n);
                s.count += n;
                len -= n;
                off += n;
            }
        }
        if (len > 0) {
            this.diskOut.write(b, off, len);
        }
    }

    public void copy(InputStream in) throws IOException {
        int n;
        if (this.blocks != null) {
            while (true) {
                Block s;
                if ((s = this.last()).isFull()) {
                    if (this.reachedInCoreLimit()) break;
                    s = new Block();
                    this.blocks.add(s);
                }
                if ((n = in.read(s.buffer, s.count, 8192 - s.count)) < 1) {
                    return;
                }
                s.count += n;
            }
        }
        byte[] tmp = new byte[8192];
        while ((n = in.read(tmp)) > 0) {
            this.diskOut.write(tmp, 0, n);
        }
    }

    private Block last() {
        return this.blocks.get(this.blocks.size() - 1);
    }

    private boolean reachedInCoreLimit() throws IOException {
        if (this.blocks.size() * 8192 < this.inCoreLimit) {
            return false;
        }
        this.onDiskFile = File.createTempFile("jgit_", ".buffer");
        this.diskOut = new FileOutputStream(this.onDiskFile);
        Block last = this.blocks.remove(this.blocks.size() - 1);
        for (Block b : this.blocks) {
            this.diskOut.write(b.buffer, 0, b.count);
        }
        this.blocks = null;
        this.diskOut = new BufferedOutputStream(this.diskOut, 8192);
        this.diskOut.write(last.buffer, 0, last.count);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (this.diskOut != null) {
            try {
                this.diskOut.close();
            }
            finally {
                this.diskOut = null;
            }
        }
    }

    public long length() {
        if (this.onDiskFile != null) {
            return this.onDiskFile.length();
        }
        Block last = this.last();
        return (long)this.blocks.size() * 8192L - (long)(8192 - last.count);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] toByteArray() throws IOException {
        long len = this.length();
        if (Integer.MAX_VALUE < len) {
            throw new OutOfMemoryError("Length exceeds maximum array size");
        }
        byte[] out = new byte[(int)len];
        if (this.blocks != null) {
            int outPtr = 0;
            for (Block b : this.blocks) {
                System.arraycopy(b.buffer, 0, out, outPtr, b.count);
                outPtr += b.count;
            }
        } else {
            FileInputStream in = new FileInputStream(this.onDiskFile);
            try {
                IO.readFully(in, out, 0, (int)len);
            }
            finally {
                in.close();
            }
        }
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(OutputStream os, ProgressMonitor pm) throws IOException {
        if (pm == null) {
            pm = NullProgressMonitor.INSTANCE;
        }
        if (this.blocks != null) {
            for (Block b : this.blocks) {
                os.write(b.buffer, 0, b.count);
                pm.update(b.count / 1024);
            }
        } else {
            FileInputStream in = new FileInputStream(this.onDiskFile);
            try {
                int cnt;
                byte[] buf = new byte[8192];
                while ((cnt = in.read(buf)) >= 0) {
                    os.write(buf, 0, cnt);
                    pm.update(cnt / 1024);
                }
            }
            finally {
                in.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        this.blocks = null;
        if (this.diskOut != null) {
            try {
                this.diskOut.close();
            }
            catch (IOException iOException) {
            }
            finally {
                this.diskOut = null;
            }
        }
        if (this.onDiskFile != null) {
            if (!this.onDiskFile.delete()) {
                this.onDiskFile.deleteOnExit();
            }
            this.onDiskFile = null;
        }
    }

    static class Block {
        static final int SZ = 8192;
        final byte[] buffer = new byte[8192];
        int count;

        Block() {
        }

        boolean isFull() {
            return this.count == 8192;
        }
    }
}

