/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.treewalk.filter;

import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.TreeFilter;

public class PathFilter
extends TreeFilter {
    final String pathStr;
    final byte[] pathRaw;

    public static PathFilter create(String path) {
        while (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        if (path.length() == 0) {
            throw new IllegalArgumentException("Empty path not permitted.");
        }
        return new PathFilter(path);
    }

    private PathFilter(String s) {
        this.pathStr = s;
        this.pathRaw = Constants.encode(this.pathStr);
    }

    public boolean include(TreeWalk walker) {
        return walker.isPathPrefix(this.pathRaw, this.pathRaw.length) == 0;
    }

    public boolean shouldBeRecursive() {
        for (byte b : this.pathRaw) {
            if (b != 47) continue;
            return true;
        }
        return false;
    }

    public TreeFilter clone() {
        return this;
    }

    public String toString() {
        return "PATH(\"" + this.pathStr + "\")";
    }
}

