/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.jgit.errors.CompoundException;
import org.eclipse.jgit.errors.CorruptObjectException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.errors.ObjectWritingException;
import org.eclipse.jgit.errors.TransportException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.MutableObjectId;
import org.eclipse.jgit.lib.ObjectChecker;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.PackIndex;
import org.eclipse.jgit.lib.PackLock;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.UnpackedObjectLoader;
import org.eclipse.jgit.revwalk.DateRevQueue;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevFlag;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevTag;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.transport.BaseFetchConnection;
import org.eclipse.jgit.transport.IndexPack;
import org.eclipse.jgit.transport.Transport;
import org.eclipse.jgit.transport.WalkRemoteObjectDatabase;
import org.eclipse.jgit.transport.WalkTransport;
import org.eclipse.jgit.treewalk.TreeWalk;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class WalkFetchConnection
extends BaseFetchConnection {
    private final Repository local;
    private final ObjectChecker objCheck;
    private final List<WalkRemoteObjectDatabase> remotes;
    private int lastRemoteIdx;
    private final RevWalk revWalk;
    private final TreeWalk treeWalk;
    private final RevFlag COMPLETE;
    private final RevFlag IN_WORK_QUEUE;
    private final RevFlag LOCALLY_SEEN;
    private final DateRevQueue localCommitQueue;
    private LinkedList<ObjectId> workQueue;
    private final LinkedList<WalkRemoteObjectDatabase> noPacksYet;
    private final LinkedList<WalkRemoteObjectDatabase> noAlternatesYet;
    private final LinkedList<RemotePack> unfetchedPacks;
    private final Set<String> packsConsidered;
    private final MutableObjectId idBuffer = new MutableObjectId();
    private final MessageDigest objectDigest = Constants.newMessageDigest();
    private final HashMap<ObjectId, List<Throwable>> fetchErrors;
    private String lockMessage;
    private final List<PackLock> packLocks;

    WalkFetchConnection(WalkTransport t, WalkRemoteObjectDatabase w) {
        Transport wt = (Transport)((Object)t);
        this.local = wt.local;
        this.objCheck = wt.isCheckFetchedObjects() ? new ObjectChecker() : null;
        this.remotes = new ArrayList<WalkRemoteObjectDatabase>();
        this.remotes.add(w);
        this.unfetchedPacks = new LinkedList();
        this.packsConsidered = new HashSet<String>();
        this.noPacksYet = new LinkedList();
        this.noPacksYet.add(w);
        this.noAlternatesYet = new LinkedList();
        this.noAlternatesYet.add(w);
        this.fetchErrors = new HashMap();
        this.packLocks = new ArrayList<PackLock>(4);
        this.revWalk = new RevWalk(this.local);
        this.revWalk.setRetainBody(false);
        this.treeWalk = new TreeWalk(this.local);
        this.COMPLETE = this.revWalk.newFlag("COMPLETE");
        this.IN_WORK_QUEUE = this.revWalk.newFlag("IN_WORK_QUEUE");
        this.LOCALLY_SEEN = this.revWalk.newFlag("LOCALLY_SEEN");
        this.localCommitQueue = new DateRevQueue();
        this.workQueue = new LinkedList();
    }

    @Override
    public boolean didFetchTestConnectivity() {
        return true;
    }

    @Override
    protected void doFetch(ProgressMonitor monitor, Collection<Ref> want, Set<ObjectId> have) throws TransportException {
        this.markLocalRefsComplete(have);
        this.queueWants(want);
        while (!monitor.isCancelled() && !this.workQueue.isEmpty()) {
            ObjectId id = this.workQueue.removeFirst();
            if (!(id instanceof RevObject) || !((RevObject)id).has(this.COMPLETE)) {
                this.downloadObject(monitor, id);
            }
            this.process(id);
        }
    }

    @Override
    public Collection<PackLock> getPackLocks() {
        return this.packLocks;
    }

    @Override
    public void setPackLockMessage(String message) {
        this.lockMessage = message;
    }

    @Override
    public void close() {
        for (RemotePack p : this.unfetchedPacks) {
            p.tmpIdx.delete();
        }
        for (WalkRemoteObjectDatabase r : this.remotes) {
            r.close();
        }
    }

    private void queueWants(Collection<Ref> want) throws TransportException {
        HashSet<ObjectId> inWorkQueue = new HashSet<ObjectId>();
        for (Ref r : want) {
            ObjectId id = r.getObjectId();
            try {
                RevObject obj = this.revWalk.parseAny(id);
                if (obj.has(this.COMPLETE) || !inWorkQueue.add(id)) continue;
                obj.add(this.IN_WORK_QUEUE);
                this.workQueue.add(obj);
            }
            catch (MissingObjectException e) {
                if (!inWorkQueue.add(id)) continue;
                this.workQueue.add(id);
            }
            catch (IOException e) {
                throw new TransportException("Cannot read " + id.name(), e);
            }
        }
    }

    private void process(ObjectId id) throws TransportException {
        RevObject obj;
        try {
            if (id instanceof RevObject) {
                obj = (RevObject)id;
                if (obj.has(this.COMPLETE)) {
                    return;
                }
                this.revWalk.parseHeaders(obj);
            } else {
                obj = this.revWalk.parseAny(id);
                if (obj.has(this.COMPLETE)) {
                    return;
                }
            }
        }
        catch (IOException e) {
            throw new TransportException("Cannot read " + id.name(), e);
        }
        switch (obj.getType()) {
            case 3: {
                this.processBlob(obj);
                break;
            }
            case 2: {
                this.processTree(obj);
                break;
            }
            case 1: {
                this.processCommit(obj);
                break;
            }
            case 4: {
                this.processTag(obj);
                break;
            }
            default: {
                throw new TransportException("Unknown object type " + id.name());
            }
        }
        this.fetchErrors.remove(id.copy());
    }

    private void processBlob(RevObject obj) throws TransportException {
        if (!this.local.hasObject(obj)) {
            throw new TransportException("Cannot read blob " + obj.name(), new MissingObjectException((ObjectId)obj, "blob"));
        }
        obj.add(this.COMPLETE);
    }

    private void processTree(RevObject obj) throws TransportException {
        try {
            this.treeWalk.reset(obj);
            block5: while (this.treeWalk.next()) {
                FileMode mode = this.treeWalk.getFileMode(0);
                int sType = mode.getObjectType();
                switch (sType) {
                    case 2: 
                    case 3: {
                        this.treeWalk.getObjectId(this.idBuffer, 0);
                        this.needs(this.revWalk.lookupAny(this.idBuffer, sType));
                        continue block5;
                    }
                }
                if (FileMode.GITLINK.equals(mode)) continue;
                this.treeWalk.getObjectId(this.idBuffer, 0);
                throw new CorruptObjectException("Invalid mode " + mode + " for " + this.idBuffer.name() + " " + this.treeWalk.getPathString() + " in " + obj.getId().name() + ".");
            }
        }
        catch (IOException ioe) {
            throw new TransportException("Cannot read tree " + obj.name(), ioe);
        }
        obj.add(this.COMPLETE);
    }

    private void processCommit(RevObject obj) throws TransportException {
        RevCommit commit = (RevCommit)obj;
        this.markLocalCommitsComplete(commit.getCommitTime());
        this.needs(commit.getTree());
        for (RevCommit p : commit.getParents()) {
            this.needs(p);
        }
        obj.add(this.COMPLETE);
    }

    private void processTag(RevObject obj) {
        RevTag tag = (RevTag)obj;
        this.needs(tag.getObject());
        obj.add(this.COMPLETE);
    }

    private void needs(RevObject obj) {
        if (obj.has(this.COMPLETE)) {
            return;
        }
        if (!obj.has(this.IN_WORK_QUEUE)) {
            obj.add(this.IN_WORK_QUEUE);
            this.workQueue.add(obj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downloadObject(ProgressMonitor pm, AnyObjectId id) throws TransportException {
        if (this.local.hasObject(id)) {
            return;
        }
        block4: while (true) {
            int i;
            if (this.downloadPackedObject(pm, id)) {
                return;
            }
            String idStr = id.name();
            String subdir = idStr.substring(0, 2);
            String file = idStr.substring(2);
            String looseName = subdir + "/" + file;
            for (i = this.lastRemoteIdx; i < this.remotes.size(); ++i) {
                if (!this.downloadLooseObject(id, looseName, this.remotes.get(i))) continue;
                this.lastRemoteIdx = i;
                return;
            }
            for (i = 0; i < this.lastRemoteIdx; ++i) {
                if (!this.downloadLooseObject(id, looseName, this.remotes.get(i))) continue;
                this.lastRemoteIdx = i;
                return;
            }
            while (!this.noPacksYet.isEmpty()) {
                Object var11_15;
                Collection<String> packNameList;
                WalkRemoteObjectDatabase wrr = this.noPacksYet.removeFirst();
                try {
                    try {
                        pm.beginTask("Listing packs", 0);
                        packNameList = wrr.getPackNames();
                    }
                    catch (IOException e) {
                        this.recordError(id, e);
                        var11_15 = null;
                        pm.endTask();
                        continue;
                    }
                    var11_15 = null;
                    pm.endTask();
                }
                catch (Throwable throwable) {
                    var11_15 = null;
                    pm.endTask();
                    throw throwable;
                }
                if (packNameList == null || packNameList.isEmpty()) continue;
                for (String packName : packNameList) {
                    if (!this.packsConsidered.add(packName)) continue;
                    this.unfetchedPacks.add(new RemotePack(wrr, packName));
                }
                if (!this.downloadPackedObject(pm, id)) continue;
                return;
            }
            Collection<WalkRemoteObjectDatabase> al = this.expandOneAlternate(id, pm);
            if (al == null || al.isEmpty()) break;
            Iterator<WalkRemoteObjectDatabase> i$ = al.iterator();
            while (true) {
                if (!i$.hasNext()) continue block4;
                WalkRemoteObjectDatabase alt = i$.next();
                this.remotes.add(alt);
                this.noPacksYet.add(alt);
                this.noAlternatesYet.add(alt);
            }
            break;
        }
        List<Throwable> failures = this.fetchErrors.get(id.copy());
        TransportException te = new TransportException("Cannot get " + id.name() + ".");
        if (failures != null && !failures.isEmpty()) {
            if (failures.size() == 1) {
                te.initCause(failures.get(0));
            } else {
                te.initCause(new CompoundException(failures));
            }
        }
        throw te;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean downloadPackedObject(ProgressMonitor monitor, AnyObjectId id) throws TransportException {
        Iterator packItr = this.unfetchedPacks.iterator();
        while (packItr.hasNext() && !monitor.isCancelled()) {
            Object var7_8;
            RemotePack pack = (RemotePack)packItr.next();
            try {
                pack.openIndex(monitor);
            }
            catch (IOException err) {
                this.recordError(id, err);
                packItr.remove();
                continue;
            }
            if (monitor.isCancelled()) {
                return false;
            }
            if (!pack.index.hasObject(id)) continue;
            try {
                try {
                    pack.downloadPack(monitor);
                }
                catch (IOException err) {
                    this.recordError(id, err);
                    var7_8 = null;
                    pack.tmpIdx.delete();
                    packItr.remove();
                    continue;
                }
                var7_8 = null;
                pack.tmpIdx.delete();
            }
            catch (Throwable throwable) {
                var7_8 = null;
                pack.tmpIdx.delete();
                packItr.remove();
                throw throwable;
            }
            packItr.remove();
            if (!this.local.hasObject(id)) {
                this.recordError(id, new FileNotFoundException("Object " + id.name() + " not found in " + pack.packName + "."));
                continue;
            }
            Iterator<ObjectId> pending = this.swapFetchQueue();
            while (pending.hasNext()) {
                ObjectId p = pending.next();
                if (pack.index.hasObject(p)) {
                    pending.remove();
                    this.process(p);
                    continue;
                }
                this.workQueue.add(p);
            }
            return true;
        }
        return false;
    }

    private Iterator<ObjectId> swapFetchQueue() {
        Iterator<ObjectId> r = this.workQueue.iterator();
        this.workQueue = new LinkedList();
        return r;
    }

    private boolean downloadLooseObject(AnyObjectId id, String looseName, WalkRemoteObjectDatabase remote) throws TransportException {
        try {
            byte[] compressed = remote.open(looseName).toArray();
            this.verifyLooseObject(id, compressed);
            this.saveLooseObject(id, compressed);
            return true;
        }
        catch (FileNotFoundException e) {
            this.recordError(id, e);
            return false;
        }
        catch (IOException e) {
            throw new TransportException("Cannot download " + id.name(), e);
        }
    }

    private void verifyLooseObject(AnyObjectId id, byte[] compressed) throws IOException {
        UnpackedObjectLoader uol;
        try {
            uol = new UnpackedObjectLoader(compressed);
        }
        catch (CorruptObjectException parsingError) {
            FileNotFoundException e = new FileNotFoundException(id.name());
            e.initCause(parsingError);
            throw e;
        }
        this.objectDigest.reset();
        this.objectDigest.update(Constants.encodedTypeString(uol.getType()));
        this.objectDigest.update((byte)32);
        this.objectDigest.update(Constants.encodeASCII(uol.getSize()));
        this.objectDigest.update((byte)0);
        this.objectDigest.update(uol.getCachedBytes());
        this.idBuffer.fromRaw(this.objectDigest.digest(), 0);
        if (!AnyObjectId.equals(id, this.idBuffer)) {
            throw new TransportException("Incorrect hash for " + id.name() + "; computed " + this.idBuffer.name() + " as a " + Constants.typeString(uol.getType()) + " from " + compressed.length + " bytes.");
        }
        if (this.objCheck != null) {
            try {
                this.objCheck.check(uol.getType(), uol.getCachedBytes());
            }
            catch (CorruptObjectException e) {
                throw new TransportException("Invalid " + Constants.typeString(uol.getType()) + " " + id.name() + ":" + e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveLooseObject(AnyObjectId id, byte[] compressed) throws IOException, ObjectWritingException {
        File tmp = File.createTempFile("noz", null, this.local.getObjectsDirectory());
        try {
            FileOutputStream out = new FileOutputStream(tmp);
            try {
                out.write(compressed);
                Object var6_6 = null;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                out.close();
                throw throwable;
            }
            out.close();
            tmp.setReadOnly();
        }
        catch (IOException e) {
            tmp.delete();
            throw e;
        }
        File o = this.local.toFile(id);
        if (tmp.renameTo(o)) {
            return;
        }
        o.getParentFile().mkdir();
        if (tmp.renameTo(o)) {
            return;
        }
        tmp.delete();
        if (this.local.hasObject(id)) {
            return;
        }
        throw new ObjectWritingException("Unable to store " + id.name() + ".");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Collection<WalkRemoteObjectDatabase> expandOneAlternate(AnyObjectId id, ProgressMonitor pm) {
        while (!this.noAlternatesYet.isEmpty()) {
            Object var7_6;
            WalkRemoteObjectDatabase wrr = this.noAlternatesYet.removeFirst();
            try {
                try {
                    pm.beginTask("Listing alternates", 0);
                    Collection<WalkRemoteObjectDatabase> altList = wrr.getAlternates();
                    if (altList != null && !altList.isEmpty()) {
                        Collection<WalkRemoteObjectDatabase> collection = altList;
                        var7_6 = null;
                        pm.endTask();
                        return collection;
                    }
                    var7_6 = null;
                    pm.endTask();
                }
                catch (IOException e) {
                    this.recordError(id, e);
                    var7_6 = null;
                    pm.endTask();
                }
            }
            catch (Throwable throwable) {
                var7_6 = null;
                pm.endTask();
                throw throwable;
            }
        }
        return null;
    }

    private void markLocalRefsComplete(Set<ObjectId> have) throws TransportException {
        for (Ref r : this.local.getAllRefs().values()) {
            try {
                this.markLocalObjComplete(this.revWalk.parseAny(r.getObjectId()));
            }
            catch (IOException readError) {
                throw new TransportException("Local ref " + r.getName() + " is missing object(s).", readError);
            }
        }
        for (ObjectId id : have) {
            try {
                this.markLocalObjComplete(this.revWalk.parseAny(id));
            }
            catch (IOException readError) {
                throw new TransportException("Missing assumed " + id.name(), readError);
            }
        }
    }

    private void markLocalObjComplete(RevObject obj) throws IOException {
        while (obj.getType() == 4) {
            obj.add(this.COMPLETE);
            obj = ((RevTag)obj).getObject();
            this.revWalk.parseHeaders(obj);
        }
        switch (obj.getType()) {
            case 3: {
                obj.add(this.COMPLETE);
                break;
            }
            case 1: {
                this.pushLocalCommit((RevCommit)obj);
                break;
            }
            case 2: {
                this.markTreeComplete((RevTree)obj);
            }
        }
    }

    private void markLocalCommitsComplete(int until) throws TransportException {
        try {
            block2: while (true) {
                RevCommit c;
                if ((c = this.localCommitQueue.peek()) == null || c.getCommitTime() < until) {
                    return;
                }
                this.localCommitQueue.next();
                this.markTreeComplete(c.getTree());
                RevCommit[] arr$ = c.getParents();
                int len$ = arr$.length;
                int i$ = 0;
                while (true) {
                    if (i$ >= len$) continue block2;
                    RevCommit p = arr$[i$];
                    this.pushLocalCommit(p);
                    ++i$;
                }
                break;
            }
        }
        catch (IOException err) {
            throw new TransportException("Local objects incomplete.", err);
        }
    }

    private void pushLocalCommit(RevCommit p) throws MissingObjectException, IOException {
        if (p.has(this.LOCALLY_SEEN)) {
            return;
        }
        this.revWalk.parseHeaders(p);
        p.add(this.LOCALLY_SEEN);
        p.add(this.COMPLETE);
        p.carry(this.COMPLETE);
        this.localCommitQueue.add(p);
    }

    private void markTreeComplete(RevTree tree) throws IOException {
        if (tree.has(this.COMPLETE)) {
            return;
        }
        tree.add(this.COMPLETE);
        this.treeWalk.reset(tree);
        block4: while (this.treeWalk.next()) {
            FileMode mode = this.treeWalk.getFileMode(0);
            int sType = mode.getObjectType();
            switch (sType) {
                case 3: {
                    this.treeWalk.getObjectId(this.idBuffer, 0);
                    this.revWalk.lookupAny(this.idBuffer, sType).add(this.COMPLETE);
                    continue block4;
                }
                case 2: {
                    this.treeWalk.getObjectId(this.idBuffer, 0);
                    RevObject o = this.revWalk.lookupAny(this.idBuffer, sType);
                    if (o.has(this.COMPLETE)) continue block4;
                    o.add(this.COMPLETE);
                    this.treeWalk.enterSubtree();
                    continue block4;
                }
            }
            if (FileMode.GITLINK.equals(mode)) continue;
            this.treeWalk.getObjectId(this.idBuffer, 0);
            throw new CorruptObjectException("Invalid mode " + mode + " for " + this.idBuffer.name() + " " + this.treeWalk.getPathString() + " in " + tree.name() + ".");
        }
    }

    private void recordError(AnyObjectId id, Throwable what) {
        ObjectId objId = id.copy();
        List<Throwable> errors = this.fetchErrors.get(objId);
        if (errors == null) {
            errors = new ArrayList<Throwable>(2);
            this.fetchErrors.put(objId, errors);
        }
        errors.add(what);
    }

    private class RemotePack {
        final WalkRemoteObjectDatabase connection;
        final String packName;
        final String idxName;
        final File tmpIdx;
        PackIndex index;

        RemotePack(WalkRemoteObjectDatabase c, String pn) {
            File objdir = WalkFetchConnection.this.local.getObjectsDirectory();
            this.connection = c;
            this.packName = pn;
            String tn = this.idxName = this.packName.substring(0, this.packName.length() - 5) + ".idx";
            if (tn.startsWith("pack-")) {
                tn = tn.substring(5);
            }
            if (tn.endsWith(".idx")) {
                tn = tn.substring(0, tn.length() - 4);
            }
            this.tmpIdx = new File(objdir, "walk-" + tn + ".walkidx");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void openIndex(ProgressMonitor pm) throws IOException {
            if (this.index != null) {
                return;
            }
            if (this.tmpIdx.isFile()) {
                try {
                    this.index = PackIndex.open(this.tmpIdx);
                    return;
                }
                catch (FileNotFoundException err) {
                    // empty catch block
                }
            }
            WalkRemoteObjectDatabase.FileStream s = this.connection.open("pack/" + this.idxName);
            pm.beginTask("Get " + this.idxName.substring(0, 12) + "..idx", s.length < 0L ? 0 : (int)(s.length / 1024L));
            try {
                try {
                    FileOutputStream fos = new FileOutputStream(this.tmpIdx);
                    try {
                        int cnt;
                        byte[] buf = new byte[2048];
                        while (!pm.isCancelled() && (cnt = s.in.read(buf)) >= 0) {
                            fos.write(buf, 0, cnt);
                            pm.update(cnt / 1024);
                        }
                        Object var7_9 = null;
                    }
                    catch (Throwable throwable) {
                        Object var7_10 = null;
                        fos.close();
                        throw throwable;
                    }
                    fos.close();
                    Object var9_12 = null;
                }
                catch (IOException err) {
                    this.tmpIdx.delete();
                    throw err;
                }
            }
            catch (Throwable throwable) {
                Object var9_13 = null;
                s.in.close();
                throw throwable;
            }
            s.in.close();
            pm.endTask();
            if (pm.isCancelled()) {
                this.tmpIdx.delete();
                return;
            }
            try {
                this.index = PackIndex.open(this.tmpIdx);
            }
            catch (IOException e) {
                this.tmpIdx.delete();
                throw e;
            }
        }

        void downloadPack(ProgressMonitor monitor) throws IOException {
            WalkRemoteObjectDatabase.FileStream s = this.connection.open("pack/" + this.packName);
            IndexPack ip = IndexPack.create(WalkFetchConnection.this.local, s.in);
            ip.setFixThin(false);
            ip.setObjectChecker(WalkFetchConnection.this.objCheck);
            ip.index(monitor);
            PackLock keep = ip.renameAndOpenPack(WalkFetchConnection.this.lockMessage);
            if (keep != null) {
                WalkFetchConnection.this.packLocks.add(keep);
            }
        }
    }
}

