/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.SftpATTRS;
import com.jcraft.jsch.SftpException;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import org.eclipse.jgit.errors.TransportException;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.FetchConnection;
import org.eclipse.jgit.transport.PushConnection;
import org.eclipse.jgit.transport.SshTransport;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.transport.WalkFetchConnection;
import org.eclipse.jgit.transport.WalkPushConnection;
import org.eclipse.jgit.transport.WalkRemoteObjectDatabase;
import org.eclipse.jgit.transport.WalkTransport;

public class TransportSftp
extends SshTransport
implements WalkTransport {
    static boolean canHandle(URIish uri) {
        return uri.isRemote() && "sftp".equals(uri.getScheme());
    }

    TransportSftp(Repository local, URIish uri) {
        super(local, uri);
    }

    public FetchConnection openFetch() throws TransportException {
        SftpObjectDB c = new SftpObjectDB(this.uri.getPath());
        WalkFetchConnection r = new WalkFetchConnection(this, c);
        r.available(c.readAdvertisedRefs());
        return r;
    }

    public PushConnection openPush() throws TransportException {
        SftpObjectDB c = new SftpObjectDB(this.uri.getPath());
        WalkPushConnection r = new WalkPushConnection(this, c);
        r.available(c.readAdvertisedRefs());
        return r;
    }

    ChannelSftp newSftp() throws TransportException {
        this.initSession();
        int tms = this.getTimeout() > 0 ? this.getTimeout() * 1000 : 0;
        try {
            Channel channel = this.sock.openChannel("sftp");
            channel.connect(tms);
            return (ChannelSftp)channel;
        }
        catch (JSchException je) {
            throw new TransportException(this.uri, je.getMessage(), je);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class SftpObjectDB
    extends WalkRemoteObjectDatabase {
        private final String objectsPath;
        private ChannelSftp ftp;

        SftpObjectDB(String path) throws TransportException {
            if (path.startsWith("/~")) {
                path = path.substring(1);
            }
            if (path.startsWith("~/")) {
                path = path.substring(2);
            }
            try {
                this.ftp = TransportSftp.this.newSftp();
                this.ftp.cd(path);
                this.ftp.cd("objects");
                this.objectsPath = this.ftp.pwd();
            }
            catch (TransportException err) {
                this.close();
                throw err;
            }
            catch (SftpException je) {
                throw new TransportException("Can't enter " + path + "/objects" + ": " + je.getMessage(), je);
            }
        }

        SftpObjectDB(SftpObjectDB parent, String p) throws TransportException {
            try {
                this.ftp = TransportSftp.this.newSftp();
                this.ftp.cd(parent.objectsPath);
                this.ftp.cd(p);
                this.objectsPath = this.ftp.pwd();
            }
            catch (TransportException err) {
                this.close();
                throw err;
            }
            catch (SftpException je) {
                throw new TransportException("Can't enter " + p + " from " + parent.objectsPath + ": " + je.getMessage(), je);
            }
        }

        @Override
        URIish getURI() {
            return TransportSftp.this.uri.setPath(this.objectsPath);
        }

        @Override
        Collection<WalkRemoteObjectDatabase> getAlternates() throws IOException {
            try {
                return this.readAlternates("info/alternates");
            }
            catch (FileNotFoundException err) {
                return null;
            }
        }

        @Override
        WalkRemoteObjectDatabase openAlternate(String location) throws IOException {
            return new SftpObjectDB(this, location);
        }

        @Override
        Collection<String> getPackNames() throws IOException {
            ArrayList<String> packs = new ArrayList<String>();
            try {
                Vector list = this.ftp.ls("pack");
                HashMap<String, ChannelSftp.LsEntry> files = new HashMap<String, ChannelSftp.LsEntry>();
                final HashMap<String, Integer> mtimes = new HashMap<String, Integer>();
                for (ChannelSftp.LsEntry ent : list) {
                    files.put(ent.getFilename(), ent);
                }
                for (ChannelSftp.LsEntry ent : list) {
                    String in;
                    String n = ent.getFilename();
                    if (!n.startsWith("pack-") || !n.endsWith(".pack") || !files.containsKey(in = n.substring(0, n.length() - 5) + ".idx")) continue;
                    mtimes.put(n, ent.getAttrs().getMTime());
                    packs.add(n);
                }
                Collections.sort(packs, new Comparator<String>(){

                    @Override
                    public int compare(String o1, String o2) {
                        return (Integer)mtimes.get(o2) - (Integer)mtimes.get(o1);
                    }
                });
            }
            catch (SftpException je) {
                throw new TransportException("Can't ls " + this.objectsPath + "/pack: " + je.getMessage(), je);
            }
            return packs;
        }

        @Override
        WalkRemoteObjectDatabase.FileStream open(String path) throws IOException {
            try {
                SftpATTRS a = this.ftp.lstat(path);
                return new WalkRemoteObjectDatabase.FileStream(this.ftp.get(path), a.getSize());
            }
            catch (SftpException je) {
                if (je.id == 2) {
                    throw new FileNotFoundException(path);
                }
                throw new TransportException("Can't get " + this.objectsPath + "/" + path + ": " + je.getMessage(), je);
            }
        }

        @Override
        void deleteFile(String path) throws IOException {
            try {
                this.ftp.rm(path);
            }
            catch (SftpException je) {
                if (je.id == 2) {
                    return;
                }
                throw new TransportException("Can't delete " + this.objectsPath + "/" + path + ": " + je.getMessage(), je);
            }
            String dir = path;
            int s = dir.lastIndexOf(47);
            while (s > 0) {
                try {
                    dir = dir.substring(0, s);
                    this.ftp.rmdir(dir);
                    s = dir.lastIndexOf(47);
                }
                catch (SftpException je) {
                    break;
                }
            }
        }

        @Override
        OutputStream writeFile(String path, ProgressMonitor monitor, String monitorTask) throws IOException {
            try {
                return this.ftp.put(path);
            }
            catch (SftpException je) {
                if (je.id == 2) {
                    this.mkdir_p(path);
                    try {
                        return this.ftp.put(path);
                    }
                    catch (SftpException je2) {
                        je = je2;
                    }
                }
                throw new TransportException("Can't write " + this.objectsPath + "/" + path + ": " + je.getMessage(), je);
            }
        }

        @Override
        void writeFile(String path, byte[] data) throws IOException {
            String lock = path + ".lock";
            try {
                super.writeFile(lock, data);
                try {
                    this.ftp.rename(lock, path);
                }
                catch (SftpException je) {
                    throw new TransportException("Can't write " + this.objectsPath + "/" + path + ": " + je.getMessage(), je);
                }
            }
            catch (IOException err) {
                try {
                    this.ftp.rm(lock);
                }
                catch (SftpException e) {
                    // empty catch block
                }
                throw err;
            }
        }

        private void mkdir_p(String path) throws IOException {
            int s = path.lastIndexOf(47);
            if (s <= 0) {
                return;
            }
            path = path.substring(0, s);
            try {
                this.ftp.mkdir(path);
            }
            catch (SftpException je) {
                if (je.id == 2) {
                    this.mkdir_p(path);
                    try {
                        this.ftp.mkdir(path);
                        return;
                    }
                    catch (SftpException je2) {
                        je = je2;
                    }
                }
                throw new TransportException("Can't mkdir " + this.objectsPath + "/" + path + ": " + je.getMessage(), je);
            }
        }

        Map<String, Ref> readAdvertisedRefs() throws TransportException {
            TreeMap<String, Ref> avail = new TreeMap<String, Ref>();
            this.readPackedRefs(avail);
            this.readRef(avail, "../HEAD", "HEAD");
            this.readLooseRefs(avail, "../refs", "refs/");
            return avail;
        }

        private void readLooseRefs(TreeMap<String, Ref> avail, String dir, String prefix) throws TransportException {
            Vector list;
            try {
                list = this.ftp.ls(dir);
            }
            catch (SftpException je) {
                throw new TransportException("Can't ls " + this.objectsPath + "/" + dir + ": " + je.getMessage(), je);
            }
            for (ChannelSftp.LsEntry ent : list) {
                String n = ent.getFilename();
                if (".".equals(n) || "..".equals(n)) continue;
                String nPath = dir + "/" + n;
                if (ent.getAttrs().isDir()) {
                    this.readLooseRefs(avail, nPath, prefix + n + "/");
                    continue;
                }
                this.readRef(avail, nPath, prefix + n);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Ref readRef(TreeMap<String, Ref> avail, String path, String name) throws TransportException {
            String line;
            try {
                BufferedReader br = this.openReader(path);
                try {
                    line = br.readLine();
                    Object var7_8 = null;
                }
                catch (Throwable throwable) {
                    Object var7_9 = null;
                    br.close();
                    throw throwable;
                }
                br.close();
                {
                }
            }
            catch (FileNotFoundException noRef) {
                return null;
            }
            catch (IOException err) {
                throw new TransportException("Cannot read " + this.objectsPath + "/" + path + ": " + err.getMessage(), err);
            }
            if (line == null) {
                throw new TransportException("Empty ref: " + name);
            }
            if (line.startsWith("ref: ")) {
                String p = line.substring("ref: ".length());
                Ref r = this.readRef(avail, "../" + p, p);
                if (r == null) {
                    r = avail.get(p);
                }
                if (r != null) {
                    r = new Ref(this.loose(r), name, r.getObjectId(), r.getPeeledObjectId(), true);
                    avail.put(name, r);
                }
                return r;
            }
            if (ObjectId.isId(line)) {
                Ref r = new Ref(this.loose(avail.get(name)), name, ObjectId.fromString(line));
                avail.put(r.getName(), r);
                return r;
            }
            throw new TransportException("Bad ref: " + name + ": " + line);
        }

        private Ref.Storage loose(Ref r) {
            if (r != null && r.getStorage() == Ref.Storage.PACKED) {
                return Ref.Storage.LOOSE_PACKED;
            }
            return Ref.Storage.LOOSE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void close() {
            if (this.ftp != null) {
                try {
                    if (this.ftp.isConnected()) {
                        this.ftp.disconnect();
                    }
                    Object var2_1 = null;
                    this.ftp = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    this.ftp = null;
                    throw throwable;
                }
            }
        }
    }
}

