/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.jgit.errors.NotSupportedException;
import org.eclipse.jgit.errors.PackProtocolException;
import org.eclipse.jgit.errors.TransportException;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.FetchConnection;
import org.eclipse.jgit.transport.HttpTransport;
import org.eclipse.jgit.transport.PushConnection;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.transport.WalkFetchConnection;
import org.eclipse.jgit.transport.WalkRemoteObjectDatabase;
import org.eclipse.jgit.transport.WalkTransport;
import org.eclipse.jgit.util.HttpSupport;

public class TransportHttp
extends HttpTransport
implements WalkTransport {
    private final URL baseUrl;
    private final URL objectsUrl;
    private final ProxySelector proxySelector;

    static boolean canHandle(URIish uri) {
        if (!uri.isRemote()) {
            return false;
        }
        String s = uri.getScheme();
        return "http".equals(s) || "https".equals(s) || "ftp".equals(s);
    }

    TransportHttp(Repository local, URIish uri) throws NotSupportedException {
        super(local, uri);
        try {
            String uriString = uri.toString();
            if (!uriString.endsWith("/")) {
                uriString = uriString + "/";
            }
            this.baseUrl = new URL(uriString);
            this.objectsUrl = new URL(this.baseUrl, "objects/");
        }
        catch (MalformedURLException e) {
            throw new NotSupportedException("Invalid URL " + uri, e);
        }
        this.proxySelector = ProxySelector.getDefault();
    }

    public FetchConnection openFetch() throws TransportException {
        HttpObjectDB c = new HttpObjectDB(this.objectsUrl);
        WalkFetchConnection r = new WalkFetchConnection(this, c);
        r.available(c.readAdvertisedRefs());
        return r;
    }

    public PushConnection openPush() throws NotSupportedException, TransportException {
        String s = this.getURI().getScheme();
        throw new NotSupportedException("Push not supported over " + s + ".");
    }

    public void close() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class HttpObjectDB
    extends WalkRemoteObjectDatabase {
        private final URL objectsUrl;

        HttpObjectDB(URL b) {
            this.objectsUrl = b;
        }

        @Override
        URIish getURI() {
            return new URIish(this.objectsUrl);
        }

        @Override
        Collection<WalkRemoteObjectDatabase> getAlternates() throws IOException {
            try {
                return this.readAlternates("info/http-alternates");
            }
            catch (FileNotFoundException err) {
                try {
                    return this.readAlternates("info/alternates");
                }
                catch (FileNotFoundException fileNotFoundException) {
                    return null;
                }
            }
        }

        @Override
        WalkRemoteObjectDatabase openAlternate(String location) throws IOException {
            return new HttpObjectDB(new URL(this.objectsUrl, location));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        Collection<String> getPackNames() throws IOException {
            ArrayList<String> arrayList;
            ArrayList<String> packs = new ArrayList<String>();
            BufferedReader br = this.openReader("info/packs");
            try {
                String s;
                while ((s = br.readLine()) != null && s.length() != 0) {
                    if (!s.startsWith("P pack-") || !s.endsWith(".pack")) {
                        throw this.invalidAdvertisement(s);
                    }
                    packs.add(s.substring(2));
                }
                arrayList = packs;
                {
                    Object var5_5 = null;
                }
            }
            catch (Throwable throwable) {
                try {
                    Object var5_6 = null;
                    br.close();
                    throw throwable;
                }
                catch (FileNotFoundException err) {
                    return packs;
                }
            }
            {
                br.close();
            }
            return arrayList;
        }

        @Override
        WalkRemoteObjectDatabase.FileStream open(String path) throws IOException {
            URL base = this.objectsUrl;
            URL u = new URL(base, path);
            Proxy proxy = HttpSupport.proxyFor(TransportHttp.this.proxySelector, u);
            HttpURLConnection c = (HttpURLConnection)u.openConnection(proxy);
            switch (HttpSupport.response(c)) {
                case 200: {
                    InputStream in = c.getInputStream();
                    int len = c.getContentLength();
                    return new WalkRemoteObjectDatabase.FileStream(in, len);
                }
                case 404: {
                    throw new FileNotFoundException(u.toString());
                }
            }
            throw new IOException(u.toString() + ": " + HttpSupport.response(c) + " " + c.getResponseMessage());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        Map<String, Ref> readAdvertisedRefs() throws TransportException {
            try {
                Map<String, Ref> map;
                BufferedReader br = this.openReader("../info/refs");
                try {
                    map = this.readAdvertisedImpl(br);
                    Object var4_5 = null;
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    br.close();
                    throw throwable;
                }
                br.close();
                return map;
            }
            catch (IOException err) {
                try {
                    throw new TransportException(new URL(this.objectsUrl, "../info/refs") + ": cannot read available refs", err);
                }
                catch (MalformedURLException mue) {
                    throw new TransportException(this.objectsUrl + "../info/refs" + ": cannot read available refs", err);
                }
            }
        }

        private Map<String, Ref> readAdvertisedImpl(BufferedReader br) throws IOException, PackProtocolException {
            String line;
            TreeMap<String, Ref> avail = new TreeMap<String, Ref>();
            while ((line = br.readLine()) != null) {
                Ref prior;
                int tab = line.indexOf(9);
                if (tab < 0) {
                    throw this.invalidAdvertisement(line);
                }
                String name = line.substring(tab + 1);
                ObjectId id = ObjectId.fromString(line.substring(0, tab));
                if (name.endsWith("^{}")) {
                    prior = avail.get(name = name.substring(0, name.length() - 3));
                    if (prior == null) {
                        throw this.outOfOrderAdvertisement(name);
                    }
                    if (prior.getPeeledObjectId() != null) {
                        throw this.duplicateAdvertisement(name + "^{}");
                    }
                    avail.put(name, new Ref(Ref.Storage.NETWORK, name, prior.getObjectId(), id, true));
                    continue;
                }
                prior = avail.put(name, new Ref(Ref.Storage.NETWORK, name, id));
                if (prior == null) continue;
                throw this.duplicateAdvertisement(name);
            }
            return avail;
        }

        private PackProtocolException outOfOrderAdvertisement(String n) {
            return new PackProtocolException("advertisement of " + n + "^{} came before " + n);
        }

        private PackProtocolException invalidAdvertisement(String n) {
            return new PackProtocolException("invalid advertisement of " + n);
        }

        private PackProtocolException duplicateAdvertisement(String n) {
            return new PackProtocolException("duplicate advertisements of " + n);
        }

        @Override
        void close() {
        }
    }
}

