/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSchException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import org.eclipse.jgit.errors.NoRemoteRepositoryException;
import org.eclipse.jgit.errors.TransportException;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.BasePackFetchConnection;
import org.eclipse.jgit.transport.BasePackPushConnection;
import org.eclipse.jgit.transport.FetchConnection;
import org.eclipse.jgit.transport.PackTransport;
import org.eclipse.jgit.transport.PushConnection;
import org.eclipse.jgit.transport.SshTransport;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.util.QuotedString;

public class TransportGitSsh
extends SshTransport
implements PackTransport {
    OutputStream errStream;

    static boolean canHandle(URIish uri) {
        if (!uri.isRemote()) {
            return false;
        }
        String scheme = uri.getScheme();
        if ("ssh".equals(scheme)) {
            return true;
        }
        if ("ssh+git".equals(scheme)) {
            return true;
        }
        if ("git+ssh".equals(scheme)) {
            return true;
        }
        return scheme == null && uri.getHost() != null && uri.getPath() != null;
    }

    TransportGitSsh(Repository local, URIish uri) {
        super(local, uri);
    }

    public FetchConnection openFetch() throws TransportException {
        return new SshFetchConnection();
    }

    public PushConnection openPush() throws TransportException {
        return new SshPushConnection();
    }

    private static void sqMinimal(StringBuilder cmd, String val) {
        if (val.matches("^[a-zA-Z0-9._/-]*$")) {
            cmd.append(val);
        } else {
            TransportGitSsh.sq(cmd, val);
        }
    }

    private static void sqAlways(StringBuilder cmd, String val) {
        TransportGitSsh.sq(cmd, val);
    }

    private static void sq(StringBuilder cmd, String val) {
        if (val.length() > 0) {
            cmd.append(QuotedString.BOURNE.quote(val));
        }
    }

    ChannelExec exec(String exe) throws TransportException {
        this.initSession();
        int tms = this.getTimeout() > 0 ? this.getTimeout() * 1000 : 0;
        try {
            ChannelExec channel = (ChannelExec)this.sock.openChannel("exec");
            String path = this.uri.getPath();
            if (this.uri.getScheme() != null && this.uri.getPath().startsWith("/~")) {
                path = this.uri.getPath().substring(1);
            }
            StringBuilder cmd = new StringBuilder();
            int gitspace = exe.indexOf("git ");
            if (gitspace >= 0) {
                TransportGitSsh.sqMinimal(cmd, exe.substring(0, gitspace + 3));
                cmd.append(' ');
                TransportGitSsh.sqMinimal(cmd, exe.substring(gitspace + 4));
            } else {
                TransportGitSsh.sqMinimal(cmd, exe);
            }
            cmd.append(' ');
            TransportGitSsh.sqAlways(cmd, path);
            channel.setCommand(cmd.toString());
            this.errStream = TransportGitSsh.createErrorStream();
            channel.setErrStream(this.errStream, true);
            channel.connect(tms);
            return channel;
        }
        catch (JSchException je) {
            throw new TransportException(this.uri, je.getMessage(), je);
        }
    }

    private static OutputStream createErrorStream() {
        return new OutputStream(){
            private StringBuilder all = new StringBuilder();
            private StringBuilder sb = new StringBuilder();

            public String toString() {
                String r = this.all.toString();
                while (r.endsWith("\n")) {
                    r = r.substring(0, r.length() - 1);
                }
                return r;
            }

            public void write(int b) throws IOException {
                if (b == 13) {
                    return;
                }
                this.sb.append((char)b);
                if (b == 10) {
                    this.all.append((CharSequence)this.sb);
                    this.sb.setLength(0);
                }
            }
        };
    }

    NoRemoteRepositoryException cleanNotFound(NoRemoteRepositoryException nf) {
        String why = this.errStream.toString();
        if (why == null || why.length() == 0) {
            return nf;
        }
        String path = this.uri.getPath();
        if (this.uri.getScheme() != null && this.uri.getPath().startsWith("/~")) {
            path = this.uri.getPath().substring(1);
        }
        StringBuilder pfx = new StringBuilder();
        pfx.append("fatal: ");
        TransportGitSsh.sqAlways(pfx, path);
        pfx.append(": ");
        if (why.startsWith(pfx.toString())) {
            why = why.substring(pfx.length());
        }
        return new NoRemoteRepositoryException(this.uri, why);
    }

    private OutputStream outputStream(ChannelExec channel) throws IOException {
        OutputStream out = channel.getOutputStream();
        if (this.getTimeout() <= 0) {
            return out;
        }
        PipedInputStream pipeIn = new PipedInputStream();
        final CopyThread copyThread = new CopyThread(pipeIn, out);
        PipedOutputStream pipeOut = new PipedOutputStream(pipeIn){

            public void flush() throws IOException {
                super.flush();
                copyThread.flush();
            }

            public void close() throws IOException {
                super.close();
                try {
                    copyThread.join(TransportGitSsh.this.getTimeout() * 1000);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        };
        copyThread.start();
        return pipeOut;
    }

    class SshPushConnection
    extends BasePackPushConnection {
        private ChannelExec channel;

        SshPushConnection() throws TransportException {
            super(TransportGitSsh.this);
            try {
                this.channel = TransportGitSsh.this.exec(TransportGitSsh.this.getOptionReceivePack());
                if (!this.channel.isConnected()) {
                    throw new TransportException(this.uri, TransportGitSsh.this.errStream.toString());
                }
                this.init(this.channel.getInputStream(), TransportGitSsh.this.outputStream(this.channel));
            }
            catch (TransportException err) {
                this.close();
                throw err;
            }
            catch (IOException err) {
                this.close();
                throw new TransportException(this.uri, "remote hung up unexpectedly", err);
            }
            try {
                this.readAdvertisedRefs();
            }
            catch (NoRemoteRepositoryException notFound) {
                throw TransportGitSsh.this.cleanNotFound(notFound);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            super.close();
            if (this.channel != null) {
                try {
                    if (this.channel.isConnected()) {
                        this.channel.disconnect();
                    }
                    Object var2_1 = null;
                    this.channel = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    this.channel = null;
                    throw throwable;
                }
            }
        }
    }

    class SshFetchConnection
    extends BasePackFetchConnection {
        private ChannelExec channel;

        SshFetchConnection() throws TransportException {
            super(TransportGitSsh.this);
            try {
                this.channel = TransportGitSsh.this.exec(TransportGitSsh.this.getOptionUploadPack());
                if (!this.channel.isConnected()) {
                    throw new TransportException(this.uri, TransportGitSsh.this.errStream.toString());
                }
                this.init(this.channel.getInputStream(), TransportGitSsh.this.outputStream(this.channel));
            }
            catch (TransportException err) {
                this.close();
                throw err;
            }
            catch (IOException err) {
                this.close();
                throw new TransportException(this.uri, "remote hung up unexpectedly", err);
            }
            try {
                this.readAdvertisedRefs();
            }
            catch (NoRemoteRepositoryException notFound) {
                throw TransportGitSsh.this.cleanNotFound(notFound);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            super.close();
            if (this.channel != null) {
                try {
                    if (this.channel.isConnected()) {
                        this.channel.disconnect();
                    }
                    Object var2_1 = null;
                    this.channel = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    this.channel = null;
                    throw throwable;
                }
            }
        }
    }

    private static class CopyThread
    extends Thread {
        private final InputStream src;
        private final OutputStream dst;
        private volatile boolean doFlush;

        CopyThread(InputStream i, OutputStream o) {
            this.setName(Thread.currentThread().getName() + "-Output");
            this.src = i;
            this.dst = o;
        }

        void flush() {
            if (!this.doFlush) {
                this.doFlush = true;
                this.interrupt();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                byte[] buf = new byte[1024];
                try {
                    while (true) {
                        int n;
                        if (this.doFlush) {
                            this.doFlush = false;
                            this.dst.flush();
                        }
                        try {
                            n = this.src.read(buf);
                        }
                        catch (InterruptedIOException wakey) {
                            continue;
                        }
                        if (n >= 0) {
                            this.dst.write(buf, 0, n);
                            continue;
                        }
                        break;
                    }
                }
                catch (IOException e) {
                }
                Object var5_5 = null;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                try {
                    this.src.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
                try {
                    this.dst.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                this.src.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            try {
                this.dst.close();
            }
            catch (IOException e) {}
        }
    }
}

