/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jgit.transport.OpenSshConfig;
import org.eclipse.jgit.transport.SshSessionFactory;
import org.eclipse.jgit.util.FS;

public abstract class SshConfigSessionFactory
extends SshSessionFactory {
    private final Map<String, JSch> byIdentityFile = new HashMap<String, JSch>();
    private JSch defaultJSch;
    private OpenSshConfig config;

    public synchronized Session getSession(String user, String pass, String host, int port) throws JSchException {
        String pauth;
        String strictHostKeyCheckingPolicy;
        OpenSshConfig.Host hc = this.getConfig().lookup(host);
        host = hc.getHostName();
        if (port <= 0) {
            port = hc.getPort();
        }
        if (user == null) {
            user = hc.getUser();
        }
        Session session = this.createSession(hc, user, host, port);
        if (pass != null) {
            session.setPassword(pass);
        }
        if ((strictHostKeyCheckingPolicy = hc.getStrictHostKeyChecking()) != null) {
            session.setConfig("StrictHostKeyChecking", strictHostKeyCheckingPolicy);
        }
        if ((pauth = hc.getPreferredAuthentications()) != null) {
            session.setConfig("PreferredAuthentications", pauth);
        }
        this.configure(hc, session);
        return session;
    }

    protected Session createSession(OpenSshConfig.Host hc, String user, String host, int port) throws JSchException {
        return this.getJSch(hc).getSession(user, host, port);
    }

    protected abstract void configure(OpenSshConfig.Host var1, Session var2);

    protected JSch getJSch(OpenSshConfig.Host hc) throws JSchException {
        JSch def = this.getDefaultJSch();
        File identityFile = hc.getIdentityFile();
        if (identityFile == null) {
            return def;
        }
        String identityKey = identityFile.getAbsolutePath();
        JSch jsch = this.byIdentityFile.get(identityKey);
        if (jsch == null) {
            jsch = new JSch();
            jsch.setHostKeyRepository(def.getHostKeyRepository());
            jsch.addIdentity(identityKey);
            this.byIdentityFile.put(identityKey, jsch);
        }
        return jsch;
    }

    private JSch getDefaultJSch() throws JSchException {
        if (this.defaultJSch == null) {
            this.defaultJSch = this.createDefaultJSch();
            for (Object name : this.defaultJSch.getIdentityNames()) {
                this.byIdentityFile.put((String)name, this.defaultJSch);
            }
        }
        return this.defaultJSch;
    }

    protected JSch createDefaultJSch() throws JSchException {
        JSch jsch = new JSch();
        SshConfigSessionFactory.knownHosts(jsch);
        SshConfigSessionFactory.identities(jsch);
        return jsch;
    }

    private OpenSshConfig getConfig() {
        if (this.config == null) {
            this.config = OpenSshConfig.get();
        }
        return this.config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void knownHosts(JSch sch) throws JSchException {
        File home = FS.userHome();
        if (home == null) {
            return;
        }
        File known_hosts = new File(new File(home, ".ssh"), "known_hosts");
        try {
            FileInputStream in = new FileInputStream(known_hosts);
            try {
                sch.setKnownHosts((InputStream)in);
            }
            finally {
                in.close();
            }
        }
        catch (FileNotFoundException none) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void identities(JSch sch) {
        File home = FS.userHome();
        if (home == null) {
            return;
        }
        File sshdir = new File(home, ".ssh");
        if (sshdir.isDirectory()) {
            SshConfigSessionFactory.loadIdentity(sch, new File(sshdir, "identity"));
            SshConfigSessionFactory.loadIdentity(sch, new File(sshdir, "id_rsa"));
            SshConfigSessionFactory.loadIdentity(sch, new File(sshdir, "id_dsa"));
        }
    }

    private static void loadIdentity(JSch sch, File priv) {
        if (priv.isFile()) {
            try {
                sch.addIdentity(priv.getAbsolutePath());
            }
            catch (JSchException jSchException) {
                // empty catch block
            }
        }
    }
}

