/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.io.IOException;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.jgit.lib.AlternateRepositoryDatabase;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectDatabase;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefComparator;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevFlag;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevTag;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.transport.PacketLineOut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RefAdvertiser {
    private final PacketLineOut pckOut;
    private final RevWalk walk;
    private final RevFlag ADVERTISED;
    private final StringBuilder tmpLine = new StringBuilder(100);
    private final char[] tmpId = new char[40];
    private final Set<String> capablities = new LinkedHashSet<String>();
    private boolean derefTags;
    private boolean first = true;

    RefAdvertiser(PacketLineOut out, RevWalk protoWalk, RevFlag advertisedFlag) {
        this.pckOut = out;
        this.walk = protoWalk;
        this.ADVERTISED = advertisedFlag;
    }

    void setDerefTags(boolean deref) {
        this.derefTags = deref;
    }

    void advertiseCapability(String name) {
        this.capablities.add(name);
    }

    void send(Collection<Ref> refs) throws IOException {
        for (Ref r : RefComparator.sort(refs)) {
            RevObject obj = this.parseAnyOrNull(r.getObjectId());
            if (obj == null) continue;
            this.advertiseAny(obj, r.getOrigName());
            if (!this.derefTags || !(obj instanceof RevTag)) continue;
            this.advertiseTag((RevTag)obj, r.getOrigName() + "^{}");
        }
    }

    void advertiseHave(AnyObjectId id) throws IOException {
        RevObject obj = this.parseAnyOrNull(id);
        if (obj != null) {
            this.advertiseAnyOnce(obj, ".have");
            if (obj instanceof RevTag) {
                this.advertiseAnyOnce(((RevTag)obj).getObject(), ".have");
            }
        }
    }

    void includeAdditionalHaves() throws IOException {
        this.additionalHaves(this.walk.getRepository().getObjectDatabase());
    }

    private void additionalHaves(ObjectDatabase db) throws IOException {
        if (db instanceof AlternateRepositoryDatabase) {
            this.additionalHaves(((AlternateRepositoryDatabase)db).getRepository());
        }
        for (ObjectDatabase alt : db.getAlternates()) {
            this.additionalHaves(alt);
        }
    }

    private void additionalHaves(Repository alt) throws IOException {
        for (Ref r : alt.getAllRefs().values()) {
            this.advertiseHave(r.getObjectId());
        }
    }

    boolean isEmpty() {
        return this.first;
    }

    private RevObject parseAnyOrNull(AnyObjectId id) {
        if (id == null) {
            return null;
        }
        try {
            return this.walk.parseAny(id);
        }
        catch (IOException e) {
            return null;
        }
    }

    private void advertiseAnyOnce(RevObject obj, String refName) throws IOException {
        if (!obj.has(this.ADVERTISED)) {
            this.advertiseAny(obj, refName);
        }
    }

    private void advertiseAny(RevObject obj, String refName) throws IOException {
        obj.add(this.ADVERTISED);
        this.advertiseId(obj, refName);
    }

    private void advertiseTag(RevTag tag, String refName) throws IOException {
        RevObject target;
        RevObject o = tag;
        do {
            target = o.getObject();
            try {
                this.walk.parseHeaders(target);
            }
            catch (IOException err) {
                return;
            }
            target.add(this.ADVERTISED);
        } while ((o = target) instanceof RevTag);
        this.advertiseAny(tag.getObject(), refName);
    }

    void advertiseId(AnyObjectId id, String refName) throws IOException {
        this.tmpLine.setLength(0);
        id.copyTo(this.tmpId, this.tmpLine);
        this.tmpLine.append(' ');
        this.tmpLine.append(refName);
        if (this.first) {
            this.first = false;
            if (!this.capablities.isEmpty()) {
                this.tmpLine.append('\u0000');
                for (String capName : this.capablities) {
                    this.tmpLine.append(' ');
                    this.tmpLine.append(capName);
                }
                this.tmpLine.append(' ');
            }
        }
        this.tmpLine.append('\n');
        this.pckOut.writeString(this.tmpLine.toString());
    }
}

