/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.jgit.errors.PackProtocolException;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.MutableObjectId;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.transport.SideBandInputStream;
import org.eclipse.jgit.util.IO;
import org.eclipse.jgit.util.RawParseUtils;

class PacketLineIn {
    static final String END = new String("");
    private final InputStream in;
    private final byte[] lenbuffer;

    PacketLineIn(InputStream i) {
        this.in = i;
        this.lenbuffer = new byte[4];
    }

    InputStream sideband(ProgressMonitor pm) {
        return new SideBandInputStream(this, this.in, pm);
    }

    AckNackResult readACK(MutableObjectId returnedId) throws IOException {
        String line = this.readString();
        if (line.length() == 0) {
            throw new PackProtocolException("Expected ACK/NAK, found EOF");
        }
        if ("NAK".equals(line)) {
            return AckNackResult.NAK;
        }
        if (line.startsWith("ACK ")) {
            returnedId.fromString(line.substring(4, 44));
            if (line.indexOf("continue", 44) != -1) {
                return AckNackResult.ACK_CONTINUE;
            }
            return AckNackResult.ACK;
        }
        throw new PackProtocolException("Expected ACK/NAK, got: " + line);
    }

    String readString() throws IOException {
        int len = this.readLength();
        if (len == 0) {
            return END;
        }
        if ((len -= 4) == 0) {
            return "";
        }
        byte[] raw = new byte[len];
        IO.readFully(this.in, raw, 0, len);
        if (raw[len - 1] == 10) {
            --len;
        }
        return RawParseUtils.decode(Constants.CHARSET, raw, 0, len);
    }

    String readStringRaw() throws IOException {
        int len = this.readLength();
        if (len == 0) {
            return END;
        }
        byte[] raw = new byte[len -= 4];
        IO.readFully(this.in, raw, 0, len);
        return RawParseUtils.decode(Constants.CHARSET, raw, 0, len);
    }

    int readLength() throws IOException {
        IO.readFully(this.in, this.lenbuffer, 0, 4);
        try {
            int len = RawParseUtils.parseHexInt16(this.lenbuffer, 0);
            if (len != 0 && len < 4) {
                throw new ArrayIndexOutOfBoundsException();
            }
            return len;
        }
        catch (ArrayIndexOutOfBoundsException err) {
            throw new IOException("Invalid packet line header: " + (char)this.lenbuffer[0] + (char)this.lenbuffer[1] + (char)this.lenbuffer[2] + (char)this.lenbuffer[3]);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum AckNackResult {
        NAK,
        ACK,
        ACK_CONTINUE;

    }
}

