/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.transport.TrackingRefUpdate;
import org.eclipse.jgit.transport.URIish;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OperationResult {
    Map<String, Ref> advertisedRefs = Collections.emptyMap();
    URIish uri;
    final SortedMap<String, TrackingRefUpdate> updates = new TreeMap<String, TrackingRefUpdate>();

    public URIish getURI() {
        return this.uri;
    }

    public Collection<Ref> getAdvertisedRefs() {
        return Collections.unmodifiableCollection(this.advertisedRefs.values());
    }

    public final Ref getAdvertisedRef(String name) {
        return this.advertisedRefs.get(name);
    }

    public Collection<TrackingRefUpdate> getTrackingRefUpdates() {
        return Collections.unmodifiableCollection(this.updates.values());
    }

    public TrackingRefUpdate getTrackingRefUpdate(String localName) {
        return (TrackingRefUpdate)this.updates.get(localName);
    }

    void setAdvertisedRefs(URIish u, Map<String, Ref> ar) {
        this.uri = u;
        this.advertisedRefs = ar;
    }

    void add(TrackingRefUpdate u) {
        this.updates.put(u.getLocalName(), u);
    }
}

