/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.PackWriter;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;

public class BundleWriter {
    private final PackWriter packWriter;
    private final Map<String, ObjectId> include;
    private final Set<RevCommit> assume;

    public BundleWriter(Repository repo, ProgressMonitor monitor) {
        this.packWriter = new PackWriter(repo, monitor);
        this.include = new TreeMap<String, ObjectId>();
        this.assume = new HashSet<RevCommit>();
    }

    public void include(String name, AnyObjectId id) {
        if (!Repository.isValidRefName(name)) {
            throw new IllegalArgumentException("Invalid ref name: " + name);
        }
        if (this.include.containsKey(name)) {
            throw new IllegalStateException("Duplicate ref: " + name);
        }
        this.include.put(name, id.toObjectId());
    }

    public void include(Ref r) {
        this.include(r.getName(), r.getObjectId());
    }

    public void assume(RevCommit c) {
        if (c != null) {
            this.assume.add(c);
        }
    }

    public void writeBundle(OutputStream os) throws IOException {
        if (!(os instanceof BufferedOutputStream)) {
            os = new BufferedOutputStream(os);
        }
        HashSet<ObjectId> inc = new HashSet<ObjectId>();
        HashSet<ObjectId> exc = new HashSet<ObjectId>();
        inc.addAll(this.include.values());
        for (RevCommit r : this.assume) {
            exc.add(r.getId());
        }
        this.packWriter.setThin(exc.size() > 0);
        this.packWriter.preparePack(inc, exc);
        OutputStreamWriter w = new OutputStreamWriter(os, Constants.CHARSET);
        w.write("# v2 git bundle");
        ((Writer)w).write(10);
        char[] tmp = new char[40];
        for (RevCommit revCommit : this.assume) {
            ((Writer)w).write(45);
            revCommit.copyTo(tmp, w);
            if (revCommit.getRawBuffer() != null) {
                ((Writer)w).write(32);
                w.write(revCommit.getShortMessage());
            }
            ((Writer)w).write(10);
        }
        for (Map.Entry entry : this.include.entrySet()) {
            ((ObjectId)entry.getValue()).copyTo(tmp, w);
            ((Writer)w).write(32);
            w.write((String)entry.getKey());
            ((Writer)w).write(10);
        }
        ((Writer)w).write(10);
        ((Writer)w).flush();
        this.packWriter.writePack(os);
    }
}

