/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Set;
import org.eclipse.jgit.errors.TransportException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.MutableObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.PackLock;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevCommitList;
import org.eclipse.jgit.revwalk.RevFlag;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevSort;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.filter.CommitTimeRevFilter;
import org.eclipse.jgit.revwalk.filter.RevFilter;
import org.eclipse.jgit.transport.BasePackConnection;
import org.eclipse.jgit.transport.FetchConnection;
import org.eclipse.jgit.transport.IndexPack;
import org.eclipse.jgit.transport.PackTransport;
import org.eclipse.jgit.transport.PacketLineIn;
import org.eclipse.jgit.transport.TagOpt;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class BasePackFetchConnection
extends BasePackConnection
implements FetchConnection {
    private static final int MAX_HAVES = 256;
    protected static final int MIN_CLIENT_BUFFER = 2952;
    static final String OPTION_INCLUDE_TAG = "include-tag";
    static final String OPTION_MULTI_ACK = "multi_ack";
    static final String OPTION_THIN_PACK = "thin-pack";
    static final String OPTION_SIDE_BAND = "side-band";
    static final String OPTION_SIDE_BAND_64K = "side-band-64k";
    static final String OPTION_OFS_DELTA = "ofs-delta";
    static final String OPTION_SHALLOW = "shallow";
    static final String OPTION_NO_PROGRESS = "no-progress";
    private final RevWalk walk;
    private RevCommitList<RevCommit> reachableCommits;
    final RevFlag REACHABLE;
    final RevFlag COMMON;
    final RevFlag ADVERTISED;
    private boolean multiAck;
    private boolean thinPack;
    private boolean sideband;
    private boolean includeTags;
    private boolean allowOfsDelta;
    private String lockMessage;
    private PackLock packLock;

    BasePackFetchConnection(PackTransport packTransport) {
        super(packTransport);
        FetchConfig cfg = this.local.getConfig().get(FetchConfig.KEY);
        this.includeTags = this.transport.getTagOpt() != TagOpt.NO_TAGS;
        this.thinPack = this.transport.isFetchThin();
        this.allowOfsDelta = cfg.allowOfsDelta;
        this.walk = new RevWalk(this.local);
        this.reachableCommits = new RevCommitList();
        this.REACHABLE = this.walk.newFlag("REACHABLE");
        this.COMMON = this.walk.newFlag("COMMON");
        this.ADVERTISED = this.walk.newFlag("ADVERTISED");
        this.walk.carry(this.COMMON);
        this.walk.carry(this.REACHABLE);
        this.walk.carry(this.ADVERTISED);
    }

    @Override
    public final void fetch(ProgressMonitor monitor, Collection<Ref> want, Set<ObjectId> have) throws TransportException {
        this.markStartedOperation();
        this.doFetch(monitor, want, have);
    }

    @Override
    public boolean didFetchIncludeTags() {
        return false;
    }

    @Override
    public boolean didFetchTestConnectivity() {
        return false;
    }

    @Override
    public void setPackLockMessage(String message) {
        this.lockMessage = message;
    }

    @Override
    public Collection<PackLock> getPackLocks() {
        if (this.packLock != null) {
            return Collections.singleton(this.packLock);
        }
        return Collections.emptyList();
    }

    protected void doFetch(ProgressMonitor monitor, Collection<Ref> want, Set<ObjectId> have) throws TransportException {
        try {
            this.markRefsAdvertised();
            this.markReachable(have, this.maxTimeWanted(want));
            if (this.sendWants(want)) {
                this.negotiate(monitor);
                this.walk.dispose();
                this.reachableCommits = null;
                this.receivePack(monitor);
            }
        }
        catch (CancelledException ce) {
            this.close();
            return;
        }
        catch (IOException err) {
            this.close();
            throw new TransportException(err.getMessage(), err);
        }
        catch (RuntimeException err) {
            this.close();
            throw new TransportException(err.getMessage(), err);
        }
    }

    private int maxTimeWanted(Collection<Ref> wants) {
        int maxTime = 0;
        for (Ref r : wants) {
            try {
                int cTime;
                RevObject obj = this.walk.parseAny(r.getObjectId());
                if (!(obj instanceof RevCommit) || maxTime >= (cTime = ((RevCommit)obj).getCommitTime())) continue;
                maxTime = cTime;
            }
            catch (IOException error) {}
        }
        return maxTime;
    }

    private void markReachable(Set<ObjectId> have, int maxTime) throws IOException {
        RevCommit o;
        for (Ref r : this.local.getAllRefs().values()) {
            try {
                o = this.walk.parseCommit(r.getObjectId());
                o.add(this.REACHABLE);
                this.reachableCommits.add(o);
            }
            catch (IOException readError) {}
        }
        for (ObjectId id : have) {
            try {
                o = this.walk.parseCommit(id);
                o.add(this.REACHABLE);
                this.reachableCommits.add(o);
            }
            catch (IOException readError) {}
        }
        if (maxTime > 0) {
            RevCommit c;
            Date maxWhen = new Date((long)maxTime * 1000L);
            this.walk.sort(RevSort.COMMIT_TIME_DESC);
            this.walk.markStart(this.reachableCommits);
            this.walk.setRevFilter(CommitTimeRevFilter.after(maxWhen));
            while ((c = this.walk.next()) != null) {
                if (!c.has(this.ADVERTISED) || c.has(this.COMMON)) continue;
                c.add(this.COMMON);
                c.carry(this.COMMON);
                this.reachableCommits.add(c);
            }
        }
    }

    private boolean sendWants(Collection<Ref> want) throws IOException {
        boolean first = true;
        for (Ref r : want) {
            try {
                if (this.walk.parseAny(r.getObjectId()).has(this.REACHABLE)) {
                    continue;
                }
            }
            catch (IOException err) {
                // empty catch block
            }
            StringBuilder line = new StringBuilder(46);
            line.append("want ");
            line.append(r.getObjectId().name());
            if (first) {
                line.append(this.enableCapabilities());
                first = false;
            }
            line.append('\n');
            this.pckOut.writeString(line.toString());
        }
        this.pckOut.end();
        this.outNeedsEnd = false;
        return !first;
    }

    private String enableCapabilities() {
        StringBuilder line = new StringBuilder();
        if (this.includeTags) {
            this.includeTags = this.wantCapability(line, OPTION_INCLUDE_TAG);
        }
        if (this.allowOfsDelta) {
            this.wantCapability(line, OPTION_OFS_DELTA);
        }
        this.multiAck = this.wantCapability(line, OPTION_MULTI_ACK);
        if (this.thinPack) {
            this.thinPack = this.wantCapability(line, OPTION_THIN_PACK);
        }
        if (this.wantCapability(line, OPTION_SIDE_BAND_64K)) {
            this.sideband = true;
        } else if (this.wantCapability(line, OPTION_SIDE_BAND)) {
            this.sideband = true;
        }
        return line.toString();
    }

    private void negotiate(ProgressMonitor monitor) throws IOException, CancelledException {
        RevCommit c;
        MutableObjectId ackId = new MutableObjectId();
        int resultsPending = 0;
        int havesSent = 0;
        int havesSinceLastContinue = 0;
        boolean receivedContinue = false;
        boolean receivedAck = false;
        boolean sendHaves = true;
        this.negotiateBegin();
        while (sendHaves && (c = this.walk.next()) != null) {
            block9: {
                this.pckOut.writeString("have " + c.getId().name() + "\n");
                ++havesSinceLastContinue;
                if ((0x1F & ++havesSent) != 0) continue;
                if (monitor.isCancelled()) {
                    throw new CancelledException();
                }
                this.pckOut.end();
                ++resultsPending;
                if (havesSent == 32) continue;
                do {
                    PacketLineIn.AckNackResult anr;
                    if ((anr = this.pckIn.readACK(ackId)) == PacketLineIn.AckNackResult.NAK) {
                        --resultsPending;
                        break block9;
                    }
                    if (anr == PacketLineIn.AckNackResult.ACK) {
                        this.multiAck = false;
                        resultsPending = 0;
                        receivedAck = true;
                        sendHaves = false;
                        break block9;
                    }
                    if (anr != PacketLineIn.AckNackResult.ACK_CONTINUE) continue;
                    this.markCommon(this.walk.parseAny(ackId));
                    receivedAck = true;
                    receivedContinue = true;
                    havesSinceLastContinue = 0;
                } while (!monitor.isCancelled());
                throw new CancelledException();
            }
            if (!receivedContinue || havesSinceLastContinue <= 256) continue;
            break;
        }
        if (monitor.isCancelled()) {
            throw new CancelledException();
        }
        this.pckOut.writeString("done\n");
        this.pckOut.flush();
        if (!receivedAck) {
            this.multiAck = false;
            ++resultsPending;
        }
        while (resultsPending > 0 || this.multiAck) {
            PacketLineIn.AckNackResult anr = this.pckIn.readACK(ackId);
            --resultsPending;
            if (anr == PacketLineIn.AckNackResult.ACK) break;
            if (anr == PacketLineIn.AckNackResult.ACK_CONTINUE) {
                this.multiAck = true;
            }
            if (!monitor.isCancelled()) continue;
            throw new CancelledException();
        }
    }

    private void negotiateBegin() throws IOException {
        this.walk.resetRetain(this.REACHABLE, this.ADVERTISED);
        this.walk.markStart(this.reachableCommits);
        this.walk.sort(RevSort.COMMIT_TIME_DESC);
        this.walk.setRevFilter(new RevFilter(){

            public RevFilter clone() {
                return this;
            }

            public boolean include(RevWalk walker, RevCommit c) {
                boolean remoteKnowsIsCommon = c.has(BasePackFetchConnection.this.COMMON);
                if (c.has(BasePackFetchConnection.this.ADVERTISED)) {
                    c.add(BasePackFetchConnection.this.COMMON);
                }
                return !remoteKnowsIsCommon;
            }
        });
    }

    private void markRefsAdvertised() {
        for (Ref r : this.getRefs()) {
            this.markAdvertised(r.getObjectId());
            if (r.getPeeledObjectId() == null) continue;
            this.markAdvertised(r.getPeeledObjectId());
        }
    }

    private void markAdvertised(AnyObjectId id) {
        try {
            this.walk.parseAny(id).add(this.ADVERTISED);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void markCommon(RevObject obj) {
        obj.add(this.COMMON);
        if (obj instanceof RevCommit) {
            ((RevCommit)obj).carry(this.COMMON);
        }
    }

    private void receivePack(ProgressMonitor monitor) throws IOException {
        IndexPack ip = IndexPack.create(this.local, this.sideband ? this.pckIn.sideband(monitor) : this.in);
        ip.setFixThin(this.thinPack);
        ip.setObjectChecking(this.transport.isCheckFetchedObjects());
        ip.index(monitor);
        this.packLock = ip.renameAndOpenPack(this.lockMessage);
    }

    private static class CancelledException
    extends Exception {
        private static final long serialVersionUID = 1L;

        private CancelledException() {
        }
    }

    private static class FetchConfig {
        static final Config.SectionParser<FetchConfig> KEY = new Config.SectionParser<FetchConfig>(){

            @Override
            public FetchConfig parse(Config cfg) {
                return new FetchConfig(cfg);
            }
        };
        final boolean allowOfsDelta;

        FetchConfig(Config c) {
            this.allowOfsDelta = c.getBoolean("repack", "usedeltabaseoffset", true);
        }
    }
}

