/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.revwalk;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.errors.RevWalkException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.MutableObjectId;
import org.eclipse.jgit.lib.ObjectIdSubclassMap;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.WindowCursor;
import org.eclipse.jgit.revwalk.AbstractRevQueue;
import org.eclipse.jgit.revwalk.DateRevQueue;
import org.eclipse.jgit.revwalk.FIFORevQueue;
import org.eclipse.jgit.revwalk.Generator;
import org.eclipse.jgit.revwalk.RevBlob;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevFlag;
import org.eclipse.jgit.revwalk.RevFlagSet;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevSort;
import org.eclipse.jgit.revwalk.RevTag;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.StartGenerator;
import org.eclipse.jgit.revwalk.filter.RevFilter;
import org.eclipse.jgit.treewalk.filter.TreeFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RevWalk
implements Iterable<RevCommit> {
    static final int PARSED = 1;
    static final int SEEN = 2;
    static final int UNINTERESTING = 4;
    static final int REWRITE = 8;
    static final int TEMP_MARK = 16;
    static final int TOPO_DELAY = 32;
    static final int RESERVED_FLAGS = 6;
    private static final int APP_FLAGS = -64;
    final Repository db;
    final WindowCursor curs;
    final MutableObjectId idBuffer;
    private final ObjectIdSubclassMap<RevObject> objects;
    private int freeFlags = -64;
    private int delayFreeFlags;
    int carryFlags = 4;
    private final ArrayList<RevCommit> roots;
    AbstractRevQueue queue;
    Generator pending;
    private final EnumSet<RevSort> sorting;
    private RevFilter filter;
    private TreeFilter treeFilter;
    private boolean retainBody;

    public RevWalk(Repository repo) {
        this.db = repo;
        this.curs = new WindowCursor();
        this.idBuffer = new MutableObjectId();
        this.objects = new ObjectIdSubclassMap();
        this.roots = new ArrayList();
        this.queue = new DateRevQueue();
        this.pending = new StartGenerator(this);
        this.sorting = EnumSet.of(RevSort.NONE);
        this.filter = RevFilter.ALL;
        this.treeFilter = TreeFilter.ALL;
        this.retainBody = true;
    }

    public Repository getRepository() {
        return this.db;
    }

    public void markStart(RevCommit c) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        if ((c.flags & 2) != 0) {
            return;
        }
        if ((c.flags & 1) == 0) {
            c.parseHeaders(this);
        }
        c.flags |= 2;
        this.roots.add(c);
        this.queue.add(c);
    }

    public void markStart(Collection<RevCommit> list) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        for (RevCommit c : list) {
            this.markStart(c);
        }
    }

    public void markUninteresting(RevCommit c) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        c.flags |= 4;
        this.carryFlagsImpl(c);
        this.markStart(c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isMergedInto(RevCommit base, RevCommit tip) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        RevFilter oldRF = this.filter;
        TreeFilter oldTF = this.treeFilter;
        try {
            this.finishDelayedFreeFlags();
            this.reset(~this.freeFlags & 0xFFFFFFC0);
            this.filter = RevFilter.MERGE_BASE;
            this.treeFilter = TreeFilter.ALL;
            this.markStart(tip);
            this.markStart(base);
            boolean bl = this.next() == base;
            return bl;
        }
        finally {
            this.filter = oldRF;
            this.treeFilter = oldTF;
        }
    }

    public RevCommit next() throws MissingObjectException, IncorrectObjectTypeException, IOException {
        return this.pending.next();
    }

    public EnumSet<RevSort> getRevSort() {
        return this.sorting.clone();
    }

    public boolean hasRevSort(RevSort sort) {
        return this.sorting.contains((Object)sort);
    }

    public void sort(RevSort s) {
        this.assertNotStarted();
        this.sorting.clear();
        this.sorting.add(s);
    }

    public void sort(RevSort s, boolean use) {
        this.assertNotStarted();
        if (use) {
            this.sorting.add(s);
        } else {
            this.sorting.remove((Object)s);
        }
        if (this.sorting.size() > 1) {
            this.sorting.remove((Object)RevSort.NONE);
        } else if (this.sorting.size() == 0) {
            this.sorting.add(RevSort.NONE);
        }
    }

    public RevFilter getRevFilter() {
        return this.filter;
    }

    public void setRevFilter(RevFilter newFilter) {
        this.assertNotStarted();
        this.filter = newFilter != null ? newFilter : RevFilter.ALL;
    }

    public TreeFilter getTreeFilter() {
        return this.treeFilter;
    }

    public void setTreeFilter(TreeFilter newFilter) {
        this.assertNotStarted();
        this.treeFilter = newFilter != null ? newFilter : TreeFilter.ALL;
    }

    public boolean isRetainBody() {
        return this.retainBody;
    }

    public void setRetainBody(boolean retain) {
        this.retainBody = retain;
    }

    public RevBlob lookupBlob(AnyObjectId id) {
        RevBlob c = (RevBlob)this.objects.get(id);
        if (c == null) {
            c = new RevBlob(id);
            this.objects.add(c);
        }
        return c;
    }

    public RevTree lookupTree(AnyObjectId id) {
        RevTree c = (RevTree)this.objects.get(id);
        if (c == null) {
            c = new RevTree(id);
            this.objects.add(c);
        }
        return c;
    }

    public RevCommit lookupCommit(AnyObjectId id) {
        RevCommit c = (RevCommit)this.objects.get(id);
        if (c == null) {
            c = this.createCommit(id);
            this.objects.add(c);
        }
        return c;
    }

    public RevObject lookupAny(AnyObjectId id, int type) {
        RevObject r = this.objects.get(id);
        if (r == null) {
            switch (type) {
                case 1: {
                    r = this.createCommit(id);
                    break;
                }
                case 2: {
                    r = new RevTree(id);
                    break;
                }
                case 3: {
                    r = new RevBlob(id);
                    break;
                }
                case 4: {
                    r = new RevTag(id);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("invalid git type: " + type);
                }
            }
            this.objects.add(r);
        }
        return r;
    }

    public RevCommit parseCommit(AnyObjectId id) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        RevObject c = this.parseAny(id);
        while (c instanceof RevTag) {
            c = ((RevTag)c).getObject();
            this.parseHeaders(c);
        }
        if (!(c instanceof RevCommit)) {
            throw new IncorrectObjectTypeException(id.toObjectId(), "commit");
        }
        return (RevCommit)c;
    }

    public RevTree parseTree(AnyObjectId id) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        RevTree t;
        RevObject c = this.parseAny(id);
        while (c instanceof RevTag) {
            c = ((RevTag)c).getObject();
            this.parseHeaders(c);
        }
        if (c instanceof RevCommit) {
            t = ((RevCommit)c).getTree();
        } else {
            if (!(c instanceof RevTree)) {
                throw new IncorrectObjectTypeException(id.toObjectId(), "tree");
            }
            t = (RevTree)c;
        }
        this.parseHeaders(t);
        return t;
    }

    public RevObject parseAny(AnyObjectId id) throws MissingObjectException, IOException {
        RevObject r = this.objects.get(id);
        if (r == null) {
            ObjectLoader ldr = this.db.openObject(this.curs, id);
            if (ldr == null) {
                throw new MissingObjectException(id.toObjectId(), "unknown");
            }
            byte[] data = ldr.getCachedBytes();
            int type = ldr.getType();
            switch (type) {
                case 1: {
                    RevCommit c = this.createCommit(id);
                    c.parseCanonical(this, data);
                    r = c;
                    break;
                }
                case 2: {
                    r = new RevTree(id);
                    r.flags |= 1;
                    break;
                }
                case 3: {
                    r = new RevBlob(id);
                    r.flags |= 1;
                    break;
                }
                case 4: {
                    RevTag t = new RevTag(id);
                    t.parseCanonical(this, data);
                    r = t;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Bad object type: " + type);
                }
            }
            this.objects.add(r);
        } else {
            this.parseHeaders(r);
        }
        return r;
    }

    public void parseHeaders(RevObject obj) throws MissingObjectException, IOException {
        if ((obj.flags & 1) == 0) {
            obj.parseHeaders(this);
        }
    }

    public void parseBody(RevObject obj) throws MissingObjectException, IOException {
        obj.parseBody(this);
    }

    public RevFlag newFlag(String name) {
        int m = this.allocFlag();
        return new RevFlag(this, name, m);
    }

    int allocFlag() {
        if (this.freeFlags == 0) {
            throw new IllegalArgumentException("26 flags already created.");
        }
        int m = Integer.lowestOneBit(this.freeFlags);
        this.freeFlags &= ~m;
        return m;
    }

    public void carry(RevFlag flag) {
        if ((this.freeFlags & flag.mask) != 0) {
            throw new IllegalArgumentException(flag.name + " is disposed.");
        }
        if (flag.walker != this) {
            throw new IllegalArgumentException(flag.name + " not from this.");
        }
        this.carryFlags |= flag.mask;
    }

    public void carry(Collection<RevFlag> set) {
        for (RevFlag flag : set) {
            this.carry(flag);
        }
    }

    public void disposeFlag(RevFlag flag) {
        this.freeFlag(flag.mask);
    }

    void freeFlag(int mask) {
        if (this.isNotStarted()) {
            this.freeFlags |= mask;
            this.carryFlags &= ~mask;
        } else {
            this.delayFreeFlags |= mask;
        }
    }

    private void finishDelayedFreeFlags() {
        if (this.delayFreeFlags != 0) {
            this.freeFlags |= this.delayFreeFlags;
            this.carryFlags &= ~this.delayFreeFlags;
            this.delayFreeFlags = 0;
        }
    }

    public final void reset() {
        this.reset(0);
    }

    public final void resetRetain(RevFlagSet retainFlags) {
        this.reset(retainFlags.mask);
    }

    public final void resetRetain(RevFlag ... retainFlags) {
        int mask = 0;
        for (RevFlag flag : retainFlags) {
            mask |= flag.mask;
        }
        this.reset(mask);
    }

    protected void reset(int retainFlags) {
        RevCommit c;
        this.finishDelayedFreeFlags();
        int clearFlags = ~(retainFlags |= 1);
        FIFORevQueue q = new FIFORevQueue();
        for (RevCommit c2 : this.roots) {
            if ((c2.flags & clearFlags) == 0) continue;
            c2.flags &= retainFlags;
            c2.reset();
            q.add(c2);
        }
        while ((c = q.next()) != null) {
            if (c.parents == null) continue;
            for (RevCommit p : c.parents) {
                if ((p.flags & clearFlags) == 0) continue;
                p.flags &= retainFlags;
                p.reset();
                q.add(p);
            }
        }
        this.curs.release();
        this.roots.clear();
        this.queue = new DateRevQueue();
        this.pending = new StartGenerator(this);
    }

    public void dispose() {
        this.freeFlags = -64;
        this.delayFreeFlags = 0;
        this.carryFlags = 4;
        this.objects.clear();
        this.curs.release();
        this.roots.clear();
        this.queue = new DateRevQueue();
        this.pending = new StartGenerator(this);
    }

    @Override
    public Iterator<RevCommit> iterator() {
        RevCommit first;
        try {
            first = this.next();
        }
        catch (MissingObjectException e) {
            throw new RevWalkException(e);
        }
        catch (IncorrectObjectTypeException e) {
            throw new RevWalkException(e);
        }
        catch (IOException e) {
            throw new RevWalkException(e);
        }
        return new Iterator<RevCommit>(){
            RevCommit next;
            {
                this.next = first;
            }

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public RevCommit next() {
                try {
                    RevCommit r = this.next;
                    this.next = RevWalk.this.next();
                    return r;
                }
                catch (MissingObjectException e) {
                    throw new RevWalkException(e);
                }
                catch (IncorrectObjectTypeException e) {
                    throw new RevWalkException(e);
                }
                catch (IOException e) {
                    throw new RevWalkException(e);
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    protected void assertNotStarted() {
        if (this.isNotStarted()) {
            return;
        }
        throw new IllegalStateException("Output has already been started.");
    }

    private boolean isNotStarted() {
        return this.pending instanceof StartGenerator;
    }

    protected RevCommit createCommit(AnyObjectId id) {
        return new RevCommit(id);
    }

    void carryFlagsImpl(RevCommit c) {
        int carry = c.flags & this.carryFlags;
        if (carry != 0) {
            RevCommit.carryFlags(c, carry);
        }
    }
}

