/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.revwalk;

import java.io.IOException;
import org.eclipse.jgit.errors.CorruptObjectException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.BlockObjQueue;
import org.eclipse.jgit.revwalk.RevBlob;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevSort;
import org.eclipse.jgit.revwalk.RevTag;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.CanonicalTreeParser;

public class ObjectWalk
extends RevWalk {
    private static final int IN_PENDING = 8;
    private CanonicalTreeParser treeWalk;
    private BlockObjQueue pendingObjects = new BlockObjQueue();
    private RevTree currentTree;
    private boolean fromTreeWalk;
    private RevTree nextSubtree;

    public ObjectWalk(Repository repo) {
        super(repo);
        this.treeWalk = new CanonicalTreeParser();
    }

    public void markStart(RevObject o) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        while (o instanceof RevTag) {
            this.addObject(o);
            o = ((RevTag)o).getObject();
            this.parseHeaders(o);
        }
        if (o instanceof RevCommit) {
            super.markStart((RevCommit)o);
        } else {
            this.addObject(o);
        }
    }

    public void markUninteresting(RevObject o) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        while (o instanceof RevTag) {
            o.flags |= 4;
            if (this.hasRevSort(RevSort.BOUNDARY)) {
                this.addObject(o);
            }
            o = ((RevTag)o).getObject();
            this.parseHeaders(o);
        }
        if (o instanceof RevCommit) {
            super.markUninteresting((RevCommit)o);
        } else if (o instanceof RevTree) {
            this.markTreeUninteresting((RevTree)o);
        } else {
            o.flags |= 4;
        }
        if (o.getType() != 1 && this.hasRevSort(RevSort.BOUNDARY)) {
            this.addObject(o);
        }
    }

    public RevCommit next() throws MissingObjectException, IncorrectObjectTypeException, IOException {
        RevCommit r;
        block2: {
            do {
                if ((r = super.next()) == null) {
                    return null;
                }
                if ((r.flags & 4) == 0) break block2;
                this.markTreeUninteresting(r.getTree());
            } while (!this.hasRevSort(RevSort.BOUNDARY));
            this.pendingObjects.add(r.getTree());
            return r;
        }
        this.pendingObjects.add(r.getTree());
        return r;
    }

    public RevObject nextObject() throws MissingObjectException, IncorrectObjectTypeException, IOException {
        RevObject o;
        this.fromTreeWalk = false;
        if (this.nextSubtree != null) {
            this.treeWalk = this.treeWalk.createSubtreeIterator0(this.db, this.nextSubtree, this.curs);
            this.nextSubtree = null;
        }
        while (!this.treeWalk.eof()) {
            FileMode mode = this.treeWalk.getEntryFileMode();
            int sType = mode.getObjectType();
            switch (sType) {
                case 3: {
                    this.treeWalk.getEntryObjectId(this.idBuffer);
                    RevObject o2 = this.lookupBlob(this.idBuffer);
                    if ((o2.flags & 2) != 0) break;
                    o2.flags |= 2;
                    if (this.shouldSkipObject(o2)) break;
                    this.fromTreeWalk = true;
                    return o2;
                }
                case 2: {
                    this.treeWalk.getEntryObjectId(this.idBuffer);
                    RevObject o2 = this.lookupTree(this.idBuffer);
                    if ((((RevTree)o2).flags & 2) != 0) break;
                    ((RevTree)o2).flags |= 2;
                    if (this.shouldSkipObject(o2)) break;
                    this.nextSubtree = o2;
                    this.fromTreeWalk = true;
                    return o2;
                }
                default: {
                    if (FileMode.GITLINK.equals(mode)) break;
                    this.treeWalk.getEntryObjectId(this.idBuffer);
                    throw new CorruptObjectException("Invalid mode " + mode + " for " + this.idBuffer.name() + " " + this.treeWalk.getEntryPathString() + " in " + this.currentTree + ".");
                }
            }
            this.treeWalk = this.treeWalk.next();
        }
        while (true) {
            if ((o = this.pendingObjects.next()) == null) {
                return null;
            }
            if ((o.flags & 2) != 0) continue;
            o.flags |= 2;
            if (!this.shouldSkipObject(o)) break;
        }
        if (o instanceof RevTree) {
            this.currentTree = (RevTree)o;
            this.treeWalk = this.treeWalk.resetRoot(this.db, this.currentTree, this.curs);
        }
        return o;
    }

    private final boolean shouldSkipObject(RevObject o) {
        return (o.flags & 4) != 0 && !this.hasRevSort(RevSort.BOUNDARY);
    }

    public void checkConnectivity() throws MissingObjectException, IncorrectObjectTypeException, IOException {
        RevObject o;
        RevCommit c;
        while ((c = this.next()) != null) {
        }
        while ((o = this.nextObject()) != null) {
            if (!(o instanceof RevBlob) || this.db.hasObject(o)) continue;
            throw new MissingObjectException((ObjectId)o, "blob");
        }
    }

    public String getPathString() {
        return this.fromTreeWalk ? this.treeWalk.getEntryPathString() : null;
    }

    public void dispose() {
        super.dispose();
        this.pendingObjects = new BlockObjQueue();
        this.nextSubtree = null;
        this.currentTree = null;
    }

    protected void reset(int retainFlags) {
        super.reset(retainFlags);
        this.pendingObjects = new BlockObjQueue();
        this.nextSubtree = null;
    }

    private void addObject(RevObject o) {
        if ((o.flags & 8) == 0) {
            o.flags |= 8;
            this.pendingObjects.add(o);
        }
    }

    private void markTreeUninteresting(RevTree tree) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        if ((tree.flags & 4) != 0) {
            return;
        }
        tree.flags |= 4;
        this.treeWalk = this.treeWalk.resetRoot(this.db, tree, this.curs);
        block4: while (!this.treeWalk.eof()) {
            FileMode mode = this.treeWalk.getEntryFileMode();
            int sType = mode.getObjectType();
            switch (sType) {
                case 3: {
                    this.treeWalk.getEntryObjectId(this.idBuffer);
                    this.lookupBlob((AnyObjectId)this.idBuffer).flags |= 4;
                    break;
                }
                case 2: {
                    this.treeWalk.getEntryObjectId(this.idBuffer);
                    RevTree t = this.lookupTree(this.idBuffer);
                    if ((t.flags & 4) != 0) break;
                    t.flags |= 4;
                    this.treeWalk = this.treeWalk.createSubtreeIterator0(this.db, t, this.curs);
                    continue block4;
                }
                default: {
                    if (FileMode.GITLINK.equals(mode)) break;
                    this.treeWalk.getEntryObjectId(this.idBuffer);
                    throw new CorruptObjectException("Invalid mode " + mode + " for " + this.idBuffer.name() + " " + this.treeWalk.getEntryPathString() + " in " + tree + ".");
                }
            }
            this.treeWalk = this.treeWalk.next();
        }
    }
}

