/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.revplot;

import java.util.Collection;
import java.util.HashSet;
import java.util.TreeSet;
import org.eclipse.jgit.revplot.PlotCommit;
import org.eclipse.jgit.revplot.PlotLane;
import org.eclipse.jgit.revplot.PlotWalk;
import org.eclipse.jgit.revwalk.RevCommitList;
import org.eclipse.jgit.revwalk.RevWalk;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlotCommitList<L extends PlotLane>
extends RevCommitList<PlotCommit<L>> {
    static final int MAX_LENGTH = 25;
    private int lanesAllocated;
    private final TreeSet<Integer> freeLanes = new TreeSet();
    private final HashSet<PlotLane> activeLanes = new HashSet(32);

    @Override
    public void clear() {
        super.clear();
        this.lanesAllocated = 0;
        this.freeLanes.clear();
        this.activeLanes.clear();
    }

    @Override
    public void source(RevWalk w) {
        if (!(w instanceof PlotWalk)) {
            throw new ClassCastException("Not a " + PlotWalk.class.getName());
        }
        super.source(w);
    }

    public void findPassingThrough(PlotCommit<L> currCommit, Collection<L> result) {
        for (PlotLane p : currCommit.passingLanes) {
            result.add(p);
        }
    }

    @Override
    protected void enter(int index, PlotCommit<L> currCommit) {
        this.setupChildren(currCommit);
        int nChildren = currCommit.getChildCount();
        if (nChildren == 0) {
            return;
        }
        if (nChildren == 1 && currCommit.children[0].getParentCount() < 2) {
            PlotCommit rObj;
            PlotCommit c = currCommit.children[0];
            if (c.lane == null) {
                c.lane = this.nextFreeLane();
                this.activeLanes.add(c.lane);
            }
            for (int r = index - 1; r >= 0 && (rObj = (PlotCommit)this.get(r)) != c; --r) {
                rObj.addPassingLane(c.lane);
            }
            currCommit.lane = c.lane;
            currCommit.lane.parent = currCommit;
        } else {
            PlotCommit rObj;
            for (int i = 0; i < nChildren; ++i) {
                PlotCommit c = currCommit.children[i];
                if (!this.activeLanes.remove(c.lane)) continue;
                this.recycleLane(c.lane);
                this.freeLanes.add(c.lane.getPosition());
            }
            currCommit.lane = this.nextFreeLane();
            currCommit.lane.parent = currCommit;
            this.activeLanes.add(currCommit.lane);
            int remaining = nChildren;
            for (int r = index - 1; !(r < 0 || currCommit.isChild(rObj = (PlotCommit)this.get(r)) && --remaining == 0); --r) {
                rObj.addPassingLane(currCommit.lane);
            }
        }
    }

    private void setupChildren(PlotCommit<L> currCommit) {
        int nParents = currCommit.getParentCount();
        for (int i = 0; i < nParents; ++i) {
            ((PlotCommit)currCommit.getParent(i)).addChild(currCommit);
        }
    }

    private PlotLane nextFreeLane() {
        L p = this.createLane();
        if (this.freeLanes.isEmpty()) {
            ((PlotLane)p).position = this.lanesAllocated++;
        } else {
            Integer min = this.freeLanes.first();
            ((PlotLane)p).position = min;
            this.freeLanes.remove(min);
        }
        return p;
    }

    protected L createLane() {
        return (L)new PlotLane();
    }

    protected void recycleLane(L lane) {
    }
}

