/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.patch;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jgit.diff.EditList;
import org.eclipse.jgit.lib.AbbreviatedObjectId;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.patch.BinaryHunk;
import org.eclipse.jgit.patch.HunkHeader;
import org.eclipse.jgit.util.QuotedString;
import org.eclipse.jgit.util.RawParseUtils;
import org.eclipse.jgit.util.TemporaryBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileHeader {
    public static final String DEV_NULL = "/dev/null";
    private static final byte[] OLD_MODE = Constants.encodeASCII("old mode ");
    private static final byte[] NEW_MODE = Constants.encodeASCII("new mode ");
    static final byte[] DELETED_FILE_MODE = Constants.encodeASCII("deleted file mode ");
    static final byte[] NEW_FILE_MODE = Constants.encodeASCII("new file mode ");
    private static final byte[] COPY_FROM = Constants.encodeASCII("copy from ");
    private static final byte[] COPY_TO = Constants.encodeASCII("copy to ");
    private static final byte[] RENAME_OLD = Constants.encodeASCII("rename old ");
    private static final byte[] RENAME_NEW = Constants.encodeASCII("rename new ");
    private static final byte[] RENAME_FROM = Constants.encodeASCII("rename from ");
    private static final byte[] RENAME_TO = Constants.encodeASCII("rename to ");
    private static final byte[] SIMILARITY_INDEX = Constants.encodeASCII("similarity index ");
    private static final byte[] DISSIMILARITY_INDEX = Constants.encodeASCII("dissimilarity index ");
    static final byte[] INDEX = Constants.encodeASCII("index ");
    static final byte[] OLD_NAME = Constants.encodeASCII("--- ");
    static final byte[] NEW_NAME = Constants.encodeASCII("+++ ");
    final byte[] buf;
    final int startOffset;
    int endOffset;
    private String oldName;
    private String newName;
    private FileMode oldMode;
    protected FileMode newMode;
    protected ChangeType changeType;
    private int score;
    private AbbreviatedObjectId oldId;
    protected AbbreviatedObjectId newId;
    PatchType patchType;
    private List<HunkHeader> hunks;
    BinaryHunk forwardBinaryHunk;
    BinaryHunk reverseBinaryHunk;

    FileHeader(byte[] b, int offset) {
        this.buf = b;
        this.startOffset = offset;
        this.changeType = ChangeType.MODIFY;
        this.patchType = PatchType.UNIFIED;
    }

    int getParentCount() {
        return 1;
    }

    public byte[] getBuffer() {
        return this.buf;
    }

    public int getStartOffset() {
        return this.startOffset;
    }

    public int getEndOffset() {
        return this.endOffset;
    }

    public String getScriptText() {
        return this.getScriptText(null, null);
    }

    public String getScriptText(Charset oldCharset, Charset newCharset) {
        return this.getScriptText(new Charset[]{oldCharset, newCharset});
    }

    String getScriptText(Charset[] charsetGuess) {
        if (this.getHunks().isEmpty()) {
            return RawParseUtils.extractBinaryString(this.buf, this.startOffset, this.endOffset);
        }
        if (charsetGuess != null && charsetGuess.length != this.getParentCount() + 1) {
            throw new IllegalArgumentException("Expected " + (this.getParentCount() + 1) + " character encoding guesses");
        }
        if (FileHeader.trySimpleConversion(charsetGuess)) {
            Charset cs;
            Charset charset = cs = charsetGuess != null ? charsetGuess[0] : null;
            if (cs == null) {
                cs = Constants.CHARSET;
            }
            try {
                return RawParseUtils.decodeNoFallback(cs, this.buf, this.startOffset, this.endOffset);
            }
            catch (CharacterCodingException cee) {
                // empty catch block
            }
        }
        StringBuilder r = new StringBuilder(this.endOffset - this.startOffset);
        int hdrEnd = this.getHunks().get(0).getStartOffset();
        int ptr = this.startOffset;
        while (ptr < hdrEnd) {
            int eol = Math.min(hdrEnd, RawParseUtils.nextLF(this.buf, ptr));
            r.append(RawParseUtils.extractBinaryString(this.buf, ptr, eol));
            ptr = eol;
        }
        String[] files = this.extractFileLines(charsetGuess);
        int[] offsets = new int[files.length];
        for (HunkHeader hunkHeader : this.getHunks()) {
            hunkHeader.extractFileLines(r, files, offsets);
        }
        return r.toString();
    }

    private static boolean trySimpleConversion(Charset[] charsetGuess) {
        if (charsetGuess == null) {
            return true;
        }
        for (int i = 1; i < charsetGuess.length; ++i) {
            if (charsetGuess[i] == charsetGuess[0]) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private String[] extractFileLines(Charset[] csGuess) {
        OutputStream[] tmp = new TemporaryBuffer[this.getParentCount() + 1];
        try {
            void stringArray;
            for (int i = 0; i < tmp.length; ++i) {
                tmp[i] = new TemporaryBuffer();
            }
            for (HunkHeader hunkHeader : this.getHunks()) {
                hunkHeader.extractFileLines(tmp);
            }
            String[] r = new String[tmp.length];
            boolean bl = false;
            while (stringArray < tmp.length) {
                Charset cs;
                Charset charset = cs = csGuess != null ? csGuess[stringArray] : null;
                if (cs == null) {
                    cs = Constants.CHARSET;
                }
                r[stringArray] = RawParseUtils.decode(cs, ((TemporaryBuffer)tmp[stringArray]).toByteArray());
                ++stringArray;
            }
            String[] stringArray2 = r;
            return stringArray2;
        }
        catch (IOException ioe) {
            throw new RuntimeException("Cannot convert script to text", ioe);
        }
        finally {
            for (TemporaryBuffer temporaryBuffer : tmp) {
                if (temporaryBuffer == null) continue;
                temporaryBuffer.destroy();
            }
        }
    }

    public String getOldName() {
        return this.oldName;
    }

    public String getNewName() {
        return this.newName;
    }

    public FileMode getOldMode() {
        return this.oldMode;
    }

    public FileMode getNewMode() {
        return this.newMode;
    }

    public ChangeType getChangeType() {
        return this.changeType;
    }

    public int getScore() {
        return this.score;
    }

    public AbbreviatedObjectId getOldId() {
        return this.oldId;
    }

    public AbbreviatedObjectId getNewId() {
        return this.newId;
    }

    public PatchType getPatchType() {
        return this.patchType;
    }

    public boolean hasMetaDataChanges() {
        return this.changeType != ChangeType.MODIFY || this.newMode != this.oldMode;
    }

    public List<? extends HunkHeader> getHunks() {
        if (this.hunks == null) {
            return Collections.emptyList();
        }
        return this.hunks;
    }

    void addHunk(HunkHeader h) {
        if (h.getFileHeader() != this) {
            throw new IllegalArgumentException("Hunk belongs to another file");
        }
        if (this.hunks == null) {
            this.hunks = new ArrayList<HunkHeader>();
        }
        this.hunks.add(h);
    }

    HunkHeader newHunkHeader(int offset) {
        return new HunkHeader(this, offset);
    }

    public BinaryHunk getForwardBinaryHunk() {
        return this.forwardBinaryHunk;
    }

    public BinaryHunk getReverseBinaryHunk() {
        return this.reverseBinaryHunk;
    }

    public EditList toEditList() {
        EditList r = new EditList();
        for (HunkHeader hunk : this.hunks) {
            r.addAll(hunk.toEditList());
        }
        return r;
    }

    int parseGitFileName(int ptr, int end) {
        int eol = RawParseUtils.nextLF(this.buf, ptr);
        int bol = ptr;
        if (eol >= end) {
            return -1;
        }
        int aStart = RawParseUtils.nextLF(this.buf, ptr, '/');
        if (aStart >= eol) {
            return eol;
        }
        while (ptr < eol) {
            int sp = RawParseUtils.nextLF(this.buf, ptr, ' ');
            if (sp >= eol) {
                return eol;
            }
            int bStart = RawParseUtils.nextLF(this.buf, sp, '/');
            if (bStart >= eol) {
                return eol;
            }
            if (this.eq(aStart, sp - 1, bStart, eol - 1)) {
                if (this.buf[bol] == 34) {
                    if (this.buf[sp - 2] != 34) {
                        return eol;
                    }
                    this.oldName = QuotedString.GIT_PATH.dequote(this.buf, bol, sp - 1);
                    this.oldName = FileHeader.p1(this.oldName);
                } else {
                    this.oldName = RawParseUtils.decode(Constants.CHARSET, this.buf, aStart, sp - 1);
                }
                this.newName = this.oldName;
                return eol;
            }
            ptr = sp;
        }
        return eol;
    }

    int parseGitHeaders(int ptr, int end) {
        int eol;
        while (ptr < end && FileHeader.isHunkHdr(this.buf, ptr, eol = RawParseUtils.nextLF(this.buf, ptr)) < 1) {
            if (RawParseUtils.match(this.buf, ptr, OLD_NAME) >= 0) {
                this.parseOldName(ptr, eol);
            } else if (RawParseUtils.match(this.buf, ptr, NEW_NAME) >= 0) {
                this.parseNewName(ptr, eol);
            } else if (RawParseUtils.match(this.buf, ptr, OLD_MODE) >= 0) {
                this.oldMode = this.parseFileMode(ptr + OLD_MODE.length, eol);
            } else if (RawParseUtils.match(this.buf, ptr, NEW_MODE) >= 0) {
                this.newMode = this.parseFileMode(ptr + NEW_MODE.length, eol);
            } else if (RawParseUtils.match(this.buf, ptr, DELETED_FILE_MODE) >= 0) {
                this.oldMode = this.parseFileMode(ptr + DELETED_FILE_MODE.length, eol);
                this.newMode = FileMode.MISSING;
                this.changeType = ChangeType.DELETE;
            } else if (RawParseUtils.match(this.buf, ptr, NEW_FILE_MODE) >= 0) {
                this.parseNewFileMode(ptr, eol);
            } else if (RawParseUtils.match(this.buf, ptr, COPY_FROM) >= 0) {
                this.oldName = this.parseName(this.oldName, ptr + COPY_FROM.length, eol);
                this.changeType = ChangeType.COPY;
            } else if (RawParseUtils.match(this.buf, ptr, COPY_TO) >= 0) {
                this.newName = this.parseName(this.newName, ptr + COPY_TO.length, eol);
                this.changeType = ChangeType.COPY;
            } else if (RawParseUtils.match(this.buf, ptr, RENAME_OLD) >= 0) {
                this.oldName = this.parseName(this.oldName, ptr + RENAME_OLD.length, eol);
                this.changeType = ChangeType.RENAME;
            } else if (RawParseUtils.match(this.buf, ptr, RENAME_NEW) >= 0) {
                this.newName = this.parseName(this.newName, ptr + RENAME_NEW.length, eol);
                this.changeType = ChangeType.RENAME;
            } else if (RawParseUtils.match(this.buf, ptr, RENAME_FROM) >= 0) {
                this.oldName = this.parseName(this.oldName, ptr + RENAME_FROM.length, eol);
                this.changeType = ChangeType.RENAME;
            } else if (RawParseUtils.match(this.buf, ptr, RENAME_TO) >= 0) {
                this.newName = this.parseName(this.newName, ptr + RENAME_TO.length, eol);
                this.changeType = ChangeType.RENAME;
            } else if (RawParseUtils.match(this.buf, ptr, SIMILARITY_INDEX) >= 0) {
                this.score = RawParseUtils.parseBase10(this.buf, ptr + SIMILARITY_INDEX.length, null);
            } else if (RawParseUtils.match(this.buf, ptr, DISSIMILARITY_INDEX) >= 0) {
                this.score = RawParseUtils.parseBase10(this.buf, ptr + DISSIMILARITY_INDEX.length, null);
            } else {
                if (RawParseUtils.match(this.buf, ptr, INDEX) < 0) break;
                this.parseIndexLine(ptr + INDEX.length, eol);
            }
            ptr = eol;
        }
        return ptr;
    }

    void parseOldName(int ptr, int eol) {
        this.oldName = FileHeader.p1(this.parseName(this.oldName, ptr + OLD_NAME.length, eol));
        if (this.oldName == DEV_NULL) {
            this.changeType = ChangeType.ADD;
        }
    }

    void parseNewName(int ptr, int eol) {
        this.newName = FileHeader.p1(this.parseName(this.newName, ptr + NEW_NAME.length, eol));
        if (this.newName == DEV_NULL) {
            this.changeType = ChangeType.DELETE;
        }
    }

    void parseNewFileMode(int ptr, int eol) {
        this.oldMode = FileMode.MISSING;
        this.newMode = this.parseFileMode(ptr + NEW_FILE_MODE.length, eol);
        this.changeType = ChangeType.ADD;
    }

    int parseTraditionalHeaders(int ptr, int end) {
        int eol;
        while (ptr < end && FileHeader.isHunkHdr(this.buf, ptr, eol = RawParseUtils.nextLF(this.buf, ptr)) < 1) {
            if (RawParseUtils.match(this.buf, ptr, OLD_NAME) >= 0) {
                this.parseOldName(ptr, eol);
            } else {
                if (RawParseUtils.match(this.buf, ptr, NEW_NAME) < 0) break;
                this.parseNewName(ptr, eol);
            }
            ptr = eol;
        }
        return ptr;
    }

    private String parseName(String expect, int ptr, int end) {
        String r;
        if (ptr == end) {
            return expect;
        }
        if (this.buf[ptr] == 34) {
            r = QuotedString.GIT_PATH.dequote(this.buf, ptr, end - 1);
        } else {
            int tab;
            for (tab = end; ptr < tab && this.buf[tab - 1] != 9; --tab) {
            }
            if (ptr == tab) {
                tab = end;
            }
            r = RawParseUtils.decode(Constants.CHARSET, this.buf, ptr, tab - 1);
        }
        if (r.equals(DEV_NULL)) {
            r = DEV_NULL;
        }
        return r;
    }

    private static String p1(String r) {
        int s = r.indexOf(47);
        return s > 0 ? r.substring(s + 1) : r;
    }

    FileMode parseFileMode(int ptr, int end) {
        int tmp = 0;
        while (ptr < end - 1) {
            tmp <<= 3;
            tmp += this.buf[ptr++] - 48;
        }
        return FileMode.fromBits(tmp);
    }

    void parseIndexLine(int ptr, int end) {
        int dot2 = RawParseUtils.nextLF(this.buf, ptr, '.');
        int mode = RawParseUtils.nextLF(this.buf, dot2, ' ');
        this.oldId = AbbreviatedObjectId.fromString(this.buf, ptr, dot2 - 1);
        this.newId = AbbreviatedObjectId.fromString(this.buf, dot2 + 1, mode - 1);
        if (mode < end) {
            this.newMode = this.oldMode = this.parseFileMode(mode, end);
        }
    }

    private boolean eq(int aPtr, int aEnd, int bPtr, int bEnd) {
        if (aEnd - aPtr != bEnd - bPtr) {
            return false;
        }
        while (aPtr < aEnd) {
            if (this.buf[aPtr++] == this.buf[bPtr++]) continue;
            return false;
        }
        return true;
    }

    static int isHunkHdr(byte[] buf, int start, int end) {
        int ptr;
        for (ptr = start; ptr < end && buf[ptr] == 64; ++ptr) {
        }
        if (ptr - start < 2) {
            return 0;
        }
        if (ptr == end || buf[ptr++] != 32) {
            return 0;
        }
        if (ptr == end || buf[ptr++] != 45) {
            return 0;
        }
        return ptr - 3 - start;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PatchType {
        UNIFIED,
        BINARY,
        GIT_BINARY;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ChangeType {
        ADD,
        MODIFY,
        DELETE,
        RENAME,
        COPY;

    }
}

