/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import java.io.File;
import java.io.IOException;
import org.eclipse.jgit.errors.GitlinksNotSupportedException;
import org.eclipse.jgit.errors.SymlinksNotSupportedException;
import org.eclipse.jgit.lib.FileTreeEntry;
import org.eclipse.jgit.lib.GitlinkTreeEntry;
import org.eclipse.jgit.lib.ObjectWriter;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.SymlinkTreeEntry;
import org.eclipse.jgit.lib.Tree;
import org.eclipse.jgit.lib.TreeVisitorWithCurrentDirectory;

public class WriteTree
extends TreeVisitorWithCurrentDirectory {
    private final ObjectWriter ow;

    public WriteTree(File sourceDirectory, Repository db) {
        super(sourceDirectory);
        this.ow = new ObjectWriter(db);
    }

    public void visitFile(FileTreeEntry f) throws IOException {
        f.setId(this.ow.writeBlob(new File(this.getCurrentDirectory(), f.getName())));
    }

    public void visitSymlink(SymlinkTreeEntry s) throws IOException {
        if (s.isModified()) {
            throw new SymlinksNotSupportedException("Symlink \"" + s.getFullName() + "\" cannot be written as the link target" + " cannot be read from within Java.");
        }
    }

    public void endVisitTree(Tree t) throws IOException {
        super.endVisitTree(t);
        t.setId(this.ow.writeTree(t));
    }

    public void visitGitlink(GitlinkTreeEntry s) throws IOException {
        if (s.isModified()) {
            throw new GitlinksNotSupportedException(s.getFullName());
        }
    }
}

