/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import java.io.IOException;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import org.eclipse.jgit.lib.ByteWindow;
import org.eclipse.jgit.lib.InflaterCache;
import org.eclipse.jgit.lib.PackFile;
import org.eclipse.jgit.lib.WindowCache;

public final class WindowCursor {
    final byte[] tempId = new byte[20];
    private Inflater inf;
    private ByteWindow window;

    int copy(PackFile pack, long position, byte[] dstbuf, int dstoff, int cnt) throws IOException {
        int need;
        int r;
        long length = pack.length;
        for (need = cnt; need > 0 && position < length; need -= r) {
            this.pin(pack, position);
            r = this.window.copy(position, dstbuf, dstoff, need);
            position += (long)r;
            dstoff += r;
        }
        return cnt - need;
    }

    int inflate(PackFile pack, long position, byte[] dstbuf, int dstoff) throws IOException, DataFormatException {
        if (this.inf == null) {
            this.inf = InflaterCache.get();
        } else {
            this.inf.reset();
        }
        while (true) {
            this.pin(pack, position);
            dstoff = this.window.inflate(position, dstbuf, dstoff, this.inf);
            if (this.inf.finished()) {
                return dstoff;
            }
            position = this.window.end;
        }
    }

    void inflateVerify(PackFile pack, long position) throws IOException, DataFormatException {
        if (this.inf == null) {
            this.inf = InflaterCache.get();
        } else {
            this.inf.reset();
        }
        while (true) {
            this.pin(pack, position);
            this.window.inflateVerify(position, this.inf);
            if (this.inf.finished()) {
                return;
            }
            position = this.window.end;
        }
    }

    private void pin(PackFile pack, long position) throws IOException {
        ByteWindow w = this.window;
        if (w == null || !w.contains(pack, position)) {
            this.window = null;
            this.window = WindowCache.get(pack, position);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        this.window = null;
        try {
            InflaterCache.release(this.inf);
        }
        finally {
            this.inf = null;
        }
    }

    public static WindowCursor release(WindowCursor curs) {
        if (curs != null) {
            curs.release();
        }
        return null;
    }
}

