/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.jgit.lib.Tree;
import org.eclipse.jgit.lib.TreeVisitor;

public abstract class TreeVisitorWithCurrentDirectory
implements TreeVisitor {
    private final ArrayList<File> stack = new ArrayList(16);
    private File currentDirectory;

    TreeVisitorWithCurrentDirectory(File rootDirectory) {
        this.currentDirectory = rootDirectory;
    }

    File getCurrentDirectory() {
        return this.currentDirectory;
    }

    public void startVisitTree(Tree t) throws IOException {
        this.stack.add(this.currentDirectory);
        if (!t.isRoot()) {
            this.currentDirectory = new File(this.currentDirectory, t.getName());
        }
    }

    public void endVisitTree(Tree t) throws IOException {
        this.currentDirectory = this.stack.remove(this.stack.size() - 1);
    }
}

