/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum RepositoryState {
    SAFE{

        public boolean canCheckout() {
            return true;
        }

        public boolean canResetHead() {
            return true;
        }

        public boolean canCommit() {
            return true;
        }

        public String getDescription() {
            return "Normal";
        }
    }
    ,
    MERGING{

        public boolean canCheckout() {
            return false;
        }

        public boolean canResetHead() {
            return false;
        }

        public boolean canCommit() {
            return false;
        }

        public String getDescription() {
            return "Conflicts";
        }
    }
    ,
    REBASING{

        public boolean canCheckout() {
            return false;
        }

        public boolean canResetHead() {
            return false;
        }

        public boolean canCommit() {
            return true;
        }

        public String getDescription() {
            return "Rebase/Apply mailbox";
        }
    }
    ,
    REBASING_REBASING{

        public boolean canCheckout() {
            return false;
        }

        public boolean canResetHead() {
            return false;
        }

        public boolean canCommit() {
            return true;
        }

        public String getDescription() {
            return "Rebase";
        }
    }
    ,
    APPLY{

        public boolean canCheckout() {
            return false;
        }

        public boolean canResetHead() {
            return false;
        }

        public boolean canCommit() {
            return true;
        }

        public String getDescription() {
            return "Apply mailbox";
        }
    }
    ,
    REBASING_MERGE{

        public boolean canCheckout() {
            return false;
        }

        public boolean canResetHead() {
            return false;
        }

        public boolean canCommit() {
            return true;
        }

        public String getDescription() {
            return "Rebase w/merge";
        }
    }
    ,
    REBASING_INTERACTIVE{

        public boolean canCheckout() {
            return false;
        }

        public boolean canResetHead() {
            return false;
        }

        public boolean canCommit() {
            return true;
        }

        public String getDescription() {
            return "Rebase interactive";
        }
    }
    ,
    BISECTING{

        public boolean canCheckout() {
            return true;
        }

        public boolean canResetHead() {
            return false;
        }

        public boolean canCommit() {
            return false;
        }

        public String getDescription() {
            return "Bisecting";
        }
    };


    public abstract boolean canCheckout();

    public abstract boolean canCommit();

    public abstract boolean canResetHead();

    public abstract String getDescription();
}

