/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import java.io.IOException;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefLogWriter;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;

public class RefRename {
    private RefUpdate newToUpdate;
    private RefUpdate oldFromDelete;
    private RefUpdate.Result renameResult = RefUpdate.Result.NOT_ATTEMPTED;

    RefRename(RefUpdate toUpdate, RefUpdate fromUpdate) {
        this.newToUpdate = toUpdate;
        this.oldFromDelete = fromUpdate;
    }

    public RefUpdate.Result getResult() {
        return this.renameResult;
    }

    public RefUpdate.Result rename() throws IOException {
        Ref oldRef = this.oldFromDelete.db.readRef("HEAD");
        boolean renameHEADtoo = oldRef != null && oldRef.getName().equals(this.oldFromDelete.getName());
        Repository db = this.oldFromDelete.getRepository();
        RefLogWriter.renameTo(db, this.oldFromDelete, this.newToUpdate);
        this.newToUpdate.setRefLogMessage(null, false);
        String tmpRefName = "RENAMED-REF.." + Thread.currentThread().getId();
        RefUpdate tmpUpdateRef = db.updateRef(tmpRefName);
        if (renameHEADtoo) {
            try {
                this.oldFromDelete.db.link("HEAD", tmpRefName);
            }
            catch (IOException e) {
                RefLogWriter.renameTo(db, this.newToUpdate, this.oldFromDelete);
                this.renameResult = RefUpdate.Result.LOCK_FAILURE;
                return this.renameResult;
            }
        }
        tmpUpdateRef.setNewObjectId(this.oldFromDelete.getOldObjectId());
        tmpUpdateRef.setForceUpdate(true);
        RefUpdate.Result update = tmpUpdateRef.update();
        if (update != RefUpdate.Result.FORCED && update != RefUpdate.Result.NEW && update != RefUpdate.Result.NO_CHANGE) {
            RefLogWriter.renameTo(db, this.newToUpdate, this.oldFromDelete);
            if (renameHEADtoo) {
                this.oldFromDelete.db.link("HEAD", this.oldFromDelete.getName());
            }
            this.renameResult = update;
            return this.renameResult;
        }
        this.oldFromDelete.setExpectedOldObjectId(this.oldFromDelete.getOldObjectId());
        this.oldFromDelete.setForceUpdate(true);
        RefUpdate.Result delete = this.oldFromDelete.delete();
        if (delete != RefUpdate.Result.FORCED) {
            if (db.getRef(this.oldFromDelete.getName()) != null) {
                RefLogWriter.renameTo(db, this.newToUpdate, this.oldFromDelete);
                if (renameHEADtoo) {
                    this.oldFromDelete.db.link("HEAD", this.oldFromDelete.getName());
                }
            }
            this.renameResult = delete;
            return this.renameResult;
        }
        this.newToUpdate.setNewObjectId(tmpUpdateRef.getNewObjectId());
        RefUpdate.Result updateResult = this.newToUpdate.update();
        if (updateResult != RefUpdate.Result.NEW) {
            RefLogWriter.renameTo(db, this.newToUpdate, this.oldFromDelete);
            if (renameHEADtoo) {
                this.oldFromDelete.db.link("HEAD", this.oldFromDelete.getName());
            }
            this.oldFromDelete.setExpectedOldObjectId(null);
            this.oldFromDelete.setNewObjectId(this.oldFromDelete.getOldObjectId());
            this.oldFromDelete.setForceUpdate(true);
            this.oldFromDelete.setRefLogMessage(null, false);
            RefUpdate.Result undelete = this.oldFromDelete.update();
            if (undelete != RefUpdate.Result.NEW && undelete != RefUpdate.Result.LOCK_FAILURE) {
                this.renameResult = RefUpdate.Result.IO_FAILURE;
                return this.renameResult;
            }
            this.renameResult = RefUpdate.Result.LOCK_FAILURE;
            return this.renameResult;
        }
        if (renameHEADtoo) {
            this.oldFromDelete.db.link("HEAD", this.newToUpdate.getName());
        } else {
            db.fireRefsMaybeChanged();
        }
        RefLogWriter.append(this, this.newToUpdate.getName(), "Branch: renamed " + db.shortenRefName(this.oldFromDelete.getName()) + " to " + db.shortenRefName(this.newToUpdate.getName()));
        if (renameHEADtoo) {
            RefLogWriter.append(this, "HEAD", "Branch: renamed " + db.shortenRefName(this.oldFromDelete.getName()) + " to " + db.shortenRefName(this.newToUpdate.getName()));
        }
        this.renameResult = RefUpdate.Result.RENAMED;
        return this.renameResult;
    }

    ObjectId getObjectId() {
        return this.oldFromDelete.getOldObjectId();
    }

    Repository getRepository() {
        return this.oldFromDelete.getRepository();
    }

    PersonIdent getRefLogIdent() {
        return this.newToUpdate.getRefLogIdent();
    }

    String getToName() {
        return this.newToUpdate.getName();
    }
}

