/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.RefRename;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;

public class RefLogWriter {
    static void append(RefUpdate u, String msg) throws IOException {
        ObjectId oldId = u.getOldObjectId();
        ObjectId newId = u.getNewObjectId();
        Repository db = u.getRepository();
        PersonIdent ident = u.getRefLogIdent();
        RefLogWriter.appendOneRecord(oldId, newId, ident, msg, db, u.getName());
        if (!u.getName().equals(u.getOrigName())) {
            RefLogWriter.appendOneRecord(oldId, newId, ident, msg, db, u.getOrigName());
        }
    }

    static void append(RefRename refRename, String logName, String msg) throws IOException {
        ObjectId id = refRename.getObjectId();
        Repository db = refRename.getRepository();
        PersonIdent ident = refRename.getRefLogIdent();
        RefLogWriter.appendOneRecord(id, id, ident, msg, db, logName);
    }

    static void renameTo(Repository db, RefUpdate from, RefUpdate to) throws IOException {
        File logdir = new File(db.getDirectory(), "logs");
        File reflogFrom = new File(logdir, from.getName());
        if (!reflogFrom.exists()) {
            return;
        }
        File reflogTo = new File(logdir, to.getName());
        File reflogToDir = reflogTo.getParentFile();
        File tmp = new File(logdir, "tmp-renamed-log.." + Thread.currentThread().getId());
        if (!reflogFrom.renameTo(tmp)) {
            throw new IOException("Cannot rename " + reflogFrom + " to (" + tmp + ")" + reflogTo);
        }
        RefUpdate.deleteEmptyDir(reflogFrom, RefUpdate.count(from.getName(), '/'));
        if (!reflogToDir.exists() && !reflogToDir.mkdirs()) {
            throw new IOException("Cannot create directory " + reflogToDir);
        }
        if (!tmp.renameTo(reflogTo)) {
            throw new IOException("Cannot rename (" + tmp + ")" + reflogFrom + " to " + reflogTo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void appendOneRecord(ObjectId oldId, ObjectId newId, PersonIdent ident, String msg, Repository db, String refName) throws IOException {
        ident = ident == null ? new PersonIdent(db) : new PersonIdent(ident);
        StringBuilder r = new StringBuilder();
        r.append(ObjectId.toString(oldId));
        r.append(' ');
        r.append(ObjectId.toString(newId));
        r.append(' ');
        r.append(ident.toExternalString());
        r.append('\t');
        r.append(msg);
        r.append('\n');
        byte[] rec = Constants.encode(r.toString());
        File logdir = new File(db.getDirectory(), "logs");
        File reflog = new File(logdir, refName);
        if (reflog.exists() || db.getConfig().getCore().isLogAllRefUpdates()) {
            File refdir = reflog.getParentFile();
            if (!refdir.exists() && !refdir.mkdirs()) {
                throw new IOException("Cannot create directory " + refdir);
            }
            FileOutputStream out = new FileOutputStream(reflog, true);
            try {
                out.write(rec);
                Object var13_12 = null;
            }
            catch (Throwable throwable) {
                Object var13_13 = null;
                out.close();
                throw throwable;
            }
            out.close();
            {
            }
        }
    }

    public static void writeReflog(Repository repo, ObjectId oldCommit, ObjectId commit, String message, String refName) throws IOException {
        RefLogWriter.appendOneRecord(oldCommit, commit, null, message, repo, refName);
    }
}

