/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import java.io.IOException;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.util.zip.CRC32;
import org.eclipse.jgit.lib.Constants;

final class PackOutputStream
extends OutputStream {
    private final OutputStream out;
    private final CRC32 crc = new CRC32();
    private final MessageDigest md = Constants.newMessageDigest();
    private long count;

    PackOutputStream(OutputStream out) {
        this.out = out;
    }

    public void write(int b) throws IOException {
        this.out.write(b);
        this.crc.update(b);
        this.md.update((byte)b);
        ++this.count;
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
        this.crc.update(b, off, len);
        this.md.update(b, off, len);
        this.count += (long)len;
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    long length() {
        return this.count;
    }

    int getCRC32() {
        return (int)this.crc.getValue();
    }

    void resetCRC32() {
        this.crc.reset();
    }

    byte[] getDigest() {
        return this.md.digest();
    }
}

