/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import java.io.IOException;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.Random;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.jgit.lib.PackFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class OffsetCache<V, R extends Ref<V>> {
    private static final Random rng = new Random();
    protected final ReferenceQueue<V> queue;
    private final int tableSize;
    private final AtomicLong clock;
    private final AtomicReferenceArray<Entry<V>> table;
    private final Lock[] locks;
    private final ReentrantLock evictLock;
    private final int evictBatch;

    OffsetCache(int tSize, int lockCount) {
        if (tSize < 1) {
            throw new IllegalArgumentException("tSize must be >= 1");
        }
        if (lockCount < 1) {
            throw new IllegalArgumentException("lockCount must be >= 1");
        }
        this.queue = new ReferenceQueue();
        this.tableSize = tSize;
        this.clock = new AtomicLong(1L);
        this.table = new AtomicReferenceArray(this.tableSize);
        this.locks = new Lock[lockCount];
        for (int i = 0; i < this.locks.length; ++i) {
            this.locks[i] = new Lock();
        }
        this.evictLock = new ReentrantLock();
        int eb = (int)((double)this.tableSize * 0.1);
        if (64 < eb) {
            eb = 64;
        } else if (eb < 4) {
            eb = 4;
        }
        if (this.tableSize < eb) {
            eb = this.tableSize;
        }
        this.evictBatch = eb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    V getOrLoad(PackFile pack, long position) throws IOException {
        int slot = this.slot(pack, position);
        Entry<V> e1 = this.table.get(slot);
        V v = this.scan(e1, pack, position);
        if (v != null) {
            return v;
        }
        Lock lock = this.lock(pack, position);
        synchronized (lock) {
            Entry<V> n;
            Entry<V> e2 = this.table.get(slot);
            if (e2 != e1 && (v = this.scan(e2, pack, position)) != null) {
                return v;
            }
            v = this.load(pack, position);
            R ref = this.createRef(pack, position, v);
            this.hit((Ref<V>)ref);
            while (!this.table.compareAndSet(slot, e2, n = new Entry<V>(OffsetCache.clean(e2), ref))) {
                e2 = this.table.get(slot);
            }
        }
        if (this.evictLock.tryLock()) {
            try {
                this.gc();
                this.evict();
                Object var13_11 = null;
                this.evictLock.unlock();
            }
            catch (Throwable throwable) {
                Object var13_12 = null;
                this.evictLock.unlock();
                throw throwable;
            }
        }
        return v;
    }

    private V scan(Entry<V> n, PackFile pack, long position) {
        while (n != null) {
            Ref r = n.ref;
            if (r.pack == pack && r.position == position) {
                Object v = r.get();
                if (v != null) {
                    this.hit(r);
                    return (V)v;
                }
                n.kill();
                break;
            }
            n = n.next;
        }
        return null;
    }

    private void hit(Ref<V> r) {
        long c = this.clock.get();
        this.clock.compareAndSet(c, c + 1L);
        r.lastAccess = c;
    }

    private void evict() {
        while (this.isFull()) {
            int ptr = rng.nextInt(this.tableSize);
            Entry<V> old = null;
            int slot = 0;
            int b = this.evictBatch - 1;
            while (b >= 0) {
                if (this.tableSize <= ptr) {
                    ptr = 0;
                }
                Entry<V> e = this.table.get(ptr);
                while (e != null) {
                    if (!(e.dead || old != null && e.ref.lastAccess >= old.ref.lastAccess)) {
                        old = e;
                        slot = ptr;
                    }
                    e = e.next;
                }
                --b;
                ++ptr;
            }
            if (old == null) continue;
            old.kill();
            this.gc();
            Entry<V> e1 = this.table.get(slot);
            this.table.compareAndSet(slot, e1, OffsetCache.clean(e1));
        }
    }

    void removeAll() {
        for (int s = 0; s < this.tableSize; ++s) {
            Entry<V> e1;
            do {
                Entry<V> e = e1 = this.table.get(s);
                while (e != null) {
                    e.kill();
                    e = e.next;
                }
            } while (!this.table.compareAndSet(s, e1, null));
        }
        this.gc();
    }

    void removeAll(PackFile pack) {
        for (int s = 0; s < this.tableSize; ++s) {
            Entry<V> e1 = this.table.get(s);
            boolean hasDead = false;
            Entry<V> e = e1;
            while (e != null) {
                if (e.ref.pack == pack) {
                    e.kill();
                    hasDead = true;
                } else if (e.dead) {
                    hasDead = true;
                }
                e = e.next;
            }
            if (!hasDead) continue;
            this.table.compareAndSet(s, e1, OffsetCache.clean(e1));
        }
        this.gc();
    }

    protected abstract V load(PackFile var1, long var2) throws IOException;

    protected R createRef(PackFile pack, long position, V v) {
        return (R)new Ref<V>(pack, position, v, this.queue);
    }

    protected void clear(R ref) {
    }

    protected boolean isFull() {
        return false;
    }

    private void gc() {
        Ref r;
        while ((r = (Ref)this.queue.poll()) != null) {
            Entry<V> e1;
            if (!r.canClear()) continue;
            this.clear(r);
            boolean found = false;
            int s = this.slot(r.pack, r.position);
            Entry<V> n = e1 = this.table.get(s);
            while (n != null) {
                if (n.ref == r) {
                    n.dead = true;
                    found = true;
                    break;
                }
                n = n.next;
            }
            if (!found) continue;
            this.table.compareAndSet(s, e1, OffsetCache.clean(e1));
        }
    }

    protected abstract int hash(int var1, long var2);

    private int slot(PackFile pack, long position) {
        return (this.hash(pack.hash, position) >>> 1) % this.tableSize;
    }

    private Lock lock(PackFile pack, long position) {
        return this.locks[(this.hash(pack.hash, position) >>> 1) % this.locks.length];
    }

    private static <V> Entry<V> clean(Entry<V> top) {
        while (top != null && top.dead) {
            top.ref.enqueue();
            top = top.next;
        }
        if (top == null) {
            return null;
        }
        Entry n = OffsetCache.clean(top.next);
        return n == top.next ? top : new Entry(n, top.ref);
    }

    private static final class Lock {
        private Lock() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class Ref<V>
    extends SoftReference<V> {
        final PackFile pack;
        final long position;
        long lastAccess;
        private boolean cleared;

        protected Ref(PackFile pack, long position, V v, ReferenceQueue<V> queue) {
            super(v, queue);
            this.pack = pack;
            this.position = position;
        }

        final synchronized boolean canClear() {
            if (this.cleared) {
                return false;
            }
            this.cleared = true;
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Entry<V> {
        final Entry<V> next;
        final Ref<V> ref;
        volatile boolean dead;

        Entry(Entry<V> n, Ref<V> r) {
            this.next = n;
            this.ref = r;
        }

        final void kill() {
            this.dead = true;
            this.ref.enqueue();
        }
    }
}

