/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jgit.errors.PackMismatchException;
import org.eclipse.jgit.lib.AlternateRepositoryDatabase;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectDatabase;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.PackFile;
import org.eclipse.jgit.lib.PackedObjectLoader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryCache;
import org.eclipse.jgit.lib.UnpackedObjectLoader;
import org.eclipse.jgit.lib.WindowCursor;
import org.eclipse.jgit.util.FS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectDirectory
extends ObjectDatabase {
    private static final PackList NO_PACKS = new PackList(-1L, -1L, new PackFile[0]);
    private final File objects;
    private final File infoDirectory;
    private final File packDirectory;
    private final File alternatesFile;
    private final AtomicReference<PackList> packList;

    public ObjectDirectory(File dir) {
        this.objects = dir;
        this.infoDirectory = new File(this.objects, "info");
        this.packDirectory = new File(this.objects, "pack");
        this.alternatesFile = new File(this.infoDirectory, "alternates");
        this.packList = new AtomicReference<PackList>(NO_PACKS);
    }

    public final File getDirectory() {
        return this.objects;
    }

    @Override
    public boolean exists() {
        return this.objects.exists();
    }

    @Override
    public void create() throws IOException {
        this.objects.mkdirs();
        this.infoDirectory.mkdir();
        this.packDirectory.mkdir();
    }

    @Override
    public void closeSelf() {
        PackList packs = this.packList.get();
        this.packList.set(NO_PACKS);
        for (PackFile p : packs.packs) {
            p.close();
        }
    }

    public File fileFor(AnyObjectId objectId) {
        return this.fileFor(objectId.name());
    }

    private File fileFor(String objectName) {
        String d = objectName.substring(0, 2);
        String f = objectName.substring(2);
        return new File(new File(this.objects, d), f);
    }

    public void openPack(File pack, File idx) throws IOException {
        String p = pack.getName();
        String i = idx.getName();
        if (p.length() != 50 || !p.startsWith("pack-") || !p.endsWith(".pack")) {
            throw new IOException("Not a valid pack " + pack);
        }
        if (i.length() != 49 || !i.startsWith("pack-") || !i.endsWith(".idx")) {
            throw new IOException("Not a valid pack " + idx);
        }
        if (!p.substring(0, 45).equals(i.substring(0, 45))) {
            throw new IOException("Pack " + pack + "does not match index");
        }
        this.insertPack(new PackFile(idx, pack));
    }

    public String toString() {
        return "ObjectDirectory[" + this.getDirectory() + "]";
    }

    @Override
    protected boolean hasObject1(AnyObjectId objectId) {
        for (PackFile p : this.packList.get().packs) {
            try {
                if (!p.hasObject(objectId)) continue;
                return true;
            }
            catch (IOException e) {
                this.removePack(p);
            }
        }
        return false;
    }

    @Override
    protected ObjectLoader openObject1(WindowCursor curs, AnyObjectId objectId) throws IOException {
        PackList pList = this.packList.get();
        while (true) {
            for (PackFile p : pList.packs) {
                try {
                    PackedObjectLoader ldr = p.get(curs, objectId);
                    if (ldr == null) continue;
                    ldr.materialize(curs);
                    return ldr;
                }
                catch (PackMismatchException e) {
                    pList = this.scanPacks(pList);
                }
                catch (IOException e) {
                    this.removePack(p);
                }
            }
            break;
        }
        return null;
    }

    @Override
    void openObjectInAllPacks1(Collection<PackedObjectLoader> out, WindowCursor curs, AnyObjectId objectId) throws IOException {
        PackList pList = this.packList.get();
        while (true) {
            for (PackFile p : pList.packs) {
                try {
                    PackedObjectLoader ldr = p.get(curs, objectId);
                    if (ldr == null) continue;
                    out.add(ldr);
                }
                catch (PackMismatchException e) {
                    pList = this.scanPacks(pList);
                }
                catch (IOException e) {
                    this.removePack(p);
                }
            }
            break;
        }
    }

    @Override
    protected boolean hasObject2(String objectName) {
        return this.fileFor(objectName).exists();
    }

    @Override
    protected ObjectLoader openObject2(WindowCursor curs, String objectName, AnyObjectId objectId) throws IOException {
        try {
            return new UnpackedObjectLoader(this.fileFor(objectName), objectId);
        }
        catch (FileNotFoundException noFile) {
            return null;
        }
    }

    @Override
    protected boolean tryAgain1() {
        PackList old = this.packList.get();
        if (old.tryAgain(this.packDirectory.lastModified())) {
            return old != this.scanPacks(old);
        }
        return false;
    }

    private void insertPack(PackFile pf) {
        PackFile[] newList;
        PackList n;
        PackList o;
        do {
            o = this.packList.get();
            PackFile[] oldList = o.packs;
            newList = new PackFile[1 + oldList.length];
            newList[0] = pf;
            System.arraycopy(oldList, 0, newList, 1, oldList.length);
        } while (!this.packList.compareAndSet(o, n = new PackList(o.lastRead, o.lastModified, newList)));
    }

    private void removePack(PackFile deadPack) {
        PackFile[] newList;
        PackList n;
        PackList o;
        do {
            o = this.packList.get();
            PackFile[] oldList = o.packs;
            int j = ObjectDirectory.indexOf(oldList, deadPack);
            if (j < 0) break;
            newList = new PackFile[oldList.length - 1];
            System.arraycopy(oldList, 0, newList, 0, j);
            System.arraycopy(oldList, j + 1, newList, j, newList.length - j);
        } while (!this.packList.compareAndSet(o, n = new PackList(o.lastRead, o.lastModified, newList)));
        deadPack.close();
    }

    private static int indexOf(PackFile[] list, PackFile pack) {
        for (int i = 0; i < list.length; ++i) {
            if (list[i] != pack) continue;
            return i;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PackList scanPacks(PackList original) {
        AtomicReference<PackList> atomicReference = this.packList;
        synchronized (atomicReference) {
            PackList n;
            PackList o;
            do {
                if ((o = this.packList.get()) != original) {
                    return o;
                }
                n = this.scanPacksImpl(o);
                if (n != o) continue;
                return n;
            } while (!this.packList.compareAndSet(o, n));
            return n;
        }
    }

    private PackList scanPacksImpl(PackList old) {
        Map<String, PackFile> forReuse = ObjectDirectory.reuseMap(old);
        long lastRead = System.currentTimeMillis();
        long lastModified = this.packDirectory.lastModified();
        Set<String> names = this.listPackDirectory();
        ArrayList<PackFile> list = new ArrayList<PackFile>(names.size() >> 2);
        boolean foundNew = false;
        for (String indexName : names) {
            String base;
            String packName;
            if (indexName.length() != 49 || !indexName.endsWith(".idx") || !names.contains(packName = (base = indexName.substring(0, indexName.length() - 4)) + ".pack")) continue;
            PackFile oldPack = forReuse.remove(packName);
            if (oldPack != null) {
                list.add(oldPack);
                continue;
            }
            File packFile = new File(this.packDirectory, packName);
            File idxFile = new File(this.packDirectory, indexName);
            list.add(new PackFile(idxFile, packFile));
            foundNew = true;
        }
        if (!foundNew && lastModified == old.lastModified && forReuse.isEmpty()) {
            return old.updateLastRead(lastRead);
        }
        for (PackFile p : forReuse.values()) {
            p.close();
        }
        if (list.isEmpty()) {
            return new PackList(lastRead, lastModified, ObjectDirectory.NO_PACKS.packs);
        }
        PackFile[] r = list.toArray(new PackFile[list.size()]);
        Arrays.sort(r, PackFile.SORT);
        return new PackList(lastRead, lastModified, r);
    }

    private static Map<String, PackFile> reuseMap(PackList old) {
        HashMap<String, PackFile> forReuse = new HashMap<String, PackFile>();
        for (PackFile p : old.packs) {
            if (p.invalid()) {
                p.close();
                continue;
            }
            PackFile prior = forReuse.put(p.getPackFile().getName(), p);
            if (prior == null) continue;
            prior.close();
        }
        return forReuse;
    }

    private Set<String> listPackDirectory() {
        String[] nameList = this.packDirectory.list();
        if (nameList == null) {
            return Collections.emptySet();
        }
        HashSet<String> nameSet = new HashSet<String>(nameList.length << 1);
        for (String name : nameList) {
            if (!name.startsWith("pack-")) continue;
            nameSet.add(name);
        }
        return nameSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ObjectDatabase[] loadAlternates() throws IOException {
        BufferedReader br = ObjectDirectory.open(this.alternatesFile);
        ArrayList<ObjectDatabase> l = new ArrayList<ObjectDatabase>(4);
        try {
            String line;
            while ((line = br.readLine()) != null) {
                l.add(this.openAlternate(line));
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            br.close();
            throw throwable;
        }
        br.close();
        if (l.isEmpty()) {
            return NO_ALTERNATES;
        }
        return l.toArray(new ObjectDatabase[l.size()]);
    }

    private static BufferedReader open(File f) throws FileNotFoundException {
        return new BufferedReader(new FileReader(f));
    }

    private ObjectDatabase openAlternate(String location) throws IOException {
        File objdir = FS.resolve(this.objects, location);
        File parent = objdir.getParentFile();
        if (RepositoryCache.FileKey.isGitRepository(parent)) {
            Repository db = RepositoryCache.open(RepositoryCache.FileKey.exact(parent));
            return new AlternateRepositoryDatabase(db);
        }
        return new ObjectDirectory(objdir);
    }

    private static final class PackList {
        volatile long lastRead;
        final long lastModified;
        final PackFile[] packs;
        private boolean cannotBeRacilyClean;

        PackList(long lastRead, long lastModified, PackFile[] packs) {
            this.lastRead = lastRead;
            this.lastModified = lastModified;
            this.packs = packs;
            this.cannotBeRacilyClean = this.notRacyClean(lastRead);
        }

        private boolean notRacyClean(long read) {
            return read - this.lastModified > 120000L;
        }

        PackList updateLastRead(long now) {
            if (this.notRacyClean(now)) {
                this.cannotBeRacilyClean = true;
            }
            this.lastRead = now;
            return this;
        }

        boolean tryAgain(long currLastModified) {
            if (this.lastModified != currLastModified) {
                return true;
            }
            if (this.cannotBeRacilyClean) {
                return false;
            }
            return !this.notRacyClean(this.lastRead);
        }
    }
}

