/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import java.io.IOException;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.PackedObjectLoader;
import org.eclipse.jgit.lib.WindowCursor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ObjectDatabase {
    protected static final ObjectDatabase[] NO_ALTERNATES = new ObjectDatabase[0];
    private final AtomicReference<ObjectDatabase[]> alternates = new AtomicReference();

    protected ObjectDatabase() {
    }

    public boolean exists() {
        return true;
    }

    public void create() throws IOException {
    }

    public final void close() {
        this.closeSelf();
        this.closeAlternates();
    }

    public void closeSelf() {
    }

    public final void closeAlternates() {
        ObjectDatabase[] alt = this.alternates.get();
        if (alt != null) {
            this.alternates.set(null);
            this.closeAlternates(alt);
        }
    }

    public final boolean hasObject(AnyObjectId objectId) {
        return this.hasObjectImpl1(objectId) || this.hasObjectImpl2(objectId.name());
    }

    private final boolean hasObjectImpl1(AnyObjectId objectId) {
        if (this.hasObject1(objectId)) {
            return true;
        }
        for (ObjectDatabase alt : this.getAlternates()) {
            if (!alt.hasObjectImpl1(objectId)) continue;
            return true;
        }
        return this.tryAgain1() && this.hasObject1(objectId);
    }

    private final boolean hasObjectImpl2(String objectId) {
        if (this.hasObject2(objectId)) {
            return true;
        }
        for (ObjectDatabase alt : this.getAlternates()) {
            if (!alt.hasObjectImpl2(objectId)) continue;
            return true;
        }
        return false;
    }

    protected abstract boolean hasObject1(AnyObjectId var1);

    protected boolean hasObject2(String objectName) {
        return false;
    }

    public final ObjectLoader openObject(WindowCursor curs, AnyObjectId objectId) throws IOException {
        ObjectLoader ldr = this.openObjectImpl1(curs, objectId);
        if (ldr != null) {
            return ldr;
        }
        ldr = this.openObjectImpl2(curs, objectId.name(), objectId);
        if (ldr != null) {
            return ldr;
        }
        return null;
    }

    private ObjectLoader openObjectImpl1(WindowCursor curs, AnyObjectId objectId) throws IOException {
        ObjectLoader ldr = this.openObject1(curs, objectId);
        if (ldr != null) {
            return ldr;
        }
        for (ObjectDatabase alt : this.getAlternates()) {
            ldr = alt.openObjectImpl1(curs, objectId);
            if (ldr == null) continue;
            return ldr;
        }
        if (this.tryAgain1() && (ldr = this.openObject1(curs, objectId)) != null) {
            return ldr;
        }
        return null;
    }

    private ObjectLoader openObjectImpl2(WindowCursor curs, String objectName, AnyObjectId objectId) throws IOException {
        ObjectLoader ldr = this.openObject2(curs, objectName, objectId);
        if (ldr != null) {
            return ldr;
        }
        for (ObjectDatabase alt : this.getAlternates()) {
            ldr = alt.openObjectImpl2(curs, objectName, objectId);
            if (ldr == null) continue;
            return ldr;
        }
        return null;
    }

    protected abstract ObjectLoader openObject1(WindowCursor var1, AnyObjectId var2) throws IOException;

    protected ObjectLoader openObject2(WindowCursor curs, String objectName, AnyObjectId objectId) throws IOException {
        return null;
    }

    final void openObjectInAllPacks(Collection<PackedObjectLoader> out, WindowCursor curs, AnyObjectId objectId) throws IOException {
        this.openObjectInAllPacks1(out, curs, objectId);
        for (ObjectDatabase alt : this.getAlternates()) {
            alt.openObjectInAllPacks1(out, curs, objectId);
        }
    }

    void openObjectInAllPacks1(Collection<PackedObjectLoader> out, WindowCursor curs, AnyObjectId objectId) throws IOException {
    }

    protected boolean tryAgain1() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ObjectDatabase[] getAlternates() {
        ObjectDatabase[] r = this.alternates.get();
        if (r == null) {
            AtomicReference<ObjectDatabase[]> atomicReference = this.alternates;
            synchronized (atomicReference) {
                r = this.alternates.get();
                if (r == null) {
                    try {
                        r = this.loadAlternates();
                    }
                    catch (IOException e) {
                        r = NO_ALTERNATES;
                    }
                    this.alternates.set(r);
                }
            }
        }
        return r;
    }

    protected ObjectDatabase[] loadAlternates() throws IOException {
        return NO_ALTERNATES;
    }

    protected void closeAlternates(ObjectDatabase[] alt) {
        for (ObjectDatabase d : alt) {
            d.close();
        }
    }
}

