/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.LockFile;
import org.eclipse.jgit.util.IO;
import org.eclipse.jgit.util.RawParseUtils;

public class FileBasedConfig
extends Config {
    private final File configFile;

    public FileBasedConfig(File cfgLocation) {
        this(null, cfgLocation);
    }

    public FileBasedConfig(Config base, File cfgLocation) {
        super(base);
        this.configFile = cfgLocation;
    }

    public final File getFile() {
        return this.configFile;
    }

    public void load() throws IOException, ConfigInvalidException {
        try {
            this.fromText(RawParseUtils.decode(IO.readFully(this.getFile())));
        }
        catch (FileNotFoundException noFile) {
            this.clear();
        }
        catch (IOException e) {
            IOException e2 = new IOException("Cannot read " + this.getFile());
            e2.initCause(e);
            throw e2;
        }
        catch (ConfigInvalidException e) {
            throw new ConfigInvalidException("Cannot read " + this.getFile(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() throws IOException {
        byte[] out = Constants.encode(this.toText());
        LockFile lf = new LockFile(this.getFile());
        if (!lf.lock()) {
            throw new IOException("Cannot lock " + this.getFile());
        }
        try {
            lf.write(out);
            if (!lf.commit()) {
                throw new IOException("Cannot commit write to " + this.getFile());
            }
            Object var4_3 = null;
            lf.unlock();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            lf.unlock();
            throw throwable;
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getFile().getPath() + "]";
    }
}

