/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import java.io.IOException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.DeltaPackedObjectLoader;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.PackFile;
import org.eclipse.jgit.lib.PackedObjectLoader;
import org.eclipse.jgit.lib.WindowCursor;

class DeltaRefPackedObjectLoader
extends DeltaPackedObjectLoader {
    private final ObjectId deltaBase;

    DeltaRefPackedObjectLoader(PackFile pr, long dataOffset, long objectOffset, int deltaSz, ObjectId base) {
        super(pr, dataOffset, objectOffset, deltaSz);
        this.deltaBase = base;
    }

    protected PackedObjectLoader getBaseLoader(WindowCursor curs) throws IOException {
        PackedObjectLoader or = this.pack.get(curs, this.deltaBase);
        if (or == null) {
            throw new MissingObjectException(this.deltaBase, "delta base");
        }
        return or;
    }

    public int getRawType() {
        return 7;
    }

    public ObjectId getDeltaBase() throws IOException {
        return this.deltaBase;
    }
}

