/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import java.io.IOException;
import org.eclipse.jgit.errors.CorruptObjectException;
import org.eclipse.jgit.lib.DeltaPackedObjectLoader;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.PackFile;
import org.eclipse.jgit.lib.PackedObjectLoader;
import org.eclipse.jgit.lib.WindowCursor;

class DeltaOfsPackedObjectLoader
extends DeltaPackedObjectLoader {
    private final long deltaBase;

    DeltaOfsPackedObjectLoader(PackFile pr, long dataOffset, long objectOffset, int deltaSz, long base) {
        super(pr, dataOffset, objectOffset, deltaSz);
        this.deltaBase = base;
    }

    protected PackedObjectLoader getBaseLoader(WindowCursor curs) throws IOException {
        return this.pack.resolveBase(curs, this.deltaBase);
    }

    public int getRawType() {
        return 6;
    }

    public ObjectId getDeltaBase() throws IOException {
        ObjectId id = this.pack.findObjectForOffset(this.deltaBase);
        if (id == null) {
            throw new CorruptObjectException("Offset-written delta base for object not found in a pack");
        }
        return id;
    }
}

