/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import org.eclipse.jgit.lib.PackFile;

abstract class ByteWindow {
    protected final PackFile pack;
    protected final long start;
    protected final long end;
    protected static final byte[] verifyGarbageBuffer = new byte[2048];

    protected ByteWindow(PackFile p, long s, int n) {
        this.pack = p;
        this.start = s;
        this.end = this.start + (long)n;
    }

    final int size() {
        return (int)(this.end - this.start);
    }

    final boolean contains(PackFile neededFile, long neededPos) {
        return this.pack == neededFile && this.start <= neededPos && neededPos < this.end;
    }

    final int copy(long pos, byte[] dstbuf, int dstoff, int cnt) {
        return this.copy((int)(pos - this.start), dstbuf, dstoff, cnt);
    }

    protected abstract int copy(int var1, byte[] var2, int var3, int var4);

    final int inflate(long pos, byte[] dstbuf, int dstoff, Inflater inf) throws DataFormatException {
        return this.inflate((int)(pos - this.start), dstbuf, dstoff, inf);
    }

    protected abstract int inflate(int var1, byte[] var2, int var3, Inflater var4) throws DataFormatException;

    final void inflateVerify(long pos, Inflater inf) throws DataFormatException {
        this.inflateVerify((int)(pos - this.start), inf);
    }

    protected abstract void inflateVerify(int var1, Inflater var2) throws DataFormatException;
}

