/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import java.nio.ByteBuffer;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import org.eclipse.jgit.lib.ByteWindow;
import org.eclipse.jgit.lib.PackFile;

final class ByteBufferWindow
extends ByteWindow {
    private final ByteBuffer buffer;

    ByteBufferWindow(PackFile pack, long o, ByteBuffer b) {
        super(pack, o, b.capacity());
        this.buffer = b;
    }

    protected int copy(int p, byte[] b, int o, int n) {
        ByteBuffer s = this.buffer.slice();
        s.position(p);
        n = Math.min(s.remaining(), n);
        s.get(b, o, n);
        return n;
    }

    protected int inflate(int pos, byte[] b, int o, Inflater inf) throws DataFormatException {
        byte[] tmp = new byte[512];
        ByteBuffer s = this.buffer.slice();
        s.position(pos);
        while (s.remaining() > 0 && !inf.finished()) {
            if (inf.needsInput()) {
                int n = Math.min(s.remaining(), tmp.length);
                s.get(tmp, 0, n);
                inf.setInput(tmp, 0, n);
            }
            o += inf.inflate(b, o, b.length - o);
        }
        while (!inf.finished() && !inf.needsInput()) {
            o += inf.inflate(b, o, b.length - o);
        }
        return o;
    }

    protected void inflateVerify(int pos, Inflater inf) throws DataFormatException {
        byte[] tmp = new byte[512];
        ByteBuffer s = this.buffer.slice();
        s.position(pos);
        while (s.remaining() > 0 && !inf.finished()) {
            if (inf.needsInput()) {
                int n = Math.min(s.remaining(), tmp.length);
                s.get(tmp, 0, n);
                inf.setInput(tmp, 0, n);
            }
            inf.inflate(verifyGarbageBuffer, 0, verifyGarbageBuffer.length);
        }
        while (!inf.finished() && !inf.needsInput()) {
            inf.inflate(verifyGarbageBuffer, 0, verifyGarbageBuffer.length);
        }
    }
}

