/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import org.eclipse.jgit.lib.ByteWindow;
import org.eclipse.jgit.lib.PackFile;

final class ByteArrayWindow
extends ByteWindow {
    private final byte[] array;

    ByteArrayWindow(PackFile pack, long o, byte[] b) {
        super(pack, o, b.length);
        this.array = b;
    }

    protected int copy(int p, byte[] b, int o, int n) {
        n = Math.min(this.array.length - p, n);
        System.arraycopy(this.array, p, b, o, n);
        return n;
    }

    protected int inflate(int pos, byte[] b, int o, Inflater inf) throws DataFormatException {
        while (!inf.finished()) {
            if (inf.needsInput()) {
                inf.setInput(this.array, pos, this.array.length - pos);
                break;
            }
            o += inf.inflate(b, o, b.length - o);
        }
        while (!inf.finished() && !inf.needsInput()) {
            o += inf.inflate(b, o, b.length - o);
        }
        return o;
    }

    protected void inflateVerify(int pos, Inflater inf) throws DataFormatException {
        while (!inf.finished()) {
            if (inf.needsInput()) {
                inf.setInput(this.array, pos, this.array.length - pos);
                break;
            }
            inf.inflate(verifyGarbageBuffer, 0, verifyGarbageBuffer.length);
        }
        while (!inf.finished() && !inf.needsInput()) {
            inf.inflate(verifyGarbageBuffer, 0, verifyGarbageBuffer.length);
        }
    }
}

